// OptionDlg.cpp : implementation file
//

#include "stdafx.h"
#include "MP3Tool.h"
#include "OptionDlg.h"

/////////////////////////////////////////////////////////////////////////////
// COptionDlg dialog

COptionDlg::COptionDlg(CWnd* pParent /*=NULL*/)
: CDialog(COptionDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(COptionDlg)
	//}}AFX_DATA_INIT
}

void COptionDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COptionDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(COptionDlg, CDialog)
//{{AFX_MSG_MAP(COptionDlg)
ON_BN_CLICKED(IDC_RENAME, OnRename)
ON_BN_CLICKED(IDC_TYP_M, OnTypM)
ON_BN_CLICKED(IDC_TYP_B, OnTypB)
ON_BN_CLICKED(IDC_TYP_X, OnTypX)
ON_BN_CLICKED(IDC_DEL_BACK, OnDelBack)
ON_BN_CLICKED(IDC_DEL_FRONT, OnDelFront)
	ON_BN_CLICKED(IDC_DEL_COPY, OnDelCopy)
	ON_BN_CLICKED(IDC_SET_ORIG, OnSetOrig)
	ON_BN_CLICKED(IDC_SET_ID3, OnSetId3)
	ON_BN_CLICKED(IDC_SCAN_ALL, OnScanAll)
	ON_BN_CLICKED(IDC_SET_ID3_V2, OnSetId3V2)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COptionDlg message handlers

void COptionDlg::OnRename() 
{
	BOOL dorename = (((CButton*)GetDlgItem(IDC_RENAME))->GetCheck()==BST_CHECKED);
	GetDlgItem(IDC_TYP_M)->EnableWindow(dorename);
	GetDlgItem(IDC_TYP_B)->EnableWindow(dorename);
	GetDlgItem(IDC_TYP_X)->EnableWindow(dorename);
	if ((((CButton*)GetDlgItem(IDC_TYP_X))->GetCheck()==BST_CHECKED))
	{
		GetDlgItem(IDC_CNV_UML)->EnableWindow(dorename);	
		GetDlgItem(IDC_CNV_AMP)->EnableWindow(dorename);	
		GetDlgItem(IDC_CNV_SONDER)->EnableWindow(dorename);	
		GetDlgItem(IDC_CNV_SPACE)->EnableWindow(dorename);	
		GetDlgItem(IDC_DATNAME)->EnableWindow(dorename);	
	}
}

void COptionDlg::OnTypM() 
{
	GetDlgItem(IDC_CNV_UML)->EnableWindow(false);	
	GetDlgItem(IDC_CNV_AMP)->EnableWindow(false);	
	GetDlgItem(IDC_CNV_SONDER)->EnableWindow(false);	
	GetDlgItem(IDC_CNV_SPACE)->EnableWindow(false);	
	((CButton*)GetDlgItem(IDC_CNV_UML))->SetCheck(BST_UNCHECKED);	
	((CButton*)GetDlgItem(IDC_CNV_AMP))->SetCheck(BST_UNCHECKED);	
	((CButton*)GetDlgItem(IDC_CNV_SONDER))->SetCheck(BST_UNCHECKED);	
	((CButton*)GetDlgItem(IDC_CNV_SPACE))->SetCheck(BST_UNCHECKED);	
	GetDlgItem(IDC_DATNAME)->EnableWindow(false);	
	GetDlgItem(IDC_DATNAME)->SetWindowText("$Track - $Artist - $Title");	
}

void COptionDlg::OnTypB() 
{
	GetDlgItem(IDC_CNV_UML)->EnableWindow(false);	
	GetDlgItem(IDC_CNV_AMP)->EnableWindow(false);	
	GetDlgItem(IDC_CNV_SONDER)->EnableWindow(false);	
	GetDlgItem(IDC_CNV_SPACE)->EnableWindow(false);	
	((CButton*)GetDlgItem(IDC_CNV_UML))->SetCheck(BST_CHECKED);	
	((CButton*)GetDlgItem(IDC_CNV_AMP))->SetCheck(BST_CHECKED);	
	((CButton*)GetDlgItem(IDC_CNV_SONDER))->SetCheck(BST_CHECKED);	
	((CButton*)GetDlgItem(IDC_CNV_SPACE))->SetCheck(BST_CHECKED);	
	GetDlgItem(IDC_DATNAME)->EnableWindow(false);	
	GetDlgItem(IDC_DATNAME)->SetWindowText(_T("$Artist-$Title"));	
}

void COptionDlg::OnTypX() 
{
	GetDlgItem(IDC_CNV_UML)->EnableWindow(true);	
	GetDlgItem(IDC_CNV_AMP)->EnableWindow(true);	
	GetDlgItem(IDC_CNV_SONDER)->EnableWindow(true);	
	GetDlgItem(IDC_CNV_SPACE)->EnableWindow(true);	
	GetDlgItem(IDC_DATNAME)->EnableWindow(true);	
}

BOOL COptionDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	CWinApp* pApp = AfxGetApp();
	((CButton*)GetDlgItem(IDC_DEL_FRONT))->SetCheck((BOOL)(pApp->GetProfileInt("","DelFront",1)));
	((CButton*)GetDlgItem(IDC_DEL_COPY))->SetCheck((BOOL)(pApp->GetProfileInt("","DelCopy",1)));	
	((CButton*)GetDlgItem(IDC_SET_ORIG))->SetCheck((BOOL)(pApp->GetProfileInt("","SetOrig",1)));	
	((CButton*)GetDlgItem(IDC_DEL_BACK))->SetCheck((BOOL)(pApp->GetProfileInt("","DelBack",1)));	
	((CButton*)GetDlgItem(IDC_SET_ID3))->SetCheck((BOOL)(pApp->GetProfileInt("","SetID3",1)));	
	((CButton*)GetDlgItem(IDC_SET_ID3_V2))->SetCheck((BOOL)(pApp->GetProfileInt("","SetID3V2",1)));	
	((CButton*)GetDlgItem(IDC_FORCE_GET))->SetCheck((BOOL)(pApp->GetProfileInt("","ForceGet",0)));	
	((CButton*)GetDlgItem(IDC_CHK_ALL))->SetCheck((BOOL)(pApp->GetProfileInt("","ChkAll",1)));	
	((CButton*)GetDlgItem(IDC_RENAME))->SetCheck((BOOL)(pApp->GetProfileInt("","Rename",1)));
	int rentyp =pApp->GetProfileInt("","TypMBX",1);
	((CButton*)GetDlgItem(IDC_TYP_M))->SetCheck(rentyp==0);	
	((CButton*)GetDlgItem(IDC_TYP_B))->SetCheck(rentyp==1);	
	((CButton*)GetDlgItem(IDC_TYP_X))->SetCheck(rentyp==2);
	switch (rentyp)
	{
	case 0:
		OnTypM();
		break;
	case 1:
		OnTypB();
		break;
	case 2:
		OnTypX();
		((CButton*)GetDlgItem(IDC_CNV_UML))->SetCheck((BOOL)(pApp->GetProfileInt("","CnvUml",1)));
		((CButton*)GetDlgItem(IDC_CNV_AMP))->SetCheck((BOOL)(pApp->GetProfileInt("","CnvAmp",1)));
		((CButton*)GetDlgItem(IDC_CNV_SONDER))->SetCheck((BOOL)(pApp->GetProfileInt("","CnvSonder",1)));
		((CButton*)GetDlgItem(IDC_CNV_SPACE))->SetCheck((BOOL)(pApp->GetProfileInt("","CnvSpace",1)));
		GetDlgItem(IDC_DATNAME)->SetWindowText(pApp->GetProfileString("","ID2DatNam",_T("$Artist-$Title")));
	}
	OnRename();
	return true; 
}

void COptionDlg::OnOK() 
{
	CWinApp* pApp = AfxGetApp();
	pApp->WriteProfileInt("","DelFront",(int)((CButton*)GetDlgItem(IDC_DEL_FRONT))->GetCheck());
	pApp->WriteProfileInt("","DelCopy",(int)((CButton*)GetDlgItem(IDC_DEL_COPY))->GetCheck());
	pApp->WriteProfileInt("","SetOrig",(int)((CButton*)GetDlgItem(IDC_SET_ORIG))->GetCheck());
	pApp->WriteProfileInt("","DelBack",(int)((CButton*)GetDlgItem(IDC_DEL_BACK))->GetCheck());
	pApp->WriteProfileInt("","SetID3",(int)((CButton*)GetDlgItem(IDC_SET_ID3))->GetCheck());
	pApp->WriteProfileInt("","SetID3V2",(int)((CButton*)GetDlgItem(IDC_SET_ID3_V2))->GetCheck());
	pApp->WriteProfileInt("","ChkAll",(int)((CButton*)GetDlgItem(IDC_CHK_ALL))->GetCheck());
	pApp->WriteProfileInt("","ForceGet",(int)((CButton*)GetDlgItem(IDC_FORCE_GET))->GetCheck());
	pApp->WriteProfileInt("","Rename",(int)((CButton*)GetDlgItem(IDC_RENAME))->GetCheck());
	pApp->WriteProfileInt("","TypMBX",2*((int)((CButton*)GetDlgItem(IDC_TYP_X))->GetCheck())+((int)((CButton*)GetDlgItem(IDC_TYP_B))->GetCheck()));
	pApp->WriteProfileInt("","CnvUml",(int)((CButton*)GetDlgItem(IDC_CNV_UML))->GetCheck());
	pApp->WriteProfileInt("","CnvAmp",(int)((CButton*)GetDlgItem(IDC_CNV_AMP))->GetCheck());
	pApp->WriteProfileInt("","CnvSonder",(int)((CButton*)GetDlgItem(IDC_CNV_SONDER))->GetCheck());
	pApp->WriteProfileInt("","CnvSpace",(int)((CButton*)GetDlgItem(IDC_CNV_SPACE))->GetCheck());
	LPTSTR mydatnam = new char[50];
	GetDlgItem(IDC_DATNAME)->GetWindowText(mydatnam,50);
	pApp->WriteProfileString("","ID2DatNam",mydatnam);
	delete mydatnam;
	//2do: fr jeden eintrag UpdateChanged() aufrufen... damit die Farbe stimmt
	CDialog::OnOK();
}

void COptionDlg::OnDelBack() 
{
	// ID3 schreibe ich nur, wenn ich Mist direkt davor lschen kann
	if (!((CButton*)GetDlgItem(IDC_DEL_BACK))->GetCheck())
	{
		((CButton*)GetDlgItem(IDC_SET_ID3))->SetCheck(false);
	}
}

void COptionDlg::OnDelFront() 
{
	//Front loeschen zerstoert die Brava-Links, also die mit weg
	if (((CButton*)GetDlgItem(IDC_DEL_FRONT))->GetCheck())
	{
		((CButton*)GetDlgItem(IDC_DEL_BACK))->SetCheck(true);
		((CButton*)GetDlgItem(IDC_SCAN_ALL))->SetCheck(true);
	}
	else
	{
		//Frames bearbeiten geht nur mit Front lschen
		((CButton*)GetDlgItem(IDC_DEL_COPY))->SetCheck(false);
		((CButton*)GetDlgItem(IDC_SET_ORIG))->SetCheck(false);
	}
  //ID3V2 schreibe ich nur, wenn ich dahinter loeschen kann
	if (!((CButton*)GetDlgItem(IDC_DEL_FRONT))->GetCheck())
	{
		((CButton*)GetDlgItem(IDC_SET_ID3_V2))->SetCheck(false);
	}
}

void COptionDlg::OnDelCopy() 
{
	// Geht nur, wenn Frontkill erlaubt ist und nur mit gescannten
	if (((CButton*)GetDlgItem(IDC_DEL_COPY))->GetCheck())
	{
		((CButton*)GetDlgItem(IDC_DEL_FRONT))->SetCheck(true);
		((CButton*)GetDlgItem(IDC_SCAN_ALL))->SetCheck(true);
	}
}

void COptionDlg::OnSetOrig() 
{
	// Geht nur, wenn Frontkill erlaubt ist und nur mit gescannten
	if (((CButton*)GetDlgItem(IDC_SET_ORIG))->GetCheck())
	{
		((CButton*)GetDlgItem(IDC_DEL_FRONT))->SetCheck(true);
		((CButton*)GetDlgItem(IDC_SCAN_ALL))->SetCheck(true);
	}
}

void COptionDlg::OnSetId3() 
{
	// ID3 schreibe ich nur, wenn ich Mist direkt davor lschen kann
	if (((CButton*)GetDlgItem(IDC_SET_ID3))->GetCheck())
	{
		((CButton*)GetDlgItem(IDC_DEL_BACK))->SetCheck(true);
	}
}

void COptionDlg::OnScanAll() 
{
	//kein Scan -> keine nderungen!
	if (!(((CButton*)GetDlgItem(IDC_SCAN_ALL))->GetCheck()))
	{
		((CButton*)GetDlgItem(IDC_DEL_FRONT))->SetCheck(false);
		((CButton*)GetDlgItem(IDC_SET_ORIG))->SetCheck(false);
		((CButton*)GetDlgItem(IDC_DEL_COPY))->SetCheck(false);
	}
}

void COptionDlg::OnSetId3V2() 
{
	// ID3V2 schreibe ich nur, wenn ich Mist davor/danach loeschen kann
	if (((CButton*)GetDlgItem(IDC_SET_ID3_V2))->GetCheck())
	{
		((CButton*)GetDlgItem(IDC_DEL_FRONT))->SetCheck(true);
	}
}
