// MP3ToolView.cpp : implementation of the CMP3ToolView class
//

#include "stdafx.h"
#include "MP3Tool.h"
#include "MP3ToolDoc.h"
#include "MP3ToolView.h"
#include "AutoDlg.h"
#include "ExistsDlg.h"

/////////////////////////////////////////////////////////////////////////////
// CMP3ToolView

IMPLEMENT_DYNCREATE(CMP3ToolView, CListView)

BEGIN_MESSAGE_MAP(CMP3ToolView, CListView)
//{{AFX_MSG_MAP(CMP3ToolView)
ON_WM_SETFOCUS()
ON_WM_KILLFOCUS()
ON_COMMAND(ID_VIEW_STATEICONS, OnViewStateIcons)
ON_UPDATE_COMMAND_UI(ID_VIEW_STATEICONS, OnUpdateViewStateIcons)
ON_WM_LBUTTONDOWN()
ON_WM_LBUTTONDBLCLK()
ON_NOTIFY_REFLECT(LVN_COLUMNCLICK, OnColumnclick)
ON_COMMAND(ID_EXP_XLS, OnExpXls)
ON_COMMAND(ID_AUTO_EDIT, OnAutoEdit)
ON_COMMAND(ID_MAN_EDIT, OnManEdit)
ON_WM_KEYDOWN()
ON_WM_KEYUP()
ON_WM_CONTEXTMENU()
ON_COMMAND(ID_PLAY, OnPlay)
ON_COMMAND(ID_EXP_M3U, OnExpWinamp)
ON_COMMAND(ID_DEL_ENTRY, OnDelEntry)
ON_COMMAND(ID_EXP_TXT, OnExpTxt)
ON_COMMAND(ID_MAKE_COVER, OnMakeCover)
ON_COMMAND(ID_SEARCH_FULL, OnSearchFull)
ON_COMMAND(ID_SEARCH_SIM, OnSearchSim)
ON_COMMAND(ID_SEARCH_RESET, OnSearchReset)
ON_WM_SIZE()
ON_COMMAND(ID_MOVE, OnMove)
//}}AFX_MSG_MAP
// Standard printing commands
ON_COMMAND(ID_FILE_PRINT, CListView::OnFilePrint)
ON_COMMAND(ID_FILE_PRINT_DIRECT, CListView::OnFilePrint)
ON_COMMAND(ID_FILE_PRINT_PREVIEW, CListView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMP3ToolView construction/destruction

CMP3ToolView::CMP3ToolView()
{
  m_bStateIcons = false;
  m_bStrg=false;
  
  m_clrText = ::GetSysColor(COLOR_WINDOWTEXT);
  m_clrTextBk = ::GetSysColor(COLOR_WINDOW);
  m_clrBkgnd = ::GetSysColor(COLOR_WINDOW);
  
  tabelle_schon_initialisiert = false;
}

CMP3ToolView::~CMP3ToolView()
{
}

BOOL CMP3ToolView::PreCreateWindow(CREATESTRUCT& cs)
{
  // default is report view and full row selection
  cs.style |= LVS_SHOWSELALWAYS | LVS_REPORT;
  cs.style &= ~LVS_TYPEMASK;
  cs.style |= LVS_REPORT | LVS_OWNERDRAWFIXED;
  
  return CListView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMP3ToolView initialization

void CMP3ToolView::UpdateViewEntry(int i)
{
  CListCtrl& ListCtrl = GetListCtrl();
  CMP3ToolEntry* entry=(CMP3ToolEntry*)(ListCtrl.GetItemData(i));
  for(int j=0; j<NUM_COLUMNS; j++)
  {
    ListCtrl.SetItemText(i,j,GetDocument()->GetItem(entry,j));
  }
}

void CMP3ToolView::InsertEntry(CMP3ToolEntry* entry, BOOL checkdouble, int* state)
{
  if (checkdouble)
  {
    int nItem;
    for(nItem = GetListCtrl().GetNextItem(-1, LVNI_ALL);
    (nItem != -1);nItem = GetListCtrl().GetNextItem(nItem, LVNI_ALL))
    {
      if (entry->equals((CMP3ToolEntry*)(GetListCtrl().GetItemData(nItem))))
      {
        if (*state<4)
        {
          CExistsDlg* existsDlg=new CExistsDlg(this);
          existsDlg->SetEntries(entry,(CMP3ToolEntry*)(GetListCtrl().GetItemData(nItem)));
          *state = existsDlg->DoModal();
          delete existsDlg;
        }
        switch (*state)
        {
        case 1:
        case 4:
          break;
        case 2:
        case 5:
          delete ((CMP3ToolEntry*)(GetListCtrl().GetItemData(nItem)));
          GetListCtrl().DeleteItem(nItem);
          nItem--;
          break;
        case 3:
        case 6:
          //2do: verschieben statt umbenennen
          char sold[256];
          char snew[256];
          strcpy((char*)&sold,entry->m_strPath);
          if (strlen((char*)&sold)>2)
          {
            strcat((char*)&sold,"\\");
          }
          strcat((char*)&sold,entry->m_strName);
          strcpy((char*)&snew,(char*)&sold);
          strcat((char*)&snew,".cop");
          rename((char*)&sold,(char*)&snew);
          delete entry;
          return;
        }
      }
    }
  }
  int ii = GetListCtrl().GetItemCount();
  LV_ITEM lvi;
  lvi.iItem = ii;
  lvi.iSubItem = 0;
  lvi.state = INDEXTOSTATEIMAGEMASK(1);
  lvi.lParam = LPARAM(entry);
  lvi.pszText= "";
  
  GetListCtrl().InsertItem(&lvi);
  GetListCtrl().SetItemData(ii,LPARAM(entry));
  for(int j=0; j<NUM_COLUMNS; j++)
  {
    GetListCtrl().SetItemText(ii,j,GetDocument()->GetItem(entry,j));
  }
}

void CMP3ToolView::SubEntry(CMP3ToolEntry* entry, int* state)
{
  int nItem;
  for(nItem = GetListCtrl().GetNextItem(-1, LVNI_ALL);
  (nItem != -1);nItem = GetListCtrl().GetNextItem(nItem, LVNI_ALL))
  {
    if (entry->equals((CMP3ToolEntry*)(GetListCtrl().GetItemData(nItem))))
    {
      delete ((CMP3ToolEntry*)(GetListCtrl().GetItemData(nItem)));
      GetListCtrl().DeleteItem(nItem);
      nItem--;
      *state=1;
    }
  }
  delete (entry);
}

void CMP3ToolView::InitTable()
{
  CListCtrl& ListCtrl = GetListCtrl();
  int i;
  LV_COLUMN lvc;
  
  if (!tabelle_schon_initialisiert)
  {
    m_StateImageList.Create(IDB_STATEICONS, 14, 1, RGB(255, 0, 0));
    
    // insert columns
    
    lvc.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
    for(i = 0; i<NUM_COLUMNS; i++)
    {
      lvc.iSubItem = i;
      lvc.pszText = (char *)(GetDocument()->_gszColumnLabel[i]);
      lvc.cx = GetDocument()->_gnColumnWidth[i];
      lvc.fmt = LVCFMT_LEFT;
      ListCtrl.InsertColumn(i,&lvc);
    }
    tabelle_schon_initialisiert = true;
  }
}

void CMP3ToolView::OnInitialUpdate()
{
  CListView::OnInitialUpdate();
  InitTable();
}

/////////////////////////////////////////////////////////////////////////////
// CMP3ToolView drawing

// offsets for first and other columns
#define OFFSET_FIRST	2
#define OFFSET_OTHER	3

void CMP3ToolView::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct)
{
  CListCtrl& ListCtrl=GetListCtrl();
  CDC* pDC = CDC::FromHandle(lpDrawItemStruct->hDC);
  CRect rcItem(lpDrawItemStruct->rcItem);
  int nItem = lpDrawItemStruct->itemID;
  CMP3ToolEntry* entry=(CMP3ToolEntry*)ListCtrl.GetItemData(nItem);
  CImageList* pImageList;
  BOOL bFocus = (GetFocus() == this);
  static _TCHAR szBuff[MAX_PATH];
  LPCTSTR pszText;
  
  // get item data
  
  LV_ITEM lvi;
  lvi.mask = LVIF_TEXT | LVIF_IMAGE | LVIF_STATE;
  lvi.iItem = nItem;
  lvi.iSubItem = 0;
  lvi.pszText = szBuff;
  lvi.cchTextMax = sizeof(szBuff);
  lvi.stateMask = 0xFFFF;		// get all state flags
  ListCtrl.GetItem(&lvi);
  
  BOOL bSelected = (bFocus || (GetStyle() & LVS_SHOWSELALWAYS)) && lvi.state & LVIS_SELECTED;
  bSelected = bSelected || (lvi.state & LVIS_DROPHILITED);
  
  // set colors if item is selected
  
  if (bSelected)
  {
    //pDC->SetTextColor(::GetSysColor(COLOR_HIGHLIGHTTEXT));
    pDC->SetBkColor(::GetSysColor(COLOR_HIGHLIGHT));
    
    pDC->FillRect(rcItem, &CBrush(::GetSysColor(COLOR_HIGHLIGHT)));
  }
  else
    pDC->FillRect(rcItem, &CBrush(m_clrTextBk));
  
  // draw item label
  
  CRect rcLabel;
  ListCtrl.GetItemRect(nItem, rcLabel, LVIR_LABEL);
  rcLabel.left = rcItem.left + OFFSET_FIRST;
  
  pszText = MakeShortString(pDC,szBuff,rcLabel.right-rcLabel.left, OFFSET_FIRST);
  
  //0x00bbggrr
  if (entry->changed!=0)
  {
    if (bSelected)
    {
      pDC->SetTextColor(0x007070ff);
    }
    else
    {
      pDC->SetTextColor(0x000000e0);
    }
  }
  else
  {
    if (bSelected)
    {
      pDC->SetTextColor(::GetSysColor(COLOR_HIGHLIGHTTEXT));
    }
    else
    {
      pDC->SetTextColor(::GetSysColor(COLOR_WINDOWTEXT));
    }
  }
  pDC->DrawText(pszText,-1,rcLabel,DT_LEFT | DT_SINGLELINE | DT_NOPREFIX | DT_NOCLIP | DT_VCENTER);
  
  // draw labels for extra columns
  
  LV_COLUMN lvc;
  lvc.mask = LVCF_FMT | LVCF_WIDTH;
  
  for(int nColumn = 1; ListCtrl.GetColumn(nColumn, &lvc); nColumn++)
  {
    // draw state icon
    rcLabel.left = rcLabel.right + OFFSET_OTHER;
    rcLabel.right += lvc.cx;
    
    pImageList = &m_StateImageList;
    int nRetLen = ListCtrl.GetItemText(nItem,nColumn,szBuff,sizeof(szBuff));
    switch (nColumn)
    {
    case COL_COPY:
    case COL_ORIG:
      pImageList->Draw(pDC,nRetLen-1,CPoint(rcLabel.left, rcLabel.top), ILD_TRANSPARENT);
      break;
    default:
      if (nRetLen == 0)
        continue;
      pszText = MakeShortString(pDC,szBuff,rcLabel.right-rcLabel.left, OFFSET_OTHER);
      //0x00bbggrr
      //pDC->SetTextColor(0x000000ff);
      pDC->DrawText(pszText, -1, rcLabel,DT_LEFT | DT_SINGLELINE | DT_NOPREFIX | DT_NOCLIP | DT_VCENTER);
    }
  }
  
  // draw focus rectangle (punktlinie drumrum) if item has focus
  
  if (lvi.state & LVIS_FOCUSED && bFocus)
    pDC->DrawFocusRect(rcItem);
}

LPCTSTR CMP3ToolView::MakeShortString(CDC* pDC, LPCTSTR lpszLong, int nColumnLen, int nOffset)
{
  static const _TCHAR szThreeDots[] = _T("..");
  
  int nStringLen = lstrlen(lpszLong);
  
  if(nStringLen == 0 ||
    (pDC->GetTextExtent(lpszLong, nStringLen).cx + nOffset) <= nColumnLen)
  {
    return(lpszLong);
  }
  
  static _TCHAR szShort[MAX_PATH];
  
  lstrcpy(szShort,lpszLong);
  int nAddLen = pDC->GetTextExtent(szThreeDots,sizeof(szThreeDots)).cx;
  
  for(int i = nStringLen-1; i > 0; i--)
  {
    szShort[i] = 0;
    if((pDC->GetTextExtent(szShort, i).cx + nOffset + nAddLen)
      <= nColumnLen)
    {
      break;
    }
  }
  
  lstrcat(szShort, szThreeDots);
  return(szShort);
}

/////////////////////////////////////////////////////////////////////////////
// CMP3ToolView printing

void CMP3ToolView::OnDraw(CDC* pDC)
{
  CMP3ToolDoc* pDoc = GetDocument();
  pDC->SetTextColor(0x00cc0000);
  // ob ihm mal jemand sagt, was spacing ist????? eigene fonts vergessen wir mal!!!
  pDC->TextOut(100,100,"OOPS! - Die Printroutine (::OnDraw()) ist noch nicht ganz fertig ...");
}

BOOL CMP3ToolView::OnPreparePrinting(CPrintInfo* pInfo)
{
  // default preparation
  return DoPreparePrinting(pInfo);
}

void CMP3ToolView::OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo)
{
  CListView::OnBeginPrinting(pDC, pInfo);
}

void CMP3ToolView::OnEndPrinting(CDC* pDC, CPrintInfo* pInfo)
{
  CListView::OnEndPrinting(pDC, pInfo);
}

/////////////////////////////////////////////////////////////////////////////
// CMP3ToolView message handlers

void CMP3ToolView::OnViewStateIcons() 
{
  m_bStateIcons =! m_bStateIcons;
  
  //mal sehen, vielleicht brauchen wir das ja noch mal
}

void CMP3ToolView::OnUpdateViewStateIcons(CCmdUI* pCmdUI) 
{
  pCmdUI->SetCheck(m_bStateIcons);
}

void CMP3ToolView::OnLButtonDown(UINT nFlags, CPoint point) 
{
  UINT uFlags = 0;
  CListCtrl& ListCtrl=GetListCtrl();
  int nHitItem = ListCtrl.HitTest(point, &uFlags);
  
  // we need additional checking in owner-draw mode
  // because we only get LVHT_ONITEM
  BOOL bHit = false;
  CRect rect;
  ListCtrl.GetItemRect(nHitItem, rect, LVIR_LABEL);
  if (m_bStateIcons && uFlags==LVHT_ONITEM && point.x>rect.right)
  {
    LV_COLUMN lvc;
    lvc.mask = LVCF_WIDTH;
    for(int nColumn = 1; ListCtrl.GetColumn(nColumn, &lvc); nColumn++)
    {
      rect.left = rect.right;
      rect.right += lvc.cx;
      // check if hit was on a state icon,
      // vielleicht irgendwann, aber eigentlich will ich in der Liste gar nicht editieren
      if (point.x > rect.left && point.x < rect.left + 20)
      {
        bHit = true;
      }
    }
  }
  //in bHit steht jetzt, ob jemand an einer Checkbox rumgefummelt hat
  
  CListView::OnLButtonDown(nFlags, point);
}

void CMP3ToolView::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
  UINT uFlags = 0;
  int nHitItem = GetListCtrl().HitTest(point, &uFlags);
  
  //egal, wo aufs icon ich klicke!
  OnManEdit();
  
  CListView::OnLButtonDblClk(nFlags, point);
}

void CMP3ToolView::OnSetFocus(CWnd* pOldWnd) 
{
  CListView::OnSetFocus(pOldWnd);
  
  // repaint items that should change appearance
  RepaintSelectedItems();
}

void CMP3ToolView::OnKillFocus(CWnd* pNewWnd) 
{
  CListView::OnKillFocus(pNewWnd);
  
  // repaint items that should change appearance
  RepaintSelectedItems();
}

void CMP3ToolView::RepaintSelectedItems()
{
  CListCtrl& ListCtrl = GetListCtrl();
  CRect rcItem, rcLabel;
  
  // invalidate focused item so it can repaint properly
  
  int nItem = ListCtrl.GetNextItem(-1, LVNI_FOCUSED);
  
  if(nItem != -1)
  {
    ListCtrl.GetItemRect(nItem, rcItem, LVIR_BOUNDS);
    InvalidateRect(rcItem, false);
  }
  
  // if selected items should not be preserved, invalidate them
  
  if(!(GetStyle() & LVS_SHOWSELALWAYS))
  {
    for(nItem = ListCtrl.GetNextItem(-1, LVNI_SELECTED);
    nItem != -1; nItem = ListCtrl.GetNextItem(nItem, LVNI_SELECTED))
    {
      ListCtrl.GetItemRect(nItem, rcItem, LVIR_BOUNDS);
      InvalidateRect(rcItem, false);
    }
  }
  UpdateWindow();
}

int CALLBACK CompareFunc(CMP3ToolEntry* entr1, CMP3ToolEntry* entr2, LPARAM lcol)
{
  int result;
  switch (lcol)
  {
  case COL_NAME:
    result = stricmp(entr1->m_strName,entr2->m_strName);
    if (result==0)
    {
      result = stricmp(entr1->m_strPath,entr2->m_strPath);
    }
    break;
  case COL_PATH:
    result = stricmp(entr1->m_strPath,entr2->m_strPath);
    if (result==0)
    {
      result = stricmp(entr1->m_strName,entr2->m_strName);
    }
    break;
  case COL_TITLE:
    result = stricmp(entr1->m_strTitle,entr2->m_strTitle);
    if (result==0)
    {
      result = stricmp(entr1->m_strArtist,entr2->m_strArtist);
      if (result==0)
      {
        result = stricmp(entr1->m_strPath,entr2->m_strPath);
      }
    }
    break;
  case COL_ARTIST:
    {
      char a1[256];
      char a2[256];
      entr1->shortenString(entr1->m_strArtist,(char*)&a1);
      entr2->shortenString(entr2->m_strArtist,(char*)&a2);
      result = stricmp((char*)&a1,(char*)&a2);
      if (result==0)
      {
        result = stricmp(entr1->m_strTitle,entr2->m_strTitle);
        if (result==0)
        {
          result = stricmp(entr1->m_strPath,entr2->m_strPath);
        }
      }
      break;
    }
  case COL_ALBUM:
    result = stricmp(entr1->m_strAlbum,entr2->m_strAlbum);
    if (result==0)
    {
      result = stricmp(entr1->m_strTitle,entr2->m_strTitle);
      if (result==0)
      {
        result = stricmp(entr1->m_strArtist,entr2->m_strArtist);
      }
    }
    break;
  case COL_SIZE:
    result = (int)(entr1->m_iSize>entr2->m_iSize);
    if (result==0)
    {
      result = -(int)(entr1->m_iSize<entr2->m_iSize);
    }
    break;
  case COL_LEN:
    result = strcmp(entr1->GetLength(),entr2->GetLength());
    break;
  case COL_TRACK:
    result = (entr1->m_iTrack>entr2->m_iTrack);
    break;
  case COL_GENRE:
    result = strcmp(entr1->GetGenre(),entr2->GetGenre());
    if (result==0)
    {
      result = strcmp(entr1->m_strTitle,entr2->m_strTitle);
      if (result==0)
      {
        result = strcmp(entr1->m_strArtist,entr2->m_strArtist);
      }
    }
    break;
  case COL_YEAR:
    result = (int)(entr1->m_iYear>entr2->m_iYear);
    if (result==0)
    {
      result = -(int)(entr1->m_iYear<entr2->m_iYear);
      if (result==0)
      {
        result = strcmp(entr1->m_strName,entr2->m_strName);
      }
    }
    break;
  case COL_COMMENT:
    result = stricmp(entr1->m_strComment,entr2->m_strComment);
    break;
  case COL_BITRATE:
    result = (int)(entr1->GetMBitRate()>entr2->GetMBitRate());
    if (result==0)
    {
      result = -(int)(entr1->GetMBitRate()<entr2->GetMBitRate());
    }
    break;
  case COL_ORIG:
    result = (int)(entr1->Get_OrigFlag())-(int)(entr2->Get_OrigFlag());
    break;
  case COL_COPY:
    result = (int)(entr1->Get_CopyFlag())-(int)(entr2->Get_CopyFlag());
    break;
  default:
    result = 0;
  }
  return result;
}

void CMP3ToolView::OnColumnclick(NMHDR* pNMHDR, LRESULT* pResult) 
{
  GetListCtrl().SortItems((PFNLVCOMPARE)CompareFunc,((NM_LISTVIEW*)pNMHDR)->iSubItem);
  *pResult = 0;
}

void CMP3ToolView::OnExpXls()
{
  CFileDialog* xlsdialog;
  char* fil=new TCHAR[256];
  _splitpath(GetDocument()->GetTitle(),NULL,NULL,fil,NULL);
  strcat(fil,_T(".xls"));
  xlsdialog = new CFileDialog(false, _T("xls"), fil,OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT,"Excel-Tabellen (*.xls)|*.xls; *.xls|Alle Dateien (*.*)|*.*||",NULL);
  int xlsItem = -1;
  int xlsAnzahl = GetListCtrl().GetSelectedCount();
  if ((xlsdialog->DoModal()==IDOK)&&(xlsAnzahl>0))
  {
    CFile xlsfile;
    if (xlsfile.Open(xlsdialog->GetPathName(),CFile::modeCreate|CFile::modeWrite|CFile::shareDenyWrite,NULL))
    {
      //BOF + Dimension + DefaultRowHeight schreiben
      const WORD xlshead[15] ={9,4,2,16, 0,8,0,1,0,XLS_COLUMNS,  0x25,2,0x80f0,   10,0};
      (WORD)xlshead[7] = xlsAnzahl;
      xlsfile.Write(xlshead,26);
      // ColWidth schreiben
      const BYTE xlsrowwidth[8]={0x24,0,4,0,1,1, 0,20}; //letzte word=spaltenbreite
      for (int i=0;i<XLS_COLUMNS;i++)
      {
        (BYTE)xlsrowwidth[4]=i;
        (BYTE)xlsrowwidth[5]=i;
        xlsfile.Write(xlsrowwidth,8);
      }
      (BYTE)xlsrowwidth[4]=XLS_COLUMNS;
      (BYTE)xlsrowwidth[5]=255;
      (BYTE)xlsrowwidth[7]=5;
      xlsfile.Write(xlsrowwidth,8);
      
      BYTE** xlsline = new BYTE*[32];
      WORD* xlslen = new WORD[33];
      for (i=0;i<32;i++)
      {
        xlsline[i] = new BYTE[1000];
      }
      for (int j=0;j<xlsAnzahl;j+=32)
      {
        int bloclen = xlsAnzahl - j;
        if (bloclen>32)
        {
          bloclen=32;
        }
        xlslen[0] = (WORD)(bloclen-1)*17;
        //Rows berechnen (wir brauchen die Lnge vorher)
        for (int k=0;k<bloclen;k++)
        {
          xlsItem = GetListCtrl().GetNextItem(xlsItem,LVNI_SELECTED);
          xlslen[k+1] = GetDocument()->MakeXLSRow(xlsline[k],(CMP3ToolEntry*)(GetListCtrl().GetItemData(xlsItem)),j+k);
        }
        //Row Tags schreiben
        for (k=0;k<bloclen;k++)
        {
          const BYTE xlsrowtag[17] = {8,0,13,0, 0,0, 0,0,XLS_COLUMNS,0, 240,128,0,0,0, 2,15};
          *(WORD*)&xlsrowtag[15] = xlslen[k];
          *(WORD*)&xlsrowtag[4] = (WORD)(k+j);
          xlsfile.Write(xlsrowtag,17);
        }
        //Label/Integer/Number Tags schreiben
        for (k=0;k<bloclen;k++)
        {
          xlsfile.Write(xlsline[k],xlslen[k+1]);
        }
      }
      xlsfile.Write(&xlshead[13],3);
      xlsfile.Close();
      for (i=0;i<32;i++)
      {
        delete xlsline[i];
      }
      delete xlsline;
      delete xlslen;
    }
  }
  delete xlsdialog;	
  delete fil;
}

void CMP3ToolView::OnManEdit() 
{
  CEditDlg editDlg;
  CListCtrl& ListCtrl = GetListCtrl();
  int nItem;
  int status=0;
  for(nItem = ListCtrl.GetNextItem(-1, LVNI_SELECTED);
  (nItem != -1)&&(status != 2);
  nItem = ListCtrl.GetNextItem(nItem, LVNI_SELECTED))
  {
    editDlg.InitEntry((CMP3ToolEntry*)ListCtrl.GetItemData(nItem));
    status=editDlg.DoModal();
    //1=OK, 2=Abort, 3=NoSave (oder save und nochange)
    if(status==1)
    {
      GetDocument()->myModifiedFlag=true;
      GetDocument()->SetTitle("");
      UpdateViewEntry(nItem);
    }
  }
}

void CMP3ToolView::OnAutoEdit() 
{
  CListCtrl& ListCtrl = GetListCtrl();
  int nItem=-1;
  int status=0;
  autoDlg=new CAutoDlg(this);
  autoDlg->Create();
  while ((nItem=ListCtrl.GetNextItem(nItem, LVNI_SELECTED))!=-1)
  {
    autoDlg->SetProgress(ListCtrl.GetSelectedCount());
    int status=((CMP3ToolEntry*)(GetListCtrl().GetItemData(nItem)))->AutoEdit(autoDlg);
    if(status==1)
    {
      //1=OK, 2=Abort, 3=NoSave (oder save und nochange)
      GetDocument()->myModifiedFlag=true;
      GetDocument()->SetTitle("");
      UpdateViewEntry(nItem);
    }
    else if (status==2)
    {
      break;
    }
  }
  delete autoDlg;
}

void CMP3ToolView::OnDelEntry() 
{
  int nItem;
  CListCtrl& ListCtrl = GetListCtrl();
  if ((ListCtrl.GetNextItem(-1, LVNI_SELECTED)!=-1)&&(AfxMessageBox("Sollen die ausgewhlten *.mp3's wirklich\naus der Liste entfernt werden?",MB_YESNO)==IDYES))
  {
    while ((nItem = ListCtrl.GetNextItem(-1, LVNI_SELECTED))!=-1)
    {
      delete ((CMP3ToolEntry*)(GetListCtrl().GetItemData(nItem)));
      ListCtrl.DeleteItem(nItem);
      GetDocument()->myModifiedFlag=true;
      GetDocument()->SetTitle("");
    }
  }
}

void CMP3ToolView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
  if (nChar==VK_CONTROL)
  {
    m_bStrg=true;
  }
  else
  {
    if (nChar==VK_RETURN)
    {
      if (m_bStrg)
      {
        OnAutoEdit();
      }
      else
      {
        OnManEdit();
      }
    }
    else if (nChar==VK_DELETE)
    {
      OnDelEntry();
    }
    else if ((nChar==65)&&(m_bStrg))		//Strg-A
    {
      CListCtrl& ListCtrl = GetListCtrl();
      for (int i=0;i<ListCtrl.GetItemCount();i++)
      {
        ListCtrl.SetItemState(i,LVIS_SELECTED,LVIS_SELECTED);
      }
    }
    m_bStrg=false;
  }
  CListView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CMP3ToolView::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
  m_bStrg=false;
  CListView::OnKeyUp(nChar, nRepCnt, nFlags);
}

void CMP3ToolView::OnContextMenu(CWnd* pWnd, CPoint point)
{
  CMenu menu;
  if (menu.LoadMenu(ID_POPUP_MENU))
  {
    CMenu* pPopup = menu.GetSubMenu(0);
    pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON,point.x, point.y,AfxGetMainWnd()); // use main window for cmds
  }
  /*
  [HKEY_CLASSES_ROOT\Directory\shell\Winamp.Enqueue\command]
  @="\"E:\\SOUND\\WINAMP\\WINAMP.EXE\" /ADD \"%1\""
  
    
      [HKEY_CLASSES_ROOT\.mp3]
      @="Winamp.File"
      
        [HKEY_CLASSES_ROOT\Winamp.File\shell\Play\command]
        @="\"E:\\SOUND\\WINAMP\\WINAMP.EXE\" \"%1\""
        
          [HKEY_CLASSES_ROOT\Kjofol.File\shell\Play\command]
          @="\"E:\\SOUND\\KJOFOL\\KJOFOL.EXE\" \"%1\""
          
            KEY_CLASSES_ROOT\Yamp_mp3\shell\open\command]
            @="E:\\SOUND\\YAMP\\Yamp.exe \"%1\""
  */
}

void CMP3ToolView::OnPlay() 
{
  HKEY hkMP3 ;
  if (RegOpenKey(HKEY_CLASSES_ROOT,_T(".mp3"),&hkMP3)==ERROR_SUCCESS)
  {
    long buflen=64;
    TCHAR szBuf[64];
    long buflen2=64;
    TCHAR szBuf2[64];
    RegQueryValue(HKEY_CLASSES_ROOT,(LPTSTR)_T(".mp3"), szBuf, &buflen);
    strcat(szBuf,_T("\\shell\\Play\\command"));
    RegQueryValue(HKEY_CLASSES_ROOT,szBuf, szBuf2, &buflen2);
    //OK, in szBuf2 haben wir jetzt das Standard-mp3-play-command,
    //aber was ist bei open, bzw. warum nicht gleich die Shell die Arbeit
    //machen lassen
    //system("E:\\SOUND\\WINAMP\\WINAMP.EXE K:\\MP3_check\\Meshuggah-Future_Breed_Machine.mp3");
  }
  CListCtrl& ListCtrl = GetListCtrl();
  int nItem;
  if(nItem = ListCtrl.GetNextItem(-1, LVNI_FOCUSED))
  {
    CMP3ToolEntry* eintrag=(CMP3ToolEntry*)(GetListCtrl().GetItemData(nItem));
    ShellExecute(m_hWnd, "open",eintrag->m_strName,NULL,eintrag->m_strPath,SW_SHOW);
  }
}

void CMP3ToolView::OnExpWinamp() 
{
  CFileDialog* ampdialog;
  char* fil=new TCHAR[256];
  _splitpath(GetDocument()->GetTitle(),NULL,NULL,fil,NULL);
  strcat(fil,_T(".m3u"));
  ampdialog = new CFileDialog(false, _T("m3u"),fil,OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT,"Winamp-Playlisten (*.m3u)|*.m3u; *.m3u|Alle Dateien (*.*)|*.*||",NULL);
  if (ampdialog->DoModal()==IDOK)
  {
    CFile ampfile;
    if (ampfile.Open(ampdialog->GetPathName(),CFile::modeCreate|CFile::modeWrite|CFile::shareDenyWrite,NULL))
    {
      int crlf=0x0a0d;
      CListCtrl& ListCtrl = GetListCtrl();
      int nItem;
      
      for(nItem = ListCtrl.GetNextItem(-1, LVNI_SELECTED);
      (nItem != -1);nItem = ListCtrl.GetNextItem(nItem, LVNI_SELECTED))
      {
        CMP3ToolEntry* eintrag=(CMP3ToolEntry*)(GetListCtrl().GetItemData(nItem));
        ampfile.Write(eintrag->m_strPath,strlen(eintrag->m_strPath));
        char dash='\\';
        ampfile.Write(&dash,1);
        ampfile.Write(eintrag->m_strName,strlen(eintrag->m_strName));
        ampfile.Write(&crlf,2);
      }
      ampfile.Close();
    }
  }
  delete ampdialog;	
  delete fil;	
}

/*
BOOL CMP3ToolView::Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext) 
{
BOOL x=CWnd::Create(lpszClassName, lpszWindowName, dwStyle, rect, pParentWnd, nID, pContext);
// register drop target
m_dropTarget.Register(this);
return x;
}

  DROPEFFECT CMP3ToolView::OnDragOver(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point) 
  {
  AfxMessageBox("WOW - da jemand was gedragovered",MB_OK);
  return CListView::OnDragOver(pDataObject, dwKeyState, point);
  }
  
    DROPEFFECT CMP3ToolView::OnDragEnter(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point) 
    {
    AfxMessageBox("WOW - da jemand was gedragentered",MB_OK);
    
      return CListView::OnDragEnter(pDataObject, dwKeyState, point);
      }
      
        BOOL CMP3ToolView::OnDrop(COleDataObject* pDataObject, DROPEFFECT dropEffect, CPoint point) 
        {
        AfxMessageBox("WOW - da hat jemand was gedropped",MB_OK);
        
          return CListView::OnDrop(pDataObject, dropEffect, point);
          }
*/

void CMP3ToolView::OnExpTxt() 
{
  //2do: wollen wir mehr als nur Dateinamen in txt?
  char* fil=new TCHAR[256];
  _splitpath(GetDocument()->GetTitle(),NULL,NULL,fil,NULL);
  strcat(fil,_T(".txt"));
  CFileDialog* txtdialog = new CFileDialog(false, _T("txt"),fil,OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT,"Winamp-Playlisten (*.txt)|*.txt; *.txt|Alle Dateien (*.*)|*.*||",NULL);
  if (txtdialog->DoModal()==IDOK)
  {
    CFile txtfile;
    if (txtfile.Open(txtdialog->GetPathName(),CFile::modeCreate|CFile::modeWrite|CFile::shareDenyWrite,NULL))
    {
      int crlf=0x0a0d;
      CListCtrl& ListCtrl = GetListCtrl();
      int nItem;
      
      for(nItem = ListCtrl.GetNextItem(-1, LVNI_SELECTED);
      (nItem != -1);nItem = ListCtrl.GetNextItem(nItem, LVNI_SELECTED))
      {
        CMP3ToolEntry* eintrag=(CMP3ToolEntry*)(GetListCtrl().GetItemData(nItem));
        txtfile.Write(eintrag->m_strName,strlen(eintrag->m_strName));
        txtfile.Write(&crlf,2);
      }
      txtfile.Close();
    }
  }
  delete txtdialog;	
  delete fil;	
}

int Weich(int a, int b, int c, int d)
{
  int r= (((a>>16)+(b>>16)+(c>>16)+(d>>16))>>2)<<16;
  r += ((((a>>8)&0xff)+((b>>8)&0xff)+((c>>8)&0xff)+((d>>8)&0xff))>>2)<<8;
  r += ((a & 0xff)+(b & 0xff)+(c & 0xff)+(d & 0xff))>>2;
  return r;
}

void CMP3ToolView::OnMakeCover() 
{
  CListCtrl& ListCtrl = GetListCtrl();
  CMP3ToolEntry* e[50];
  int nItem=-1;
  int num=0;
  while (((nItem=ListCtrl.GetNextItem(nItem, LVNI_SELECTED))!=-1)&&(num<50))
  {
    e[num++]=(CMP3ToolEntry*)(GetListCtrl().GetItemData(nItem));
  }
  if (num<2)
  {
    AfxMessageBox("Witzbold: Ein CD-Cover mit 0 Titeln? Erst Titel markieren, dann Cover erstellen!",MB_OK);
  }
  else if (num>49)
  {
    AfxMessageBox("Ein CD-Cover mit mehr als 49 Titeln? Mach ich nicht. Du willst mich wohl testen?",MB_OK);
  }
  else
  {
    CDC* cScreen=GetDC();
    CDC c;
    c.CreateCompatibleDC(cScreen);
    CBitmap bmp;
    bmp.CreateCompatibleBitmap(cScreen,1800,1407);
    c.SelectObject(&bmp);
    char s[256];
    CSize si;
    CFont* foalt;
    CFont* foneu=new CFont();
    
    //2do: eigener Dialog mit Farb-, Schrift- und CD-Titel-Auswahl
    char cdTitle[]=""; //"diverse - MixCD";
    
    CFontDialog f;
    if (f.DoModal()==IDOK)
    {
      LOGFONT lf;
      f.GetCurrentFont(&lf);
      foneu->CreatePointFontIndirect(&lf);
      foalt=c.SelectObject(foneu);
      
      int i;
      char tit[256];
      int titX,maxX1,maxX2,maxX3,maxX3tab,maxY;
      
      long msecs=0;
      for (i=0;i<num;i++)
      {
        msecs+=e[i]->m_iMSec;
      }
      double percentage=0.945;
      for (int trial=0;(trial<3)||(percentage>0.97);trial++)
      {
        if ((percentage<0.92)||(percentage>0.97))
        {
          lf.lfHeight = (int)(lf.lfHeight*0.945/percentage);
        }
        delete(foneu);
        foneu=new CFont();
        foneu->CreatePointFontIndirect(&lf);
        foalt=c.SelectObject(foneu);
        titX=maxX1=maxX2=maxX3=maxX3tab=maxY=0;
        
        sprintf(s,"%i)",i+1);
        si=c.GetTextExtent(s);
        if (si.cx>maxX1) maxX1=si.cx;
        
        for (i=0;i<num;i++)
        {
          sprintf(s,"%i)",i+1);
          si=c.GetTextExtent(s);
          if (si.cx>maxX1) maxX1=si.cx;
          if (si.cy>maxY) maxY=si.cy;
          
          sprintf(s,"%s - %s",e[i]->m_strArtist,e[i]->m_strTitle);
          char* t=s;
          char* u=tit;
          while (*t)
          {
            if (*t =='&')
            {
              *(u++)='&';
            }
            *u=*(t++);
            *(++u)=0;
          }
          si=c.GetTextExtent(tit);
          if (si.cx>maxX2) maxX2=si.cx;
          if (si.cy>maxY) maxY=si.cy;
          
          sprintf(s,"%i:",e[i]->m_iMSec/60000);
          si=c.GetTextExtent(s);
          if (si.cx>maxX3tab) maxX3tab=si.cx;
          
          sprintf(s,"%s",e[i]->GetLength());
          si=c.GetTextExtent(s);
          if (si.cx>maxX3) maxX3=si.cx;
          if (si.cy>maxY) maxY=si.cy;
        }
        sprintf(s,"%i:",msecs/60000);
        si=c.GetTextExtent(s);
        if (si.cx>maxX3tab) maxX3tab=si.cx;
        sprintf(s,"%i:%02i.%i",msecs/60000,(msecs/1000)%60,(msecs/100)%10);
        si=c.GetTextExtent(s);
        if (si.cx>maxX3) maxX3=si.cx;
        if (si.cy>maxY) maxY=si.cy;
        
        if (cdTitle[0]!=0)
        {
          int oldHeight=lf.lfHeight;
          lf.lfHeight = (int)(lf.lfHeight*1.6);
          delete(foneu);
          foneu=new CFont();
          foneu->CreatePointFontIndirect(&lf);
          foalt=c.SelectObject(foneu);
          si=c.GetTextExtent(cdTitle);
          titX=si.cx;
          
          lf.lfHeight = oldHeight;
          delete(foneu);
          foneu=new CFont();
          foneu->CreatePointFontIndirect(&lf);
          foalt=c.SelectObject(foneu);
        }
        
        percentage=max((double)(max(titX,maxX1+20+maxX2+20+maxX3))/1598,(double)(num+1+((cdTitle[0]!=0)?2:0))*maxY/1405);
      }
      int topY=(1407-(num+1+((cdTitle[0]!=0)?2:0))*maxY)/2+((cdTitle[0]!=0)?2:0)*maxY;
      
      //paint borders:      
      c.SetBkColor(0xffffff);
      c.SetTextColor(0x000000);
      c.Rectangle(0,0,1800,1407);
      c.Rectangle(100,0,1700,1407);
      
      //paint numbers:
      c.SetTextColor(0x0000ff);
      RECT r;
      r.left=(1800-maxX1-20-maxX2-20-maxX3)/2;
      r.top=topY;
      for (i=0;i<num;i++)
      {
        sprintf(s,"%i)",i+1);
        r.bottom=r.top+maxY;
        r.right=r.left+maxX1+20;
        c.DrawText(s,&r,DT_LEFT);
        r.top=r.bottom;
      }
      
      //paint lengths:
      c.SetTextColor(0xff0000);
      r.top=topY;
      for (i=0;i<num;i++)
      {
        sprintf(s,"%i:",e[i]->m_iMSec/60000);
        si=c.GetTextExtent(s);
        r.left=(1800-maxX1-20-maxX2-20-maxX3)/2+maxX1+20+maxX2+20+maxX3tab-si.cx;
        
        sprintf(s,"%s",e[i]->GetLength());
        r.bottom=r.top+maxY;
        r.right=r.left+maxX3+10;
        c.DrawText(s,&r,DT_LEFT);
        r.top=r.bottom;
      }
      
      //paint titles:
      c.SetTextColor(0x000000);
      r.left=(1800-maxX1-20-maxX2-20-maxX3)/2+maxX1+20;
      r.top=topY;
      for (i=0;i<num;i++)
      {
        sprintf(s,"%s - %s",e[i]->m_strArtist,e[i]->m_strTitle);
        char* t=s;
        char* u=tit;
        while (*t)
        {
          if (*t =='&')
          {
            *(u++)='&';
          }
          *u=*(t++);
          *(++u)=0;
        }
        r.bottom=r.top+maxY;
        r.right=r.left+maxX2+10;
        c.DrawText(tit,&r,DT_LEFT);
        r.top=r.bottom;
      }
      
      //paint sum of lengths:
      r.bottom=r.top+maxY;
      sprintf(s,"%i:",msecs/60000);
      si=c.GetTextExtent(s);
      r.left=(1800-maxX1-20-maxX2-20-maxX3)/2+maxX1+20+maxX2+20+maxX3tab-si.cx;
      r.right=r.left+maxX2+10;
      sprintf(s,"%i:%02i.%i",msecs/60000,(msecs/1000)%60,(msecs/100)%10);
      c.DrawText(s,&r,DT_LEFT);
      
      //paint CD title:
      if (cdTitle[0]!=0)
      {
        lf.lfHeight = (int)(lf.lfHeight*1.6);
        delete(foneu);
        foneu=new CFont();
        foneu->CreatePointFontIndirect(&lf);
        foalt=c.SelectObject(foneu);
        r.left=(1800-titX)/2;
        r.right=r.left+titX;
        r.top=(1407-(num+3)*maxY)/2;
        r.bottom=r.top+2*maxY;
        c.DrawText(cdTitle,&r,DT_LEFT);
      }
      
      CFileDialog bmpdialog(false, "bmp", "cover.bmp",OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT,"Bitmaps (*.bmp)|*.bmp|Alle Dateien (*.*)|*.*||",NULL);
      if (bmpdialog.DoModal()==IDOK)
      {
        FILE* ff=fopen(bmpdialog.GetPathName(),"wb");
        unsigned char head[54]={
          0x42,0x4d,0x20,0xef,0x73,0,0,0,0,0,0x36,0,0,0,0x28,0,
            0,0,8,7,0,0,0x7f,5,0,0,1,0,0x18,0,0,0,
            0,0,0,0,0,0,0x12,0xb,0,0,0x12,0xb,0,0,0,0,
            0,0,0,0,0,0};
          BeginWaitCursor();
          fwrite(head,1,54,ff);
          for (int k=1406;k>=0;k--)
          {
            char buf[3*1800];
            char* p=buf;
            for (int j=0;j<1800;j++)
            {
              //GetPixel is terribly slow, we could even write unbuffered
              //We should use GetBitmap or something like that instead:
              int nc=c.GetPixel(j,k);
              memcpy(p,&nc,3);
              p+=3;
            }
            fwrite(buf,1,3*1800,ff);
          }
          fwrite(&head[52],1,2,ff);
          fclose(ff);
          
          EndWaitCursor();
      }
    }
    delete (foneu);
  }
}

void CMP3ToolView::OnSearchFull() 
{
  //2do: Volltextsuche implementieren
}

void CMP3ToolView::OnSearchSim() 
{
  //2do: hnlichkeitsklassensuche implementieren
}

void CMP3ToolView::OnSearchReset() 
{
  //2do: MarkerSpalte und NextMarker zurcksetzen
}

void CMP3ToolView::OnMove() 
{
  //2do: ausgewhlte Dateien verschieben
}
