// MP3ToolEntry.cpp: implementation of the CMP3ToolEntry class.
//
//////////////////////////////////////////////////////////////////////

#include <afxwin.h>
#include "stdafx.h"
#include "MP3ToolEntry.h"

IMPLEMENT_DYNCREATE(CMP3ToolEntry, CObject)

LPCTSTR CMP3ToolEntry::_cGenre[150] ={
	_T(""),
	_T("Blues"),_T("Classic Rock"),_T("Country"),_T("Dance"),
	_T("Disco"),_T("Funk"),_T("Grunge"),_T("Hip-Hop"),
	_T("Jazz"),_T("Metal"),_T("New Age"),_T("Oldies"),
	_T("Other"),_T("Pop"),_T("R&B"),_T("Rap"),
	_T("Reggae"),_T("Rock"),_T("Techno"),_T("Industrial"),
	_T("Alternative"),_T("Ska"),_T("Death Metal"),_T("Pranks"),
	_T("Soundtrack"),_T("Euro-Techno"),_T("Ambient"),_T("Trip-Hop"),
	_T("Vocal"),_T("Jazz+Funk"),_T("Fusion"),_T("Trance"),
	_T("Classical"),_T("Instrumental"),_T("Acid"),_T("House"),
	_T("Game"),_T("Sound Clip"),_T("Gospel"),_T("Noise"),
	_T("Alternative Rock"),_T("Bass"),_T("Soul"),_T("Punk"),
	_T("Space"),_T("Meditative"),_T("Instrumental Pop"),_T("Instrumental Rock"),
	_T("Ethnic"),_T("Gothic"),_T("Darkwave"),_T("Techno-Industrial"),
	_T("Electronic"),_T("Pop-Folk"),_T("Eurodance"),_T("Dream"),
	_T("Southern Rock"),_T("Comedy"),_T("Cult"),_T("Gangsta"),
	_T("Top 40"),_T("Christian Rap"),_T("Pop/Funk"),_T("Jungle"),
	_T("Native US"),_T("Cabaret"),_T("New Wave"),_T("Psychadelic"),
	_T("Rave"),_T("Showtunes"),_T("Trailer"),_T("Lo-Fi"),
	_T("Tribal"),_T("Acid Punk"),_T("Acid Jazz"),_T("Polka"),
	_T("Retro"),_T("Musical"),_T("Rock & Roll"),_T("Hard Rock"),
	_T("Folk"),_T("Folk-Rock"),_T("National Folk"),_T("Swing"),
	_T("Fast Fusion"),_T("Bebob"),_T("Latin"),_T("Revival"),
	_T("Celtic"),_T("Bluegrass"),_T("Avantgarde"),_T("Gothic Rock"),
	_T("Progressive Rock"),_T("Psychedelic Rock"),_T("Symphonic Rock"),_T("Slow Rock"),
	_T("Big Band"),_T("Chorus"),_T("Easy Listening"),_T("Acoustic"),
	_T("Humour"),_T("Speech"),_T("Chanson"),_T("Opera"),
	_T("Chamber Music"),_T("Sonata"),_T("Symphony"),_T("Booty Bass"),
	_T("Primus"),_T("Porn Groove"),_T("Satire"),_T("Slow Jam"),
	_T("Club"),_T("Tango"),_T("Samba"),_T("Folklore"),
	_T("Ballad"),_T("Power Ballad"),_T("Rhytmic Soul"),_T("Freestyle"),
	_T("Duet"),_T("Punk Rock"),_T("Drum Solo"),_T("Acapella"),
	_T("Euro-House"),_T("Dance Hall"),_T("Goa"),_T("Drum & Bass"),
	_T("Club-House"),_T("Hardcore"),_T("Terror"),_T("Indie"),
	_T("BritPop"),_T("Negerpunk"),_T("Polsk Punk"),_T("Beat"),
	_T("Christian Gangsta Rap"),_T("Heavy Metal"),_T("Black Metal"),_T("Crossover"),
	_T("Contemporary Christian"),_T("Christian Rock"),_T("Merengue"),_T("Salsa"),
	_T("Trash Metal"),_T("Anime"),_T("JPop"),_T("Synthpop"),
	_T("none")
};
const int CMP3ToolEntry::_cBitrate[4][4][16]={
	{{0,0,16,24,0,0,0,0,0,0,0,0,0,0,0,0},
	{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
	{0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0},
	{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}},
	{{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
	{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
	{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
	{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}},
	{{0,8,16,24,32,40,48,56,64,80,96,112,128,144,160,0},
	{0,8,16,24,32,40,48,56,64,80,96,112,128,144,160,0},	
	{0,32,48,56,64,80,96,112,128,144,160,176,192,224,256,0},
	{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}},
	{{0,32,40,48,56,64,80,96,112,128,160,192,224,256,320,384},  //??
	{0,32,40,48,56,64,80,96,112,128,160,192,224,256,320,0},
	{0,32,64,96,128,160,192,224,256,288,320,352,384,416,448,0},
	{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}}
};


const int CMP3ToolEntry::_cSamplerate[4][4]={
	{11025,12000,8000,-1},
	{-1,-1,-1,-1},
	{22050,24000,16000,-1},
	{44100,48000,38000,-1}
};

const int CMP3ToolEntry::_cFrameLen[4][4]={
	{24000,72000,72000,-1},
	{-1,-1,-1,-1},
	{24000,72000,72000,-1},
	{48000,144000,144000,144000}
};

LPCTSTR CMP3ToolEntry::_cVersion[4]={
	_T("mpeg-2.5 "),_T("?? "),_T("mpeg-2.0 "),_T("mpeg-1.0 ")
};

LPCTSTR CMP3ToolEntry::_cLayer[4]={
	_T("layer-1"),_T("layer-3"),_T("layer-2"),_T("??")
};

LPCTSTR CMP3ToolEntry::_cChannel[4]={
	_T("Stereo"),_T("Joint Stereo"),_T("Dual Channel"),_T("Mono")
};

LPCTSTR CMP3ToolEntry::_cEmphasis[4]={
	_T("no emphasis"),_T("50/15 ms"),_T("??"),_T("CITT j.17")
};

//////////////////////////////////////////////////////////////////////
// Construction/Destruction

CMP3ToolEntry::CMP3ToolEntry()
{
	DoAlloc();
}

CMP3ToolEntry::CMP3ToolEntry(LPCTSTR datnam)
{
	DoAlloc();
	for (int i=strlen(datnam)-1;(BYTE)datnam[i]!=0x5c;i--){}
	(char)datnam[i] = 0;
	strcpy((char *)m_strName,(char *)&datnam[i+1]);
	strcpy((char *)m_strPath,datnam);
	(char)datnam[i] = 0x5c;
	ScanMP3((CString)datnam);
}

CMP3ToolEntry::~CMP3ToolEntry()
{
	delete m_strName;
	delete m_strPath;
	delete m_strTitle;
	delete m_strArtist;
	delete m_strAlbum;
	delete m_strComment;
	delete tmp_Year;
	delete tmp_Track;
	delete tmp_Bit;
	delete tmp_Size;
}

void CMP3ToolEntry::DoAlloc()
{
	m_strName = new TCHAR[256];
	m_strPath = new TCHAR[256];
	m_strTitle = new TCHAR[256];
	m_strArtist = new TCHAR[256];
	m_strAlbum = new TCHAR[256];
	m_strComment = new TCHAR[256];
	tmp_Year = new TCHAR[5];
	tmp_Track = new TCHAR[4];
	tmp_Bit = new TCHAR[10];
	tmp_Size = new TCHAR[10];
	wahrAnf=0;
	wahrEnd=0;
	changed=0;
	scanned=0;
}

void CMP3ToolEntry::ScanMP3(CString datnam)
{
	CFile f;
	if (!f.Open(datnam,CFile::modeRead|CFile::shareDenyWrite,NULL))
	{
		KENN=0;	
		AfxMessageBox("Can't open '"+datnam+"' -> file skipped.",MB_OK);
	}
	else
	{
		m_iSize = (long)f.GetLength();
		m_iGenre = -1;
    m_iTrack = 0;
		wahrEnd = m_iSize;
		BYTE* lbuf=new BYTE[0x20044];
		BYTE* pbuf=(BYTE*)&lbuf[0x44];
		//Kennungen suchen, die muss nicht am anfang stehen!!!!
		f.Read((void *)pbuf,0x20000);
		wahrAnf=0;
		if (*(unsigned long*)pbuf == 0x03334449)	//"ID3",3
		{
			wahrAnf = 0x14+((*(unsigned char*)&pbuf[0x10])<<8)+(*(unsigned char*)&pbuf[0x11]);
			//2do: muss nicht jpg, kann id3v2 allgemein sein; wird beim laden/speichern der m3ls ignoriert
			id3_jpg=1;
		}
		else
		{
			id3_jpg=0;
		}
		while((wahrAnf<0x1fffe)&&((pbuf[wahrAnf]!=0xff)||
			((pbuf[wahrAnf+1]<0xfa)&&(pbuf[wahrAnf+1]!=0xf3))||(pbuf[wahrAnf+1]==0xfe)||(pbuf[wahrAnf+1]==0xfc)||
			((pbuf[wahrAnf+1]&0x18)==8)||
			((pbuf[wahrAnf+2]&0xc)==0xc)||
			(pbuf[wahrAnf+2]<0x10)||
			(pbuf[wahrAnf+3]==0xff)||
			((pbuf[wahrAnf+3]&3)==2)))
		{
			wahrAnf++;
		}
		if (wahrAnf>=0x1fffe)
		{
			KENN=0;
			AfxMessageBox("'"+datnam+"' is no valid *.mp3 (no header in first 128k) -> skipped.",MB_OK);
		}
		else
		{
			KENN=*(unsigned long*)&pbuf[wahrAnf];
			//ID-Tag suchen
			f.Seek(-0xc4,CFile::end);
			f.Read((void *)lbuf,0xc4);
			if ((pbuf[0]=='T')&&(pbuf[1]=='A')&&(pbuf[2]=='G'))
			{
				wahrEnd=m_iSize-0x80;
				m_iGenre=(BYTE)pbuf[0x7f];
				if (m_iGenre>148)
				{
					m_iGenre =-1;
				}
        unsigned int commentLength=30;
        if (((pbuf[125]!=' ')||(pbuf[126]!=' '))&&(pbuf[126]<100))
        {
          m_iTrack=pbuf[126];
          commentLength=29;
        }
				for (unsigned int i=commentLength;(i==commentLength)||((i>=0)&&(pbuf[97+i]==' '));i--)
				{
					pbuf[97+i]=0;
				}
				strcpy(m_strComment,(char*)&pbuf[97]);
				pbuf[97]=0;
				m_iYear=atoi((char*)&pbuf[93]);
				if (m_iYear<100)
				{
					m_iYear += 1900;
					if (m_iYear!=1900)
					{
						changed |= (1<<chgID3);	//ID3-Zeug gendert
					}
				}
				for (i=30;(i==30)||((i>=0)&&(pbuf[63+i]==' '));i--)
				{
					pbuf[63+i]=0;
				}
				strcpy(m_strAlbum,(char*)&pbuf[63]);
				/*				for (i=0;i<strlen(m_strAlbum);i++)
				{
				if ((i==0)||(m_strAlbum[i-1]==' ')||(m_strAlbum[i-1]=='_'))
				{
				char c=m_strAlbum[i];
				CharUpperBuff(&c,1);
				if (c!=m_strAlbum[i])
				{
				m_strAlbum[i]=c;
				changed |= (1<<chgID3);
				}
				}
				}*/
				
				for (i=30;(i==30)||((i>=0)&&(pbuf[33+i]==' '));i--)
				{
					pbuf[33+i]=0;
				}
				strcpy(m_strArtist,(char*)&pbuf[33]);
				/*				for (i=0;i<strlen(m_strArtist);i++)
				{
				if ((i==0)||(m_strArtist[i-1]==' ')||(m_strArtist[i-1]=='_'))
				{
				char c=m_strArtist[i];
				CharUpperBuff(&c,1);
				if (c!=m_strArtist[i])
				{
				m_strArtist[i]=c;
				changed |= (1<<chgID3);
				}
				}
				}*/
				
				for (i=30;(i==30)||((i>=0)&&(pbuf[3+i]==' '));i--)
				{
					pbuf[3+i]=0;
				}
				strcpy(m_strTitle,(char*)&pbuf[3]);
				/*				for (i=0;i<strlen(m_strTitle);i++)
				{
				if ((i==0)||(m_strTitle[i-1]==' ')||(m_strTitle[i-1]=='_'))
				{
				char c=m_strTitle[i];
				CharUpperBuff(&c,1);
				if (c!=m_strTitle[i])
				{
				m_strTitle[i]=c;
				changed |= (1<<chgID3);
				}
				}
				}*/
				
				//nach BravaTag schauen
				if (*(long*)&lbuf[0x14]==0x76617242)	//"Brav"
				{
					f.Seek(*(long*)&lbuf[0]-0x81,CFile::begin);
					f.Read((void *)pbuf,0x80);
					if ((pbuf[0]=='T')&&(pbuf[1]=='A')&&(pbuf[2]=='G'))
					{
						wahrEnd=*(long*)&lbuf[0]-0x81;
						//hier steht ein (evtl 2.) ID3-Tag
						//2do: evtl auslesen/vgl, nderungsflag setzen
					}
					else
					{
						wahrEnd=*(long*)&lbuf[0]-1;
					}
					//hier beginnen die interessanten Daten vom Brava-Tag
					f.Seek(*(long*)&lbuf[0x10]-1,CFile::begin);
					f.Read((void *)pbuf,0x180);
					// W Titel, W Album, W Artist, W Genre, 4W 0, W Time, 12?, W Filename, W CDDB?
					char* temp=new char[200];
					//Brava-Title
					short len= *(short*)&pbuf[0];
					if (len>80)
					{
						//2do: BravaLink fehlerhaft: irgendeine Art von Meldung
						AfxMessageBox("BravaMist: "+(CString)m_strTitle,MB_OK);
					}
					else
					{
						int i=2;
						int j=0;
						while (len-->0)
						{
							temp[j++]=pbuf[i++];
						}
						temp[j]=0;
						if ((j>0)&&(stricmp(m_strTitle,temp)!=0))
						{
							if (m_strTitle!="")
							{
								if (m_strComment[0]!=0)
								{
									strcat(m_strComment,_T(", "));
								}
								strcat(m_strComment,temp);
							}
							else
							{
								strcpy(m_strTitle,temp);
							}	
						}
						//Brava-Album
						len= *(short*)&pbuf[i];
						if (len>80)
						{
							//2do: BravaLink fehlerhaft: irgendeine Art von Meldung
							AfxMessageBox("BravaMist: "+(CString)m_strTitle,MB_OK);
						}
						i+=2;
						j=0;
						while (len-->0)
						{
							temp[j++]=pbuf[i++];
						}
						temp[j]=0;
						if ((j>0)&&(stricmp(m_strAlbum,temp)!=0))
						{
							if (m_strAlbum[0]!=0)
							{
								strcat(m_strAlbum,_T(", "));
							}
							strcat(m_strAlbum,temp);
						}
						//Brava-Artist
						len= *(short*)&pbuf[i];
						if (len>80)
						{
							//2do: BravaLink fehlerhaft: irgendeine Art von Meldung
							AfxMessageBox("BravaMist: "+(CString)m_strTitle,MB_OK);
						}
						i+=2;
						j=0;
						while (len-->0)
						{
							temp[j++]=pbuf[i++];
						}
						temp[j]=0;
						if ((j>0)&&(stricmp(m_strArtist,temp)!=0))
						{
							if (m_strArtist[0]!=0)
							{
								strcat(m_strArtist,_T(", "));
							}
							strcat(m_strArtist,temp);
						}
						
						//Genre, ???, Zeit ueberlesen
						for (j=1;j<=6;j++)
						{
							i += *(short*)&pbuf[i];
							i += 2;
						}
						i+=12;
						//Brava-Filename
						i += *(short*)&pbuf[i];
						i += 2;
						//Brava-CDDB#
						len= *(short*)&pbuf[i];
						if (len>20)
						{
							//2do::Fehler
							AfxMessageBox(m_strTitle,MB_OK);
						}
						else
						{
							i+=2;
							j=0;
							while (len-->0)
							{
								temp[j++]=pbuf[i++];
							}
							temp[j]=0;
							if (j>0)
							{
								if (m_strComment[0]!=0)
								{
									strcat(m_strComment,_T(", "));
								}
								strcat(m_strComment,_T("#"));
								strcat(m_strComment,temp);
							}
						}
					}
					delete temp;
				}
			}
			else
			{
				changed |= (1<<chgID3);
				m_strComment[0]=0;
				m_strAlbum[0]=0;
				m_strArtist[0]=0;
				m_strTitle[0]=0;
				m_iGenre=-1;
				m_iYear=1900;
			}
			f.Close();
			// Title/Artist aus dateinamen generieren und nur evtl merken
			int j=0;
			int i=0;
			char strComment[256];
			char strTitle[256];
			char strArtist[256];
			strComment[0]=0;
			strArtist[0]=0;
			strTitle[0]=0;
			BOOL inKlammern=false;
			BOOL longTrenn;
			// # am Anfang loeschen
			i=0;
			if ((strspn(m_strName,"#1234567890")<strspn(m_strName,"#1234567890 "))&&(strspn(m_strName,"#1234567890 ")<strspn(m_strName,"#1234567890 -")))
			{
				i=strspn(m_strName,"#1234567890 -");
			}
			if ((m_strName[i]=='(')||(m_strName[i]=='['))
			{
				i++;
				inKlammern=true;
			}
			longTrenn=((strstr(&m_strName[i],"_-_")!=NULL)||(strstr(&m_strName[i]," - ")!=NULL));
			// Artist wird inKlammern oder vor '-' bercksichtigt
			while ((i+4<(int)strlen(m_strName))&&
				(((m_strName[i]!='-')&&(!longTrenn)&&(!inKlammern))||
				(((m_strName[i]!='-')||((m_strName[i+1]!=' ')&&(m_strName[i+1]!='_')))&&(!inKlammern)&&(longTrenn))||
				((m_strName[i]!=')')&&(m_strName[i]!=']')&&(inKlammern))))
			{
				if ((m_strName[i]=='_')||(m_strName[i]==' '))
				{
					if ((j>0)&&(strArtist[j-1])!=' ')
					{
						strArtist[j++]=' ';
					}
				}
				else if (m_strName[i]=='(')
				{
					while((m_strName[i]!=')')&&(i<(int)strlen(m_strName)-4)){i++;}
				}
				else if ((m_strName[i]>='a')&&(m_strName[i]<='z'))
				{
					if ((m_strName[i]=='n')&&(j>0)&&(strArtist[j-1]==' ')&&(m_strName[i+1])=='_')
					{
						strArtist[j++]='&';
					}
					else if ((j==0)||(strArtist[j-1]==' '))
					{
						strArtist[j++]=m_strName[i] & 0xdf;
					}
					else
					{
						strArtist[j++]=m_strName[i];
					}
				}
				else
				{
					strArtist[j++]=m_strName[i];
				}
				i++;
			}
			if (j==0)
			{
				strArtist[0]=0;
			}
			else
			{
				//Leerzeichen am Ende lschen
				if (strArtist[j-1]==' '){j--;}
				strArtist[j]=0;
			}
			while(((CString)(_T("-_ )]"))).Find(m_strName[i])>=0){i++;}
			j=0;
			while (i<(int)strlen(m_strName)-4)
			{
				if ((m_strName[i]=='_')||(m_strName[i]==' '))
				{
					if ((j>0)&&(strTitle[j-1])!=' ')
					{
						strTitle[j++]=' ';
					}
				}
				/*else if (m_strName[i]=='(')
				{
					int k=0;
					// rundklammer-comments aus name an comment ran
					// neu: besser auch nicht
					while((m_strName[++i]!=')')&&(i<(int)strlen(m_strName)-4))
					{
						strComment[k++]=m_strName[i];
					}
					strComment[k]=0;
				}*/
				else if ((m_strName[i]>='a')&&(m_strName[i]<='z'))
				{
					if ((m_strName[i]=='n')&&(j>0)&&(strArtist[j-1]==' ')&&(m_strName[i+1])=='_')
					{
						strTitle[j++]='&';
					}
					else if ((j==0)||(strTitle[j-1]==' '))
					{
						strTitle[j++]=m_strName[i] & 0xdf;
					}
					else
					{
						strTitle[j++]=m_strName[i];
					}
				}
				else
				{
					strTitle[j++]=m_strName[i];
					if (m_strName[i]=='-')
					{
						// wenn auch welche mit " - "/"_-_", dann "-" durchgehen lassen
						if ((!longTrenn)||(m_strName[i+1]==' ')||(m_strName[i+1]=='_'))
						{
							//AfxMessageBox("zweites '-' im Dateinamen -> Erkennung unsicher",MB_OK);
						}
					}
				}
				i++;
			}
			if (j==0)
			{
				strTitle[0]=0;
			}
			else
			{
				//Leerzeichen am Ende lschen
				if (strTitle[j-1]==' '){j--;}
				strTitle[j]=0;
			}
			//Tags aus Dateinamen bernehmen, falls vorher leer oder Zwang
			bool forceIt=((AfxGetApp()->GetProfileInt("","ForceGet",0))==1);
			if ((strTitle[0]!=0)&&(stricmp(strTitle,m_strTitle)!=0)&&
				((m_strTitle[0]==0)||(m_strTitle[0]=='?')||(m_strTitle[0]=='_')||(forceIt)))
			{
				strcpy(m_strTitle,strTitle);
				changed |= (1<<chgID3);
			}
			if ((strArtist[0]!=0)&&(stricmp(strArtist,m_strArtist)!=0)&&
				((m_strArtist[0]==0)||(m_strArtist[0]=='?')||(m_strArtist[0]=='_')||(forceIt)))
			{
				strcpy(m_strArtist,strArtist);
				changed |= (1<<chgID3);
			}
			if ((strComment[0]!=0)&&(stricmp(strComment,m_strComment)!=0)&&
				((m_strComment[0]==0)||(m_strComment[0]=='?')||(m_strComment[0]=='_')||(forceIt)))
			{
				strcpy(m_strComment,strComment);
				changed |= (1<<chgID3);
			}
		}
		delete lbuf;
	}

	if ((BOOL)(AfxGetApp()->GetProfileInt("","ChkAll",1)))
	{
		GetFrameStuff();
	}
	else
	{
		m_iMBitRate=1000*(int)_cBitrate[(KENN>>11)&3][(KENN>>18)&3][(KENN>>20)&15];
		m_iMSec=(wahrEnd-wahrAnf)/(m_iMBitRate/1000)*8;
		m_iFrameAnz=(int)((wahrEnd-wahrAnf)/((_cFrameLen[(KENN>>11)&3][(KENN>>9)&3])/1000*m_iMBitRate/GetSampleRate()));
	}
	UpdateChanged();
}
	

LPTSTR CMP3ToolEntry::GetGenre()
{
	return (char*)_cGenre[m_iGenre+1];
}

int CMP3ToolEntry::GetMBitRate()
{
//	return (int)_cBitrate[(KENN>>11)&3][(KENN>>18)&3][(KENN>>20)&15];
	return m_iMBitRate;
}

int CMP3ToolEntry::GetSampleRate()
{
	return (int)_cSamplerate[(KENN>>11)&3][(KENN>>18)&3];
}

int CMP3ToolEntry::GetFrameAnz()
{
//	return (int)(m_iSize/((int)(_cFrameLen[(KENN>>11)&3][(KENN>>9)&3])*GetBitRate()/GetSampleRate()));
	return m_iFrameAnz;
}

CString CMP3ToolEntry::GetTyp()
{
	return (CString)_cVersion[(KENN>>11)&3]+(CString)_cLayer[(KENN>>9)&3];
}

CString CMP3ToolEntry::GetLength()
{
//	int msec=(wahrEnd-wahrAnf)/GetBitRate()*8;
	int msec=m_iMSec;
	sprintf(len_s,"%i:%i%i.%i",msec/60000,(msec%60000)/10000,(msec/1000)%10,(msec/100)%10);
	return CString(len_s);
}

LPTSTR CMP3ToolEntry::GetChannel()
{
	return (char*)_cChannel[(KENN>>30)&3];
}

LPTSTR CMP3ToolEntry::GetEmphasis()
{
	return (char*)_cEmphasis[(KENN>>24)&3];
}

bool CMP3ToolEntry::Get_CrcFlag()
{
	return (bool)((KENN>>8)&1);
}

bool CMP3ToolEntry::Get_OrigFlag()
{
	return (bool)((KENN>>26)&1);
}

bool CMP3ToolEntry::Get_CopyFlag()
{
	return (bool)((KENN>>27)&1);
}

void CMP3ToolEntry::Set_OrigFlag(bool setIt)
{
	unsigned long kneu = KENN & (0xffffffff-(1<<26));
	kneu |= (((int)setIt)<<26);
	if (KENN!=kneu)
	{
		KENN=kneu;
		changed |= (1<<chgFLAG);
	}
}

void CMP3ToolEntry::Set_CopyFlag(bool setIt)
{
	unsigned long kneu = KENN & (0xffffffff-(1<<27));
	kneu |= (((int)setIt)<<27);
	if (KENN!=kneu)
	{
		KENN=kneu;
		changed |= (1<<chgFLAG);
	}
}

CString CMP3ToolEntry::addMyStr(LPTSTR orig)
{
	CWinApp* pApp = AfxGetApp();
	CString genIt;
	BOOL nachSpace=true;
	for (int i=0;orig[i]!=0;i++)
	{
		// "*","-" in "_" umwandeln
		if ((((BOOL)(pApp->GetProfileInt("","CnvSonder",1)))&&(orig[i]=='-'))||(orig[i]=='*'))
		{
			if (!nachSpace)
			{
				if ((BOOL)(pApp->GetProfileInt("","CnvSpace",1)))
				{
					genIt += "_";
				}
				else
				{
					genIt += " ";
				}
			}
			nachSpace=true;
			// '.' weglassen oder in '_'/' ' umwandeln
		}
		else if (((BOOL)(pApp->GetProfileInt("","CnvSonder",1)))&&(orig[i]=='.'))
		{
			if ((orig[i-2]!='.')&&(orig[i+2]!='.')&&(!nachSpace))
			{
				if ((BOOL)(pApp->GetProfileInt("","CnvSpace",1)))
				{
					genIt += "_";
				}
				else
				{
					genIt += " ";
				}
				nachSpace=true;
			}
			else
			{
				nachSpace=false;
			}
			//Rmische Zahlen umwandeln (auch wenn danach noch chars kommen ?!?)
		}
		else if (nachSpace&&((BOOL)(pApp->GetProfileInt("","CnvSonder",1)))&&(((CString)orig).Mid(i,3)==_T("III")))
		{
			genIt += "3";
			i += 2;
			nachSpace=false;
		}
		else if (nachSpace&&((BOOL)(pApp->GetProfileInt("","CnvSonder",1)))&&(((CString)orig).Mid(i,2)==_T("II")))
		{
			genIt += "2";
			i ++;
			nachSpace=false;
		}
		else if (nachSpace&&((BOOL)(pApp->GetProfileInt("","CnvSonder",1)))&&(((CString)orig).Mid(i,2)==_T("IV")))
		{
			genIt += "4";
			i ++;
			nachSpace=false;
			// Umlaute umwandeln
		}
		else if (((BOOL)(pApp->GetProfileInt("","CnvUml",1)))&&((CString)(_T(""))).Find(orig[i])>=0)
		{
			nachSpace=false;
      switch (orig[i])
      {
      case '':
      case '':
      case '':
      case '':
      case '':
        genIt += "a";
        break;
      case '':
      case '':
        genIt += "ae";
        break;
      case '':
        genIt += "c";
        break;
      case '':
      case '':
      case '':
      case '':
        genIt += "e";
        break;
      case '':
      case '':
      case '':
      case '':
        genIt += "i";
        break;
      case '':
        genIt += "n";
        break;
      case '':
      case '':
      case '':
      case '':
        genIt += "o";
        break;
      case '':
        genIt += "oe";
        break;
      case '':
      case '':
      case '':
        genIt += "u";
        break;
      case '':
        genIt += "ue";
        break;
      case '':
      case '':
        genIt += "y";
        break;
      case '':
      case '':
      case '':
      case '':
      case '':
        genIt += "A";
        break;
      case '':
      case '':
        genIt += "Ae";
        break;
      case '':
        genIt += "C";
        break;
      case '':
        genIt += "D";
        break;
      case '':
      case '':
      case '':
      case '':
        genIt += "E";
        break;
      case '':
      case '':
      case '':
      case '':
        genIt += "I";
        break;
      case '':
        genIt += "N";
        break;
      case '':
      case '':
      case '':
      case '':
        genIt += "O";
        break;
      case '':
        genIt += "Oe";
        break;
      case '':
      case '':
      case '':
        genIt += "U";
        break;
      case '':
        genIt += "Ue";
        break;
      case '':
        genIt += "Y";
        break;
      case '':
        genIt += "ss";
        break;
      }
			// "&" umwandeln
		}
		else if (((BOOL)(pApp->GetProfileInt("","CnvAmp",1)))&&((orig[i]=='&')||(orig[i]=='+')))
		{
			if (!nachSpace)
			{
				if ((BOOL)(pApp->GetProfileInt("","CnvSpace",1)))
				{
					genIt += "_";
				}
				else
				{
					genIt += " ";
				}
			}
			genIt += "n";
			nachSpace=false;
			if ((orig[i+1]!=0)&&(orig[i+1]!=' '))
			{
				if ((BOOL)(pApp->GetProfileInt("","CnvSpace",1)))
				{
					genIt += "_";
				}
				else
				{
					genIt += " ";
				}
				nachSpace=true;
			}
		}
		else if (nachSpace&&((BOOL)(pApp->GetProfileInt("","CnvAmp",1)))&&((((CString)orig).Mid(i,4)==_T("And "))||(((CString)orig).Mid(i,4)==_T("and "))))
		{
			genIt += "n";
			nachSpace=false;
			i += 2;
		}
		else if (nachSpace&&((BOOL)(pApp->GetProfileInt("","CnvAmp",1)))&&((((CString)orig).Mid(i,2)==_T("n "))||(((CString)orig).Mid(i,2)==_T("N "))))
		{
			genIt += "n";
			if ((BOOL)(pApp->GetProfileInt("","CnvSpace",1)))
			{
				genIt += "_";
			}
			else
			{
				genIt += " ";
			}
			nachSpace=true;
			i++;
		}
		else if ((BOOL)(pApp->GetProfileInt("","CnvAmp",1))&&(((CString)orig).Mid(i,3)==_T("'n'")))
		{
			if ((BOOL)(pApp->GetProfileInt("","CnvSpace",1)))
			{
				genIt += "_n_";
			}
			else
			{
				genIt += " n ";
			}
			nachSpace=true;
			i += 2;
			// Sonderzeichen weglassen
		}
		else if (((BOOL)(pApp->GetProfileInt("","CnvSonder",1)))&&(((CString)(_T("[]$%#~'`?!:;,/"))).Find(orig[i])>=0))
		{
			// feat und versus umwandeln
		}
		else if (nachSpace&&((BOOL)(pApp->GetProfileInt("","CnvAmp",1)))&&((((CString)orig).Mid(i,5)==_T("feat."))||(((CString)orig).Mid(i,5)==_T("Feat."))||(((CString)orig).Mid(i,5)==_T("feat "))||(((CString)orig).Mid(i,5)==_T("Feat "))))
		{
			genIt += "feat";
			nachSpace=false;
			i += 3;
		}
		else if (nachSpace&&((BOOL)(pApp->GetProfileInt("","CnvAmp",1)))&&((((CString)orig).Mid(i,3)==_T("ft."))||(((CString)orig).Mid(i,3)==_T("Ft."))||(((CString)orig).Mid(i,3)==_T("feat "))||(((CString)orig).Mid(i,3)==_T("Ft "))))
		{
			genIt += "feat";
			nachSpace=false;
			i ++;
		}
		else if (nachSpace&&((BOOL)(pApp->GetProfileInt("","CnvAmp",1)))&&((((CString)orig).Mid(i,3)==_T("vs."))||(((CString)orig).Mid(i,3)==_T("Vs."))||(((CString)orig).Mid(i,3)==_T("vs "))||(((CString)orig).Mid(i,3)==_T("Vs "))))
		{
			genIt += "vs";
			nachSpace=false;
			i ++;
		}
		else if (nachSpace&&((BOOL)(pApp->GetProfileInt("","CnvAmp",1)))&&((((CString)orig).Mid(i,6)==_T("versus"))))
		{
			genIt += "vs";
			nachSpace=false;
			i += 5;
		}
		else
		{
			switch (orig[i])
			{
			case ' ':
				if (nachSpace)
				{
					break;
				}
				nachSpace=true;
				if ((BOOL)(pApp->GetProfileInt("","CnvSpace",1)))
				{
					genIt += "_";
				}
				else
				{
					genIt += " ";
				}
				break;
			default:
				if (nachSpace)
				{
					//feat, vs, n ausschliessen
					CString s=CString(orig[i]);
					s.MakeUpper();
					genIt += s;
				}
				else
				{
					genIt += orig[i];
				}
				nachSpace=false;
				break;
			}
		}
	}
	//Leerzeichen am Ende loeschen
	for (i=genIt.GetLength();(--i>=0)&&((genIt.GetAt(i)=='_')||(genIt.GetAt(i)==' '));)
	{
		genIt = genIt.Left(i);
	}
	return genIt;
}

void CMP3ToolEntry::UpdateChanged()
{
	if (((BOOL)(AfxGetApp()->GetProfileInt("","DelBack",1)))&&(wahrEnd!=m_iSize))
	{
		if ((wahrEnd+128!=m_iSize)||(changed &(1<<chgID3)))
		{
			changed |= (1<<chgBACK);
		}
	}
	if (((BOOL)(AfxGetApp()->GetProfileInt("","DelFront",1)))&&(wahrAnf>0))
	{
		changed |= (1<<chgFRONT);
	}
}

int CMP3ToolEntry::AutoEdit(CAutoDlg* autoDlg)
{
	//Dateiname aus Tag generieren
	CWinApp* pApp = AfxGetApp();
	m_strNewName=_T("");
	if ((BOOL)(pApp->GetProfileInt("","Rename",1)))
	{
		CString datNam=pApp->GetProfileString("","ID2DatNam",_T("$Artist-$Title"));
		while (datNam.GetLength()>0)
		{
			if (datNam.Left(7)==_T("$Artist"))
			{
				m_strNewName += addMyStr(m_strArtist);
				datNam = datNam.Mid(7);
			}
			else if (datNam.Left(6)==_T("$Title"))
			{
				m_strNewName += addMyStr(m_strTitle);
				datNam = datNam.Mid(6);
			}
			else if (datNam.Left(6)==_T("$Album"))
			{
				m_strNewName += addMyStr(m_strAlbum);
				datNam = datNam.Mid(6);
			}
			else if (datNam.Left(6)==_T("$Genre"))
			{
				m_strNewName += addMyStr(_strdup(_cGenre[m_iGenre+1]));
				datNam = datNam.Mid(6);
			}
			else if (datNam.Left(8)==_T("$Comment"))
			{
				m_strNewName += addMyStr(m_strComment);
				datNam = datNam.Mid(8);
			}
      else if (datNam.Left(6)==_T("$Track"))
      {
        char s[4];
        sprintf(s,"%02i",m_iTrack);
				m_strNewName += addMyStr(s);
				datNam = datNam.Mid(6);
			}
			else
			{
				m_strNewName += datNam.Left(1);
				datNam = datNam.Mid(1);
			}
		}
		m_strNewName += _T(".mp3");
		if (m_strNewName.Compare(m_strName)!=0)
		{
			int status=autoDlg->Frage("Umbenennen:\n"+CString(m_strName)+" ->\n"+m_strNewName);
			//status=AfxMessageBox("Umbenennen:\n"+CString(m_strName)+" ->\n"+m_strNewName,MB_YESNOCANCEL,0);
			if (status==IDCANCEL)
			{
				return 2;
			}
			if (status==IDYES)
			{
				changed |= (1<<chgNAME);
			}
		}
	}

	//nur drum kmmern, wenn nicht beschdigt
	if (!(changed & (1<<chgERR)))
	{
		if ((BOOL)(AfxGetApp()->GetProfileInt("","SetID3",1)))
		{
			changed |= (1<<chgID3);
		}
		UpdateChanged();
	
		if ((BOOL)(pApp->GetProfileInt("","SetOrig",1)))
		{
			Set_OrigFlag(true);
		}
		if ((BOOL)(pApp->GetProfileInt("","DelCopy",1)))
		{
			Set_CopyFlag(false);
		}
	}

	SaveChanges();
	
	//1=Save, 2=Abort, 3=NoSave
	return 1;
}

void CMP3ToolEntry::shortenString(char* s, char* t)
{
	if ((strnicmp(s,"the ",4)==0)||(strnicmp(s,"die ",4)==0)) s+=4;
	bool ablank=false;
	t[0]=0;
	while (*s)
	{
		switch (*s)
		{
		case ' ':
		case ',':
		case '_':
			if (!ablank){*(t++) = *s; ablank=true;}
			break;
		case '\'':
		case '#':
		case '?':
		case '!':
		case '*':
		case '+':
		case '-':
		case '.':
			break;
    case '':
    case '':
    case '':
    case '':
    case '':
    case '':
    case '':
    case '':
    case '':
    case '':
			*(t++) = 'a';
			break;
		case '':
		case '':
		case '':
		case '':
			sprintf(t,"ae"); t+=2;
			break;
    case '':
    case '':
			*(t++) = 'c';
      break;
    case '':
			*(t++) = 'd';
      break;
    case '':
    case '':
    case '':
    case '':
    case '':
    case '':
    case '':
    case '':
			*(t++) = 'e';
      break;
    case '':
    case '':
    case '':
    case '':
    case '':
    case '':
    case '':
    case '':
			*(t++) = 'i';
      break;
    case '':
    case '':
			*(t++) = 'n';
      break;
    case '':
    case '':
    case '':
    case '':
    case '':
    case '':
    case '':
    case '':
			*(t++) = 'o';
      break;
    case '':
		case '':
			sprintf(t,"oe"); t+=2;
			break;
    case '':
    case '':
    case '':
    case '':
    case '':
    case '':
			*(t++) = 'u';
      break;
		case '':
		case '':
			sprintf(t,"ue"); t+=2;
			break;
    case '':
    case '':
    case '':
			*(t++) = 'y';
      break;
		case '':
			sprintf(t,"ss"); t+=2;
			break;
		default:
			*(t++) = (*s) & 0xdf; ablank=false;
		}
		s++;
	}
	*t = 0;
}

bool CMP3ToolEntry::equals(CMP3ToolEntry* e)
{
	char s0t[256];
	char s0a[256];
	char s1t[256];
	char s1a[256];
	shortenString(m_strTitle,(char*)&s0t);
	shortenString(m_strArtist,(char*)&s0a);
	shortenString(e->m_strTitle,(char*)&s1t);
	shortenString(e->m_strArtist,(char*)&s1a);
	return ((strcmp(s0t,s1t)==0)&&(strcmp(s0a,s1a)==0))||(stricmp(m_strName,e->m_strName)==0);
}

void CMP3ToolEntry::GetFrameStuff()
{
	CFile f;
	CString datnam=CString(m_strPath)+"\\"+CString(m_strName);
	unsigned char* buf=new unsigned char[16388];
	double msec=0;
	int frameanz=0;
	double bitrate=0;
	if (!f.Open(datnam,CFile::modeRead|CFile::shareDenyWrite,NULL))
	{
		AfxMessageBox("Cant open mp3 4 r",MB_OK);
	}
	else
	{
		long nextKenn=0;
		long lastKennOK=-1;

		long wahrAnfAdd=0;
		long first_not_empty=0;
		int dat_blocks=0;
		int dat_started=0;

		long first_not_full=0;
		int dat_ended=0;

		int borrow=0;
		int dontborrow=0;
		int sil_count=0;
		int sil_len=1000;
		scanned = 1;
		wahrEnd -= wahrAnf;
		for (int i=0;16384*i<wahrEnd;i++)
		{
			f.Seek(16384*i+wahrAnf,CFile::begin);
			f.Read((void *)buf,16384);
			if (i>0)
			{
				buf[0]=buf[16384];
				buf[1]=buf[16385];
				buf[2]=buf[16386];
			}
			f.Read((void*)&buf[16384],3);
			if (((lastKennOK<150000)&(!dat_started))||(lastKennOK>wahrEnd-150000))
			{
				if (lastKennOK<i*16384)
				{
					for (int j=0;j<nextKenn%16384;j++)
					{
						if ((buf[j%16384]==0)||(buf[j%16384]==0xff)||(buf[j%16384]==0x55)||(buf[j%16384]==0xaa))
						{
							sil_count++;
						}
					}
					//silence_kill am Anfang
					if (lastKennOK<150000)
					{
						if (sil_count*100/sil_len>80)
						{
							first_not_empty=nextKenn;
							dat_blocks=0;
						}
						else
						{
							dat_blocks++;
							if (dat_blocks>2)
							{
								dat_started=1;
								wahrAnfAdd=first_not_empty;
							}
						}
					}
					if (dat_started)
					//silence_kill am Ende
					{
						if (sil_count*100/sil_len>80)
						{
							if (!dat_ended)
							{
								first_not_full=lastKennOK;
							}
							dat_blocks=0;
							dat_ended=1;
						}
						else
						{
							dat_blocks++;
							if (dat_blocks>2)
							{
								first_not_full=nextKenn;
								dat_ended=0;
							}
						}
					}
				}
			}
			while ((nextKenn-16384*i<16384)&&(nextKenn<wahrEnd))
			{
				unsigned long y=*((unsigned long*)&buf[nextKenn % 16384]);
				int bitr=(int)_cBitrate[(y>>11)&3][(y>>18)&3][(y>>20)&15];
				//2do:? Sonderregelvereinheitlichen: layer2: 3 0 8 = 128 kbit
				if ((((y>>9)&3)==2)&&(((y>>11)&3)==3)&&(((y>>18)&3)==0)&&(((y>>20)&15)==8))
				{
					bitr=128;
				}
				int flen=(int)_cFrameLen[(y>>11)&3][(y>>9)&3]*bitr/(int)_cSamplerate[(y>>11)&3][(y>>18)&3];
				if ((buf[(nextKenn % 16384)+2]&2)==2)
				{
					flen++;
				}
				//wenn kein g"ultiger Block, dann keine g"ultige Blocklaenge festlegen
				if (((buf[(nextKenn % 16384)]!=0xff)||
					((buf[(nextKenn % 16384)+1]<0xfa)&&(buf[(nextKenn % 16384)+1]!=0xf3))||(buf[(nextKenn % 16384)+1]==0xfe)||(buf[(nextKenn % 16384)+1]==0xfc)||
					((buf[(nextKenn % 16384)+1]&0x18)==8)||
					((buf[(nextKenn % 16384)+2]&0xc)==0xc)||
					(buf[(nextKenn % 16384)+2]<0x10)||
					(buf[(nextKenn % 16384)+3]==0xff)||
					((buf[(nextKenn % 16384)+3]&3)==2)))
				{
					flen=2;
				}
				flen += borrow;
				//unsinnige Blockgre:
				if ((flen<0x60)||(flen>0x420))
				{
					if ((borrow==0)&&(dontborrow==0))
					{
						nextKenn+=2;	//2byte lngerer block, dafr nchster 2 byte krzer
						borrow=-2;
						continue;
					}
					else
					{
						if (lastKennOK>=wahrEnd-16384)
						{
							wahrEnd=lastKennOK;
							continue;
						}
						else if (nextKenn<0x10000)	//falls Fehler in ersten 64k -> weitersuchen
						{
							if (dontborrow)
							{
								nextKenn++;
								wahrAnfAdd=nextKenn;
							}
							else
							{
								nextKenn=lastKennOK+1;
								borrow=0;
								dontborrow=1;
								msec=0;
								frameanz=0;
								bitrate=0;
							}
							continue;
						}
						char ss[512];
						sprintf(ss,"'%s':\tauch nach +2 Mist:\r\noffset: %x, wert: %x, flen: %x     %i  %i  %i       (%i %i %i)\r\nwird trotzdem gelistet (Frameanz+Zeit falsch)",m_strName,nextKenn,*((unsigned long*)&buf[nextKenn % 16384]),flen,(int)_cFrameLen[(y>>11)&3][(y>>9)&3],(int)_cBitrate[(y>>11)&3][(y>>18)&3][(y>>20)&15],(int)_cSamplerate[(y>>11)&3][(y>>18)&3],(y>>11)&3,(y>>18)&3,(y>>20)&15);
						AfxMessageBox(ss,MB_OK);
						nextKenn=0x7fff0000;
						i=0x1fff;
						changed |= (1<<chgERR);
						scanned = 0;
						break;
					}
				}
				else
				{
					borrow=0;
					dontborrow=0;
				}
				lastKennOK=nextKenn;
				// 0/FF-Frames an Anfang und Ende (je 150k) detecten
				if (((nextKenn<150000)&(!dat_started))||(nextKenn>wahrEnd-150000))
				{
					sil_len=flen;
					sil_count=0;
					for (long j=nextKenn+2;(j<nextKenn+flen)&&(j-(nextKenn-(nextKenn%16384))<16384);j++)
					{
						if ((buf[j%16384]==0)||(buf[j%16384]==0xff)||(buf[j%16384]==0x55)||(buf[j%16384]==0xaa))
						{
							sil_count++;
						}
					}
					if ((nextKenn+flen-(nextKenn-(nextKenn%16384))<=16384))
					{
						//silence_kill am Anfang
						if (nextKenn<150000)
						{
							if (sil_count*100/sil_len>80)
							{
								first_not_empty=nextKenn+flen;
								dat_blocks=0;
							}
							else
							{
								dat_blocks++;
								if (dat_blocks>2)
								{
									dat_started=1;
									wahrAnfAdd=first_not_empty;
								}
							}
						}
						if (dat_started)
						//silence_kill am Ende
						{
							if (sil_count*100/sil_len>80)
							{
								if (!dat_ended)
								{
									first_not_full=nextKenn;
								}
								dat_blocks=0;
								dat_ended=1;
							}
							else
							{
								dat_blocks++;
								if (dat_blocks>2)
								{
									first_not_full=nextKenn+flen;
									dat_ended=0;
								}
							}
						}
					}
				}
				if (nextKenn<0x7fff0000)
				{
					if (dat_started)
					{
						msec += (double)_cFrameLen[(y>>11)&3][(y>>9)&3]/(double)_cSamplerate[(y>>11)&3][(y>>18)&3]*8;
						frameanz++;
						bitrate+=(double)_cFrameLen[(y>>11)&3][(y>>9)&3]*(double)bitr/(double)_cSamplerate[(y>>11)&3][(y>>18)&3]*8;
					}
					nextKenn += flen;
				}
			}
		}
		if (wahrEnd>first_not_full)
		{
			wahrEnd=first_not_full;
		}
		wahrEnd += wahrAnf;
		wahrAnf += wahrAnfAdd;
	}
	delete buf;
	m_iMSec=(int)msec;
	m_iMBitRate=(int)(1000*bitrate/msec+0.5);
	m_iFrameAnz=frameanz;
}


void CMP3ToolEntry::SaveChanges()
{
	CFile f;
	CString datnam=CString(m_strPath)+"\\"+CString(m_strName);
	unsigned char* buf=new unsigned char[16388];
	//fehlerhafte werden nicht bearbeitet!
	if (!(changed & (1<<chgERR)))
	{
		//2do: evtl Warnhinweis: versaue jetzt Datei; Fehlerabfang
		if (changed & ((1<<chgFRONT)|(1<<chgFLAG)|(1<<chgBACK)|(1<<chgID3)))
		{
			if (!f.Open(datnam,CFile::modeReadWrite|CFile::shareDenyWrite,NULL))
			{
				AfxMessageBox("Cant open mp3 4 rw",MB_OK);
			}
			else
			{
				if (changed & ((1<<chgFLAG)|(1<<chgFRONT)|(1<<chgBACK)))
				{
					//diese nderungen mach ich nur an Blockgescannten
					if ((scanned)&&(changed & ((1<<chgFLAG)|(1<<chgFRONT))))
					{
						long nextKenn;
						nextKenn = 0;
						int borrow=0;
						for (int i=0;16384*i+wahrAnf<wahrEnd;i++)
						{
							f.Seek(16384*i+wahrAnf,CFile::begin);
							f.Read((void *)buf,16384);
							if (changed & (1<<chgFLAG))
							{
								//alle KENN in Datei aendern
								if (i>0)
								{
									buf[0]=buf[16384];
									buf[1]=buf[16385];
									buf[2]=buf[16386];
								}
								f.Read((void*)&buf[16384],3);
								while ((nextKenn-16384*i<16384)&&(nextKenn+wahrAnf<wahrEnd))
								{
									unsigned long y=*((unsigned long*)&buf[nextKenn % 16384]);
									int bitr=(int)_cBitrate[(y>>11)&3][(y>>18)&3][(y>>20)&15];
									//2do: Sonderregelvereinheitlichen: layer2: 3 0 8 = 128 kbit
									if ((((y>>9)&3)==2)&&(((y>>11)&3)==3)&&(((y>>18)&3)==0)&&(((y>>20)&15)==8))
									{
										bitr=128;
									}
									int flen=(int)_cFrameLen[(y>>11)&3][(y>>9)&3]*bitr/(int)_cSamplerate[(y>>11)&3][(y>>18)&3];
									if ((buf[(nextKenn % 16384)+2]&2)==2)
									{
										flen++;
									}
									flen += borrow;
									if ((flen<0x60)||(flen>0x420))
									{
										if (borrow==0)
										{
											nextKenn+=2;	//2byte lngerer block, dafr nchster 2 byte krzer
											borrow=-2;
											continue;
										}
										else
										{
											char ss[100];
											sprintf(ss,"auch nach +2 Mist: offset: %x, wert: %x, flen: %x     %i  %i  %i       (%i %i %i)",nextKenn,*((unsigned long*)&buf[nextKenn % 16384]),flen,(int)_cFrameLen[(y>>11)&3][(y>>9)&3],(int)_cBitrate[(y>>11)&3][(y>>18)&3][(y>>20)&15],(int)_cSamplerate[(y>>11)&3][(y>>18)&3],(y>>11)&3,(y>>18)&3,(y>>20)&15);
											AfxMessageBox(ss,MB_OK);
											//2do: fehlerabfangen
											continue;
										}
									}
									else
									{
										borrow=0;
									}
									*((unsigned long*)&buf[nextKenn % 16384]) &= 0xf3ffffff;
									*((unsigned long*)&buf[nextKenn % 16384]) |= (KENN & 0x0c000000);
									nextKenn += flen;
								}
							}
							f.Seek(16384*i,CFile::begin);
							f.Write((void *)buf,16384);
						}
						if (changed & (1<<chgFRONT))
						{
							//Anfang, Flags und Ende gendert
							f.SetLength(wahrEnd-wahrAnf);
							m_iSize=wahrEnd-wahrAnf;
							wahrEnd-=wahrAnf;
							id3_jpg=0;
							wahrAnf=0;
						}
						else
						{
							//Flags und Ende gendert
							f.SetLength(wahrEnd);
							m_iSize=wahrEnd;
						}
					}
					else
					{
						//nur Ende gendert
						f.SetLength(wahrEnd);
						m_iSize=wahrEnd;
					}
					changed &= (0xff-((1<<chgFRONT)|(1<<chgFLAG)|(1<<chgBACK)));
				}
				//hier angekommen->soll, SetID3->darf, iSize=wahrEnd->kann ID3 ndern
				if ((AfxGetApp()->GetProfileInt("","SetID3",1)==1)&&(m_iSize==wahrEnd))
				{
					memset(buf,0,0x80);
					buf[0]='T';
					buf[1]='A';
					buf[2]='G';
					if (strlen(m_strTitle)>30)
					{
						AfxMessageBox("Title tag too long in: "+(CString)m_strName+"\r\nWill be shortend in *.mp3 but kept in list!",MB_OK);
					}
					else if (strlen(m_strArtist)>30)
					{
						AfxMessageBox("Artist tag too long in: "+(CString)m_strName+"\r\nWill be shortend in *.mp3 but kept in list!",MB_OK);
					}
					else if (strlen(m_strAlbum)>30)
					{
						AfxMessageBox("Album tag too long in: "+(CString)m_strName+"\r\nWill be shortend in *.mp3 but kept in list!",MB_OK);
					}
					else if (strlen(m_strComment)>29)
					{
						AfxMessageBox("Comment tag too long in: "+(CString)m_strName+"\r\nWill be shortend in *.mp3 but kept in list!",MB_OK);
					}
					strncpy((char*)&buf[3],m_strTitle,30);
					strncpy((char*)&buf[33],m_strArtist,30);
					strncpy((char*)&buf[63],m_strAlbum,30);
					if (m_iYear!=1900)
					{
						itoa(m_iYear,(char*)&buf[93],10);
					}
					strncpy((char*)&buf[97],m_strComment,29);
          buf[126] = m_iTrack;
					buf[127] = m_iGenre;
					f.Seek(0,CFile::end);
					f.Write(buf,0x80);
					m_iSize += 0x80;
					changed &= (0xff-(1<<chgID3));
				}
				f.Close();
			}
		}
	}
	delete buf;
	
	if (changed & (1<<chgNAME))
	{
		char it[10];
		bool didit=true;
		CString olds;
		CString newi;
		try
		{
//2do: use forward slashes to work in wine!!!!
			olds=CString(m_strPath)+"\\"+CString(m_strName);
			newi=CString(m_strPath)+"\\"+m_strNewName;
			CFile::Rename(*((char**)&olds),*((char**)&newi));
		}
		catch( CFileException* e )
		{
			AfxMessageBox("Unable to rename "+CString(m_strName)+" cause: "+_itoa(e->m_cause,it,10),MB_OK,0);
			didit=false;
		}
		if (didit)
		{
			strcpy(m_strName,*((char**)&m_strNewName));
			changed &= (0xff-(1<<chgNAME));
		}
	}	
}

void CMP3ToolEntry::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		ar << (CString)m_strName << (CString)m_strPath << (CString)m_strTitle;
		ar << (CString)m_strArtist << (CString)m_strAlbum << (CString)m_strComment;
		ar << m_iSize << m_iGenre << m_iYear << KENN << m_iMSec << m_iMBitRate << m_iFrameAnz << wahrAnf << wahrEnd << changed << scanned << m_iTrack;
	}
	else
	{
		CString getit;
		ar >> getit; strcpy(m_strName,getit);
		ar >> getit; strcpy(m_strPath,getit);
		ar >> getit; strcpy(m_strTitle,getit);
		ar >> getit; strcpy(m_strArtist,getit);
		ar >> getit; strcpy(m_strAlbum,getit);
		ar >> getit; strcpy(m_strComment,getit);
		ar >> m_iSize >> m_iGenre >> m_iYear >> KENN >> m_iMSec >> m_iMBitRate >> m_iFrameAnz >> wahrAnf >> wahrEnd >> changed >> scanned >> m_iTrack;
		UpdateChanged();
	}
}

