// MP3ToolDoc.h : interface of the CMP3ToolDoc class
//

#ifndef CMP3ToolDoc__H
#define CMP3ToolDoc__H

#include "EditDlg.h"

enum{COL_NAME,COL_PATH,COL_TITLE,COL_ARTIST,COL_ALBUM,COL_SIZE,COL_LEN,
COL_GENRE,COL_YEAR,COL_COMMENT,COL_TRACK,COL_BITRATE,COL_ORIG,COL_COPY,
NUM_COLUMNS};
#define XLS_COLUMNS	6

class CMP3ToolDoc : public CDocument
{
	DECLARE_DYNCREATE(CMP3ToolDoc)
		
	// Construction
protected: // create from serialization only
	CMP3ToolDoc();
	
	// Attributes
public:
	static LPCTSTR _gszColumnLabel[NUM_COLUMNS];
	static const int _gnColumnWidth[NUM_COLUMNS];
	BOOL myModifiedFlag;
	BOOL nixMehrDa;
	BOOL willKeinNeues;
	
	// Operations
public:
	
	// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMP3ToolDoc)
public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	virtual void SetTitle(LPCTSTR lpszTitle);
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual BOOL CanCloseFrame( CFrameWnd* pFrame );
	virtual void DeleteContents();
	virtual void OnCloseDocument();
	//}}AFX_VIRTUAL
	
	// Implementation
protected:
	WORD MakeXLSLabel(LPBYTE ziel, LPTSTR quel, WORD row, WORD col);
	WORD MakeXLSInt(LPBYTE ziel, short myint, WORD row, WORD col);
	WORD MakeXLSNumb(LPBYTE ziel, double mydouble, WORD row, WORD col);
public:
	WORD MakeXLSRow(LPBYTE row, CMP3ToolEntry* eintr, WORD entryx);
	virtual ~CMP3ToolDoc();
	LPCTSTR GetItem(CMP3ToolEntry* entry, int col);
	CString m_winTitle;
	CString CMP3ToolDoc::GetChanged();
	
	// Generated message map functions
protected:
	//{{AFX_MSG(CMP3ToolDoc)
	afx_msg void OnAddMP3s();
	afx_msg void OnSubMP3s();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
#endif