// EditDlg.cpp : implementation file
//

#include "stdafx.h"
#include "MP3Tool.h"
#include "EditDlg.h"

/////////////////////////////////////////////////////////////////////////////
// CEditDlg dialog

CEditDlg::CEditDlg(CWnd* pParent /*=NULL*/):CDialog(CEditDlg::IDD, pParent)
{
	m_bUserControl=false;
	//{{AFX_DATA_INIT(CEditDlg)
	// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

void CEditDlg::InitEntry(CMP3ToolEntry* entry)
{
	eintrag=entry;
}

void CEditDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEditDlg)
	// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CEditDlg, CDialog)
//{{AFX_MSG_MAP(CEditDlg)
ON_WM_PAINT()
ON_BN_CLICKED(IDNOSAVE, OnNosave)
ON_EN_CHANGE(IDC_EDIT_ARTIST, OnChangeID3)
ON_EN_CHANGE(IDC_EDIT_NAME, OnChangeNam)
ON_BN_CLICKED(IDC_CHECK_ORIG, OnChangeMpg)
	ON_BN_CLICKED(IDC_JPG, OnJpg)
ON_EN_CHANGE(IDC_EDIT_ALBUM, OnChangeID3)
ON_EN_CHANGE(IDC_EDIT_TITLE, OnChangeID3)
ON_CBN_SELCHANGE(IDC_COMBO_GENRE, OnChangeID3)
ON_EN_CHANGE(IDC_EDIT_COMMENT, OnChangeID3)
ON_BN_CLICKED(IDC_CHECK_COPY, OnChangeMpg)
ON_EN_CHANGE(IDC_EDIT_YEAR, OnChangeID3)
	ON_EN_CHANGE(IDC_EDIT_TRACK, OnChangeID3)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEditDlg message handlers
CString CEditDlg::GetChanged(int what)
{
	if (((tempChanged)&what)>0)
	{
		return " *";
	}
	else
	{
		return "";
	}
}

void CEditDlg::OnPaint()
{
	CPaintDC dc(this); // device context for painting
	SetWindowText("Manuelles Editieren - ["+(CString)(eintrag->m_strName)+GetChanged(0xff)+"]");
	GetDlgItem(IDC_FR_ID3)->SetWindowText("ID3-Tag"+GetChanged(1<<chgID3));
	GetDlgItem(IDC_FR_MP3)->SetWindowText("MP3-Info"+GetChanged((1<<chgFRONT)|(1<<chgBACK)|(1<<chgFLAG)));
	GetDlgItem(IDC_FR_NAM)->SetWindowText("Dateiname"+GetChanged(1<<chgNAME));
	GetDlgItem(IDC_FR_NAM)->SetWindowText("Dateiname"+GetChanged(1<<chgNAME));
	GetDlgItem(IDC_LAB_SIZ)->SetWindowText("Size"+GetChanged((1<<chgFRONT)|(1<<chgBACK))+":");
	GetDlgItem(IDC_LAB_ORI)->SetWindowText("Original"+GetChanged(1<<chgFLAG)+":");
	// Do not call CDialog::OnPaint() for painting messages
}

BOOL CEditDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	tempChanged=eintrag->changed;
	GetDlgItem(IDC_EDIT_TITLE)->SetWindowText(eintrag->m_strTitle);
	GetDlgItem(IDC_EDIT_ARTIST)->SetWindowText(eintrag->m_strArtist);
	GetDlgItem(IDC_EDIT_ALBUM)->SetWindowText(eintrag->m_strAlbum);
	CComboBox* genBox=(CComboBox*)GetDlgItem(IDC_COMBO_GENRE);
	for (int i=0;i<150;i++)
	{
		genBox->AddString(eintrag->_cGenre[i]);
	}
	genBox->SetCurSel(eintrag->m_iGenre+1);
	GetDlgItem(IDC_EDIT_COMMENT)->SetWindowText(eintrag->m_strComment);
	
	char* temp=new char[256];
	char* temp2=new char[30];
	//".mp3" abbasteln
	strcpy(temp,eintrag->m_strName);
	*strrchr(temp,'.')=0;
	GetDlgItem(IDC_EDIT_NAME)->SetWindowText(temp);
  temp[0]=0;
  if (eintrag->m_iYear != 1900)
  {
	  _itoa(eintrag->m_iYear,temp,10);
  }
	GetDlgItem(IDC_EDIT_YEAR)->SetWindowText(temp);
  temp[0]=0;
  if (eintrag->m_iTrack)
  {
	  _itoa(eintrag->m_iTrack,temp,10);
  }
	GetDlgItem(IDC_EDIT_TRACK)->SetWindowText(temp);
	_itoa(eintrag->m_iSize,temp,10);
	strcat(temp,_T(" bytes"));
	GetDlgItem(IDC_ST_SIZ)->SetWindowText(temp);
	_itoa(eintrag->GetSampleRate(),temp,10);
	strcat(temp,_T(" Hz, "));
	strcat(temp,eintrag->GetChannel());
	GetDlgItem(IDC_ST_SAMP)->SetWindowText(temp);
	if (eintrag->GetMBitRate()%1000==0)
	{
		_itoa(eintrag->GetMBitRate()/1000,temp,10);
	}
	else
	{
		sprintf(temp,"%i.%i%i",eintrag->GetMBitRate()/1000,(eintrag->GetMBitRate()/100)%10,(eintrag->GetMBitRate()/10)%10);
	}
	strcat(temp,_T(" kbit, "));
	_itoa(eintrag->GetFrameAnz(),temp2,10);
	strcat(temp,temp2);
	strcat(temp,_T(" frames"));
	GetDlgItem(IDC_ST_BIT)->SetWindowText(temp);

	GetDlgItem(IDC_ST_LEN)->SetWindowText(eintrag->GetLength());
	
	GetDlgItem(IDC_ST_TYP)->SetWindowText(eintrag->GetTyp());
	GetDlgItem(IDC_ST_EMPH)->SetWindowText(eintrag->GetEmphasis());
	
	((CButton*)GetDlgItem(IDC_CHECK_CRC))->SetCheck(eintrag->Get_CrcFlag());
	((CButton*)GetDlgItem(IDC_CHECK_COPY))->SetCheck(eintrag->Get_CopyFlag());
	((CButton*)GetDlgItem(IDC_CHECK_ORIG))->SetCheck(eintrag->Get_OrigFlag());

	if (eintrag->id3_jpg==1)
	{
		((CButton*)GetDlgItem(IDC_JPG))->EnableWindow(TRUE);
	}

	sprintf(temp,"Front:%i, Back:%i",eintrag->wahrAnf,eintrag->m_iSize-eintrag->wahrEnd);
	if (eintrag->changed & (1<<chgERR))
	{
		((CButton*)GetDlgItem(IDOK))->EnableWindow(FALSE);
		strcat(temp,", Error *");
	}
	GetDlgItem(IDC_ST_CUT)->SetWindowText(temp);

	if (!(eintrag->scanned))
	{
		((CButton*)GetDlgItem(IDC_CHECK_ORIG))->EnableWindow(FALSE);
		((CButton*)GetDlgItem(IDC_CHECK_COPY))->EnableWindow(FALSE);
		GetDlgItem(IDC_LAB_BITR)->SetWindowText("Bitrate ?:");
		GetDlgItem(IDC_LAB_LEN)->SetWindowText("Length ?:");
	}

	delete temp;
	delete temp2;
	
	m_bUserControl=true;	//User-changes in Edits registrieren
	return true;
}

void CEditDlg::OnNosave()
{
	//Aenderungen verwerfen
	EndDialog(3);
}

void CEditDlg::OnOK() 
{
	if(tempChanged==0)
	{
		OnNosave();
	}
	else
	{
		eintrag->changed=tempChanged;
		eintrag->UpdateChanged();
		//hier werden die Aenderungen im Dialog in eintrag geschrieben
		GetDlgItem(IDC_EDIT_TITLE)->GetWindowText(eintrag->m_strTitle,79);
		GetDlgItem(IDC_EDIT_ARTIST)->GetWindowText(eintrag->m_strArtist,79);
		GetDlgItem(IDC_EDIT_ALBUM)->GetWindowText(eintrag->m_strAlbum,79);
		char* temp=new char[256];
		GetDlgItem(IDC_EDIT_YEAR)->GetWindowText(temp,5);
		eintrag->m_iYear=atoi(temp);
    if (eintrag->m_iYear==0)
    {
      eintrag->m_iYear=1900;
    }
		eintrag->m_iGenre=((CComboBox*)GetDlgItem(IDC_COMBO_GENRE))->GetCurSel()-1;
		GetDlgItem(IDC_EDIT_COMMENT)->GetWindowText(eintrag->m_strComment,79);
		GetDlgItem(IDC_EDIT_TRACK)->GetWindowText(temp,3);
		eintrag->m_iTrack=atoi(temp);
		GetDlgItem(IDC_EDIT_NAME)->GetWindowText(temp,127);
		eintrag->m_strNewName=CString(temp)+_T(".mp3");
		delete temp;
		eintrag->Set_OrigFlag(((CButton*)GetDlgItem(IDC_CHECK_ORIG))->GetCheck()==1);
		eintrag->Set_CopyFlag(((CButton*)GetDlgItem(IDC_CHECK_COPY))->GetCheck()==1);
		
		// und dann soll der Eintrag sich ums wirkliche sichern kuemmern
		eintrag->SaveChanges();
		CDialog::OnOK();
	}
}

void CEditDlg::OnChangeID3()
{
	if (m_bUserControl)
	{
		tempChanged |= (1<<chgID3);
		OnPaint();
	}
}

void CEditDlg::OnChangeMpg()
{
	if (m_bUserControl)
	{
		tempChanged |= (1<<chgFLAG);
		OnPaint();
	}
}

void CEditDlg::OnChangeNam()
{
	if (m_bUserControl)
	{
		tempChanged |= (1<<chgNAME);
		OnPaint();
	}
}

void CEditDlg::OnJpg() 
{
	CFile f;
	CString datnam=CString(eintrag->m_strPath)+"\\"+CString(eintrag->m_strName);
	unsigned char* buf=new unsigned char[16384];
	if (!f.Open(datnam,CFile::modeRead|CFile::shareDenyWrite,NULL))
	{
		AfxMessageBox("Cant open mp3 4 r",MB_OK);
		return;
	}
	else
	{
		f.Read(buf,16384);
		f.Close();
	}
	if (((*(unsigned char*)&buf[0x10])<<8)+(*(unsigned char*)&buf[0x11])<16300)
	{
		datnam="c:\\temp.jpg";
		f.Open(datnam,CFile::modeCreate | CFile::modeWrite,NULL);
		f.Write((void*)&buf[0x21],((*(unsigned char*)&buf[0x10])<<8)+(*(unsigned char*)&buf[0x11]));
		f.Close();
		ShellExecute(m_hWnd, "open",datnam,NULL,eintrag->m_strPath,SW_SHOW);
	}
	delete buf;
}
