<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
Change Log:
$Log: generate-intermediate-code.xsl,v $
Revision 1.1  2004/06/15 12:41:22  loetzsch
changed XABSL version from 2.1 to 2.2 on the occasion of a new XABSL release

Revision 1.1.1.1  2004/05/22 17:37:46  cvsadm
created new repository GT2004_WM

Revision 1.1  2003/10/07 10:13:25  cvsadm
Created GT2004 (M.J.)

Revision 1.5  2003/09/20 16:34:16  loetzsch
renamed "following-option-..." to "subsequent-option-.." and
"following-basic-behavior-.." to "subsequent-basic-behavior-.."
for consistency with publications

Revision 1.4  2003/08/09 12:19:05  loetzsch
renamed question-mark-operator to conditional-expression

Revision 1.3  2003/07/23 22:25:52  loetzsch
implemented question mark operator

Revision 1.2  2003/07/21 19:18:07  loetzsch
- Xabsl2 AND and OR operators now can contain more than 2 operands
- speed improvements and cleanup

Revision 1.1.1.1  2003/07/02 09:40:29  cvsadm
created new repository for the competitions in Padova from the 
tamara CVS (Tuesday 2:00 pm)

removed unused solutions

Revision 1.1  2003/06/25 01:19:51  loetzsch
created xabsl 2.1
Differences to xabsl2.0: No predefined conditions, documentation uses new dot

Revision 1.15  2003/05/05 22:06:16  loetzsch
added support for common decision trees

Revision 1.14  2003/05/05 17:47:55  loetzsch
added in Xabsl2:
- marking of states as target-states with attribute is-target-state="true"
- boolean expression "subsequent-option-reached-target-state"
- common-decision-tree

Revision 1.13  2003/04/21 20:53:34  loetzsch
made validation and code generation faster
- the element xabsl:agent doesn't contain any options anymore
- options are now included to agents.xml instead into several agents
- removed unused options

Revision 1.12  2003/01/18 18:46:29  loetzsch
- symbols, conditions and agents don't need to be added to the agents anymore.

Revision 1.11  2003/01/15 20:11:46  loetzsch
fixed a bug in the template for xabsl:time-of-option-execution

Revision 1.10  2003/01/14 21:07:42  loetzsch
change intermediate code for xabsl:divide from '/' to 'd', because '/'
caused the input file stream to crash

Revision 1.9  2003/01/14 16:28:32  loetzsch
creation of references to output symbols added
setting of output symbols added

Revision 1.8  2003/01/13 22:39:38  loetzsch
implemented the execution of the engine.

Revision 1.7  2003/01/13 13:17:46  loetzsch
Renamed element "option-parameter" to "option-parameter-ref".
Creation of boolean and decimal expressions finished.

Revision 1.6  2003/01/12 14:54:05  loetzsch
continued creation of option tree: Xabsl2Statement and derivates added

Revision 1.5  2003/01/11 14:41:42  loetzsch
continued creation of the option tree

Revision 1.4  2003/01/09 17:27:00  loetzsch
added intermediate code for agents

Revision 1.3  2003/01/08 18:46:26  loetzsch
continued

Revision 1.2  2003/01/08 15:10:09  loetzsch
started intermediate code generation

Revision 1.1  2002/12/06 17:52:08  loetzsch
copied from an old version of generate-debug-symbols.xsl

-->
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xabsl="http://www.ki.informatik.hu-berlin.de/XABSL2.2">
	<xsl:output method="text"/>
	<xsl:variable name="space">
		<xsl:text> </xsl:text>
	</xsl:variable>
	<xsl:variable name="line-break">
		<xsl:text>
</xsl:text>
	</xsl:variable>
	<xsl:template match="xabsl:agent-collection">
		<xsl:text>// Intermediate code for the agents of </xsl:text>
		<xsl:value-of select="xabsl:title"/>
		<xsl:value-of select="$line-break"/>
		<xsl:value-of select="$line-break"/>
		<xsl:text>// number of options</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:value-of select="count(xabsl:option-definitions/xabsl:option-definition)"/>
		<xsl:value-of select="$line-break"/>
		<xsl:text>// names, number of parameters, parameters for all options</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:value-of select="$line-break"/>
		<xsl:for-each select="xabsl:options/xabsl:option">
			<xsl:variable name="name" select="@name"/>
			<xsl:for-each select="xabsl:option-definitions/xabsl:option-definition[@name=$name]">
				<xsl:value-of select="@name"/>
				<xsl:value-of select="$space"/>
				<xsl:value-of select="count(xabsl:parameter)"/>
				<xsl:value-of select="$space"/>
				<xsl:for-each select="xabsl:parameter">
					<xsl:value-of select="@name"/>
					<xsl:value-of select="$space"/>
				</xsl:for-each>
			</xsl:for-each>
		</xsl:for-each>
		<xsl:value-of select="$line-break"/>
		<xsl:apply-templates select="xabsl:options/xabsl:option"/>
		<xsl:value-of select="$line-break"/>
		<xsl:text>// number of agents:</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:value-of select="count(xabsl:agent)"/>
		<xsl:value-of select="$line-break"/>
		<xsl:text>// agents: (name initial-option)+</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:for-each select="xabsl:agent">
			<xsl:value-of select="@id"/>
			<xsl:value-of select="$space"/>
			<xsl:value-of select="@root-option"/>
			<xsl:value-of select="$space"/>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="xabsl:option">
		<xsl:value-of select="$line-break"/>
		<xsl:text>// option </xsl:text>
		<xsl:value-of select="@name"/>
		<xsl:value-of select="$line-break"/>
		<xsl:text>// number of states</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:value-of select="count(xabsl:state)"/>
		<xsl:value-of select="$line-break"/>
		<xsl:text>// The states</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:for-each select="xabsl:state">
			<xsl:value-of select="@name"/>
			<xsl:value-of select="$space"/>
		</xsl:for-each>
		<xsl:value-of select="$line-break"/>
		<xsl:text>// initial-state</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:value-of select="@initial-state"/>
		<xsl:value-of select="$line-break"/>
		<xsl:apply-templates select="xabsl:state"/>
		<xsl:value-of select="$line-break"/>
		<xsl:value-of select="$line-break"/>
	</xsl:template>
	<xsl:template match="xabsl:state">
		<xsl:text>// state </xsl:text>
		<xsl:value-of select="@name"/>
		<xsl:value-of select="$line-break"/>
		<xsl:choose>
			<xsl:when test="@is-target-state">// is target state (1)<xsl:value-of select="$line-break"/>
				<xsl:text>1</xsl:text>
				<xsl:value-of select="$line-break"/>
			</xsl:when>
			<xsl:otherwise>// not a target state (0)<xsl:value-of select="$line-break"/>
				<xsl:text>0</xsl:text>
				<xsl:value-of select="$line-break"/>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="xabsl:subsequent-option | xabsl:subsequent-basic-behavior"/>
		<xsl:text>// number of set output symbols</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:value-of select="count(xabsl:set-output-symbol)"/>
		<xsl:value-of select="$line-break"/>
		<xsl:apply-templates select="xabsl:set-output-symbol"/>
		<xsl:if test="../xabsl:common-decision-tree">
			<xsl:text>// common decision tree:</xsl:text>
			<xsl:value-of select="$line-break"/>
			<xsl:apply-templates select="../xabsl:common-decision-tree"/>
			<xsl:text>// (else)</xsl:text>
			<xsl:value-of select="$line-break"/>
		</xsl:if>
		<xsl:apply-templates select="xabsl:decision-tree"/>
	</xsl:template>
	<xsl:template match="xabsl:subsequent-option">
		<xsl:text>// subsequent option (o)</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:text>o </xsl:text>
		<xsl:value-of select="@ref"/>
		<xsl:value-of select="$line-break"/>
		<xsl:text>// number of set parameters</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:value-of select="count(xabsl:set-parameter)"/>
		<xsl:value-of select="$line-break"/>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="xabsl:subsequent-basic-behavior">
		<xsl:text>// subsequent basic behavior (b)</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:text>b </xsl:text>
		<xsl:value-of select="@ref"/>
		<xsl:value-of select="$line-break"/>
		<xsl:text>// number of set parameters</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:value-of select="count(xabsl:set-parameter)"/>
		<xsl:value-of select="$line-break"/>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="xabsl:set-parameter">
		<xsl:text>// set-parameter</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:value-of select="@ref"/>
		<xsl:value-of select="$line-break"/>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="xabsl:set-output-symbol">
		<xsl:text>// set output symbol</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:value-of select="@ref"/>
		<xsl:value-of select="$space"/>
		<xsl:value-of select="@value"/>
		<xsl:value-of select="$line-break"/>
	</xsl:template>
	<xsl:template match="xabsl:common-decision-tree">
		<xsl:call-template name="xabsl:statement"/>
	</xsl:template>
	<xsl:template match="xabsl:decision-tree">
		<xsl:text>// state decision tree:</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:call-template name="xabsl:statement"/>
	</xsl:template>
	<xsl:template name="xabsl:statement">
		<xsl:if test="xabsl:if">
			<xsl:text>// if/else-if/else block (i) </xsl:text>
			<xsl:value-of select="$line-break"/>
			<xsl:text>i </xsl:text>
			<xsl:value-of select="$line-break"/>
			<xsl:apply-templates select="xabsl:if"/>
			<xsl:text>// number of else-if statements</xsl:text>
			<xsl:value-of select="$line-break"/>
			<xsl:value-of select="count(xabsl:else-if)"/>
			<xsl:value-of select="$line-break"/>
			<xsl:apply-templates select="xabsl:else-if"/>
			<xsl:apply-templates select="xabsl:else"/>
		</xsl:if>
		<xsl:apply-templates select="xabsl:transition-to-state"/>
	</xsl:template>
	<xsl:template match="xabsl:transition-to-state">
		<xsl:text>// transition to state (t) </xsl:text>
		<xsl:value-of select="@ref"/>
		<xsl:value-of select="$line-break"/>
		<xsl:text>t </xsl:text>
		<xsl:value-of select="@ref"/>
		<xsl:value-of select="$line-break"/>
	</xsl:template>
	<xsl:template match="xabsl:if | xabsl:else-if">
		<xsl:text>// </xsl:text>
		<xsl:value-of select="local-name()"/>
		<xsl:text> statement</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:apply-templates select="xabsl:condition"/>
		<xsl:call-template name="xabsl:statement"/>
	</xsl:template>
	<xsl:template match="xabsl:else">
		<xsl:text>// else statement</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:call-template name="xabsl:statement"/>
	</xsl:template>
	<xsl:template match="xabsl:condition">
		<xsl:text>// condition</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="xabsl:boolean-input-symbol-ref">
		<xsl:text>// boolean-input-symbol-ref</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:text>r </xsl:text>
		<xsl:value-of select="@ref"/>
		<xsl:value-of select="$line-break"/>
	</xsl:template>
	<xsl:template match="xabsl:subsequent-option-reached-target-state">
		<xsl:text>// subsequent-option-reached-target-state</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:text>t </xsl:text>
		<xsl:value-of select="$line-break"/>
	</xsl:template>
	<xsl:template match="xabsl:enumerated-input-symbol-comparison">
		<xsl:text>// enumerated-input-symbol-comparison</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:text>c </xsl:text>
		<xsl:value-of select="@ref"/>
		<xsl:value-of select="$space"/>
		<xsl:value-of select="@value"/>
		<xsl:value-of select="$line-break"/>
	</xsl:template>
	<xsl:template match="xabsl:and">
		<xsl:text>// and (</xsl:text>
		<xsl:value-of select="count(xabsl:*)"/>
		<xsl:text>)</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:text>&amp;</xsl:text>
		<xsl:value-of select="$space"/>
		<xsl:value-of select="count(xabsl:*)"/>
		<xsl:value-of select="$line-break"/>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="xabsl:or">
		<xsl:text>// or (</xsl:text>
		<xsl:value-of select="count(xabsl:*)"/>
		<xsl:text>)</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:text>| </xsl:text>
		<xsl:value-of select="$space"/>
		<xsl:value-of select="count(xabsl:*)"/>
		<xsl:value-of select="$line-break"/>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="xabsl:not">
		<xsl:text>// not</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:text>! </xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="xabsl:equal-to">
		<xsl:text>// ==</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:text>= </xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="xabsl:not-equal-to">
		<xsl:text>// !=</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:text>n </xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="xabsl:less-than">
		<xsl:text>// &lt;</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:text>&lt; </xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="xabsl:less-than-or-equal-to">
		<xsl:text>// &lt;=</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:text>l </xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="xabsl:greater-than">
		<xsl:text>// ></xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:text>> </xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="xabsl:greater-than-or-equal-to">
		<xsl:text>// >=</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:text>g </xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="xabsl:decimal-input-symbol-ref">
		<xsl:text>// decimal-input-symbol-ref</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:text>r </xsl:text>
		<xsl:value-of select="@ref"/>
		<xsl:value-of select="$line-break"/>
	</xsl:template>
	<xsl:template match="xabsl:decimal-input-function-call">
		<xsl:text>// decimal-input-function-call</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:text>f </xsl:text>
		<xsl:value-of select="@ref"/>
		<xsl:value-of select="$line-break"/>
		<xsl:text>// number of with-parameter elements</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:value-of select="count(xabsl:with-parameter)"/>
		<xsl:value-of select="$line-break"/>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="xabsl:with-parameter">
		<xsl:text>// with parameter </xsl:text>
		<xsl:value-of select="@ref"/>
		<xsl:value-of select="$line-break"/>
		<xsl:value-of select="@ref"/>
		<xsl:value-of select="$line-break"/>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="xabsl:constant-ref">
		<xsl:text>// constant-ref</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:text>c </xsl:text>
		<xsl:variable name="ref" select="@ref"/>
		<xsl:value-of select="ancestor::xabsl:option/xabsl:symbols/xabsl:constant[@name=$ref]/@value"/>
		<xsl:value-of select="$line-break"/>
	</xsl:template>
	<xsl:template match="xabsl:decimal-value">
		<xsl:text>// decimal-value</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:text>v </xsl:text>
		<xsl:value-of select="@value"/>
		<xsl:value-of select="$line-break"/>
	</xsl:template>
	<xsl:template match="xabsl:option-parameter-ref">
		<xsl:text>// option-parameter-ref</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:text>p </xsl:text>
		<xsl:value-of select="@ref"/>
		<xsl:value-of select="$line-break"/>
	</xsl:template>
	<xsl:template match="xabsl:plus">
		<xsl:text>// plus</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:text>+ </xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="xabsl:minus">
		<xsl:text>// minus</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:text>- </xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="xabsl:multiply">
		<xsl:text>// multiply</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:text>* </xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="xabsl:divide">
		<xsl:text>// divide</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:text>d </xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="xabsl:mod">
		<xsl:text>// mod</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:text>% </xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="xabsl:time-of-state-execution">
		<xsl:text>// time-of-state-execution</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:text>s </xsl:text>
		<xsl:value-of select="$line-break"/>
	</xsl:template>
	<xsl:template match="xabsl:time-of-option-execution">
		<xsl:text>// time-of-option-execution</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:text>o </xsl:text>
		<xsl:value-of select="$line-break"/>
	</xsl:template>
	<xsl:template match="xabsl:conditional-expression">
		<xsl:text>// conditional expression (question mark operator) </xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:text>q </xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:text>// conditional expression: condition</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:for-each select="xabsl:condition">
			<xsl:apply-templates/>
		</xsl:for-each>
		<xsl:text>// conditional expression: expression1</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:for-each select="xabsl:expression1">
			<xsl:apply-templates/>
		</xsl:for-each>
		<xsl:text>// conditional expression: expression2</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:for-each select="xabsl:expression2">
			<xsl:apply-templates/>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="*"/>
	<xsl:template match="text()"/>
</xsl:stylesheet>
