<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
Change Log:
$Log: generate-documentation.option-tree.xsl,v $
Revision 1.1  2004/06/15 12:41:22  loetzsch
changed XABSL version from 2.1 to 2.2 on the occasion of a new XABSL release

Revision 1.1.1.1  2004/05/22 17:37:43  cvsadm
created new repository GT2004_WM

Revision 1.1  2003/10/07 10:13:25  cvsadm
Created GT2004 (M.J.)

Revision 1.5  2003/09/20 16:34:16  loetzsch
renamed "following-option-..." to "subsequent-option-.." and
"following-basic-behavior-.." to "subsequent-basic-behavior-.."
for consistency with publications

Revision 1.4  2003/07/23 18:16:39  loetzsch
made faster, agents.html is a part of the documentation target again

Revision 1.3  2003/07/21 20:54:37  loetzsch
corrected non XML conform change log

Revision 1.2  2003/07/21 20:53:23  loetzsch
the option graph below an option chart is now clipped to the depth of four
-> much faster

Revision 1.1.1.1  2003/07/02 09:40:29  cvsadm
created new repository for the competitions in Padova from the 
tamara CVS (Tuesday 2:00 pm)

removed unused solutions

Revision 1.1  2003/06/25 01:19:51  loetzsch
created xabsl 2.1
Differences to xabsl2.0: No predefined conditions, documentation uses new dot

Revision 1.8  2003/05/18 22:38:44  loetzsch
fixed a bug in the option graph charts

Revision 1.7  2003/04/21 20:53:34  loetzsch
made validation and code generation faster
- the element xabsl:agent doesn't contain any options anymore
- options are now included to agents.xml instead into several agents
- removed unused options

Revision 1.6  2003/01/18 18:45:30  loetzsch
- the menu for the documentation is not loaded from an xml file any mor
  but created created different for each documentation type.
- instead of one big "index.html", which contains a complete table of contents,
  a few seperate index pages are created
- The option trees are painted by using a precompiled xml file "option-tree.xml"
  to improve compile speed.

Revision 1.5  2003/01/15 14:47:35  loetzsch
some speed enhancements

Revision 1.4  2002/12/11 12:21:35  loetzsch
option trees look better now

Revision 1.3  2002/12/03 18:17:14  loetzsch
- predefined conditions
- stylesheets are now independend from output directory
- minor changes

Revision 1.2  2002/12/02 19:13:59  loetzsch
nodes in the option tree now have a filled style so that is easier to hit the URL link

Revision 1.1  2002/11/30 13:43:53  loetzsch
option tree visualization for options and agents finished

-->
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xabsl="http://www.ki.informatik.hu-berlin.de/XABSL2.2" xmlns:dotml="http://www.martin-loetzsch.de/DOTML">
	<xsl:import href="generate-documentation.string-functions.xsl"/>
	<xsl:output method="xml" indent="yes"/>
	<xsl:key name="options" match="xabsl:agent-collection/xabsl:options/xabsl:option" use="@name"/>
	<xsl:key name="basic-behaviors" match="xabsl:agent-collection/xabsl:options/xabsl:option/xabsl:basic-behaviors/xabsl:basic-behavior" use="@name"/>
	<xsl:template match="xabsl:agent-collection">
		<xabsl:option-trees>
			<xsl:for-each select="xabsl:options/xabsl:option">
				<xabsl:option-tree root-option="{@name}">
					<xsl:call-template name="create-option-tree"/>
				</xabsl:option-tree>
			</xsl:for-each>
		</xabsl:option-trees>
	</xsl:template>
	<xsl:template name="create-option-tree">
		<xabsl:o-n name="{@name}">
			<xsl:for-each select="xabsl:state/xabsl:subsequent-option">
				<xsl:variable name="ref" select="@ref"/>
				<xsl:if test="not(../preceding-sibling::xabsl:state/xabsl:subsequent-option[@ref=$ref])">
					<xabsl:e2o to="{@ref}"/>
				</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="xabsl:state/xabsl:subsequent-basic-behavior">
				<xsl:variable name="ref" select="@ref"/>
				<xsl:if test="not(../preceding-sibling::xabsl:state/xabsl:subsequent-basic-behavior[@ref=$ref])">
					<xabsl:e2b to="{@ref}"/>
				</xsl:if>
			</xsl:for-each>
		</xabsl:o-n>
		<xsl:for-each select="xabsl:state/xabsl:subsequent-option">
			<xsl:variable name="ref" select="@ref"/>
			<xsl:if test="not(../preceding-sibling::xabsl:state/xabsl:subsequent-option[@ref=$ref])">
				<xsl:for-each select="key('options',@ref)[1]">
					<xsl:call-template name="create-option-tree"/>
				</xsl:for-each>
			</xsl:if>
		</xsl:for-each>
		<xsl:for-each select="xabsl:state/xabsl:subsequent-basic-behavior">
			<xsl:variable name="ref" select="@ref"/>
			<xsl:if test="not(../preceding-sibling::xabsl:state/xabsl:subsequent-basic-behavior[@ref=$ref])">
				<xabsl:b-n name="{@ref}" g="{key('basic-behaviors',@ref)[1]/../@id}"/>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="paint-option-tree">
		<xsl:param name="root-option"/>
		<xsl:param name="dont-paint-option"/>
		<xsl:param name="option-tree-xml"/>
		<xsl:for-each select="document($option-tree-xml)/xabsl:option-trees/xabsl:option-tree[@root-option=$root-option]">
			<xsl:for-each select="xabsl:o-n[@name!=$dont-paint-option]">
				<xsl:variable name="name" select="@name"/>
				<xsl:if test="count(preceding-sibling::xabsl:o-n[@name=$name])=0">
					<dotml:node fontname="Arial" fontcolor="#005A9C" fontsize="9" shape="box" URL="option.{@name}.html" fillcolor="#FFFFFF" style="{@style}">
						<xsl:attribute name="id">option_<xsl:call-template name="replace-in-string"><xsl:with-param name="original-string" select="@name"/><xsl:with-param name="replace">-</xsl:with-param><xsl:with-param name="with">_</xsl:with-param></xsl:call-template></xsl:attribute>
						<xsl:attribute name="label"><xsl:call-template name="replace-in-string"><xsl:with-param name="original-string" select="@name"/><xsl:with-param name="replace">-</xsl:with-param><xsl:with-param name="with">\n</xsl:with-param></xsl:call-template></xsl:attribute>
					</dotml:node>
				</xsl:if>
			</xsl:for-each>
			<dotml:sub-graph rank="sink">
				<xsl:for-each select="xabsl:b-n">
					<xsl:variable name="name" select="@name"/>
					<xsl:if test="count(preceding-sibling::xabsl:b-n[@name=$name])=0">
						<dotml:node fontname="Arial" fontcolor="#005A9C" fontsize="9" URL="basic-behaviors.{@g}.html#{@name}" style="filled" fillcolor="#FFFFFF">
							<xsl:attribute name="id">basic_behavior_<xsl:call-template name="replace-in-string"><xsl:with-param name="original-string" select="@name"/><xsl:with-param name="replace">-</xsl:with-param><xsl:with-param name="with">_</xsl:with-param></xsl:call-template></xsl:attribute>
							<xsl:attribute name="label"><xsl:call-template name="replace-in-string"><xsl:with-param name="original-string" select="@name"/><xsl:with-param name="replace">-</xsl:with-param><xsl:with-param name="with">\n</xsl:with-param></xsl:call-template></xsl:attribute>
						</dotml:node>
					</xsl:if>
				</xsl:for-each>
			</dotml:sub-graph>
			<xsl:for-each select="xabsl:o-n[@name!=$dont-paint-option]">
				<xsl:variable name="name" select="@name"/>
				<xsl:if test="count(preceding-sibling::xabsl:o-n[@name=$name])=0">
					<xsl:for-each select="xabsl:e2o">
						<dotml:edge arrowsize="0.8" color="#808080">
							<xsl:attribute name="from">option_<xsl:call-template name="replace-in-string"><xsl:with-param name="original-string" select="../@name"/><xsl:with-param name="replace">-</xsl:with-param><xsl:with-param name="with">_</xsl:with-param></xsl:call-template></xsl:attribute>
							<xsl:attribute name="to">option_<xsl:call-template name="replace-in-string"><xsl:with-param name="original-string" select="@to"/><xsl:with-param name="replace">-</xsl:with-param><xsl:with-param name="with">_</xsl:with-param></xsl:call-template></xsl:attribute>
						</dotml:edge>
					</xsl:for-each>
					<xsl:for-each select="xabsl:e2b">
						<dotml:edge arrowsize="0.8" color="#808080" minlen="3">
							<xsl:attribute name="from">option_<xsl:call-template name="replace-in-string"><xsl:with-param name="original-string" select="../@name"/><xsl:with-param name="replace">-</xsl:with-param><xsl:with-param name="with">_</xsl:with-param></xsl:call-template></xsl:attribute>
							<xsl:attribute name="to">basic_behavior_<xsl:call-template name="replace-in-string"><xsl:with-param name="original-string" select="@to"/><xsl:with-param name="replace">-</xsl:with-param><xsl:with-param name="with">_</xsl:with-param></xsl:call-template></xsl:attribute>
						</dotml:edge>
					</xsl:for-each>
				</xsl:if>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
