<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
Change Log:
$Log: generate-documentation.index.xsl,v $
Revision 1.1  2004/06/15 12:41:22  loetzsch
changed XABSL version from 2.1 to 2.2 on the occasion of a new XABSL release

Revision 1.1.1.1  2004/05/22 17:37:41  cvsadm
created new repository GT2004_WM

Revision 1.1  2003/10/07 10:13:25  cvsadm
Created GT2004 (M.J.)

Revision 1.1.1.1  2003/07/02 09:40:29  cvsadm
created new repository for the competitions in Padova from the 
tamara CVS (Tuesday 2:00 pm)

removed unused solutions

Revision 1.1  2003/06/25 01:19:51  loetzsch
created xabsl 2.1
Differences to xabsl2.0: No predefined conditions, documentation uses new dot

Revision 1.7  2003/01/18 18:43:39  loetzsch
- the menu for the documentation is not loaded from an xml file any mor
  but created created different for each documentation type.
- instead of one big "index.html", which contains a complete table of contents,
  a few seperate index pages are created

Revision 1.6  2002/12/04 19:06:46  loetzsch
some minor beautifications

Revision 1.5  2002/12/04 10:38:15  juengel
XABSL2 logo added, changed table cell structure.

Revision 1.4  2002/12/03 18:17:14  loetzsch
- predefined conditions
- stylesheets are now independend from output directory
- minor changes

Revision 1.3  2002/11/30 19:16:15  juengel
Moved BehaviorControl solution Xabsl2Berlin to Humboldt2003.

Revision 1.2  2002/11/27 15:33:52  loetzsch
- first version of option and option-definitions
- started debug symbol generation
- added VALIDATION target to Makefile

Revision 1.1  2002/11/26 15:02:34  loetzsch
- xabsl2 schema definition continued
  symbols basic-behaviors agents
- xabsl2 documentation startet
- Modularization of Xabsl instance files with XInclude and external entities
- Makefile introduced

-->
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xabsl="http://www.ki.informatik.hu-berlin.de/XABSL2.2">
	<xsl:import href="generate-documentation.menu.xsl"/>
	<xsl:output method="html" indent="yes"/>
	<xsl:template match="xabsl:agent-collection">
		<html>
			<head>
				<title>XABSL2 Behavior Documentation: <xsl:value-of select="xabsl:title"/>
				</title>
				<link rel="stylesheet" type="text/css" href="styles.css">
					<xsl:text> </xsl:text>
				</link>
			</head>
			<body>
				<table border="0" cellpadding="0" cellspacing="0">
					<tr>
						<td class="menu-cell">
							<table border="0" cellspacing="0" cellpadding="1">
								<xsl:call-template name="menu-xabsl2-logo"/>
								<xsl:call-template name="menu-entry-index"/>
								<xsl:call-template name="menu-entry-agents-linked"/>
								<xsl:call-template name="menu-entry-symbols-linked"/>
								<xsl:call-template name="menu-entry-basic-behaviors-linked"/>
								<xsl:call-template name="menu-entry-options-linked"/>
							</table>
						</td>
						<td class="main-area">
							<h1>
								<xsl:value-of select="xabsl:title"/>: Behavior Documentation</h1>
							<p>
								<div class="bold">Platform:</div>
								<xsl:value-of select="xabsl:platform"/>
							</p>
							<p>
								<div class="bold">Software Environment:</div>
								<xsl:value-of select="xabsl:software-environment"/>
							</p>
							<h2>Table Of Contents</h2>
							<table border="0" cellpadding="4" cellspacing="6">
								<tr>
									<td>
										<a href="agents.html" title="Available agents">Agents</a>
									</td>
									<td>All agents of <xsl:value-of select="xabsl:title"/>
									</td>
								</tr>
								<tr>
									<td>
										<a href="symbols.html" title="Available symbols">Symbols</a>
									</td>
									<td>The symbols needed to run the behavior in the software environment</td>
								</tr>
								<tr>
									<td>
										<a href="basic-behaviors.html" title="Available basic behaviors">Basic Behaviors</a>
									</td>
									<td>C++ written behaviors at the leaves of the option tree.</td>
								</tr>
								<tr>
									<td>
										<a href="options.html" title="Available options">Options</a>
									</td>
									<td>All options of all agents.</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
