<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
Change Log:
$Log: generate-documentation.basic-behaviors.xsl,v $
Revision 1.1  2004/06/15 12:41:22  loetzsch
changed XABSL version from 2.1 to 2.2 on the occasion of a new XABSL release

Revision 1.1.1.1  2004/05/22 17:37:41  cvsadm
created new repository GT2004_WM

Revision 1.1  2003/10/07 10:13:25  cvsadm
Created GT2004 (M.J.)

Revision 1.1.1.1  2003/07/02 09:40:29  cvsadm
created new repository for the competitions in Padova from the 
tamara CVS (Tuesday 2:00 pm)

removed unused solutions

Revision 1.1  2003/06/25 01:19:51  loetzsch
created xabsl 2.1
Differences to xabsl2.0: No predefined conditions, documentation uses new dot

Revision 1.8  2003/01/18 18:43:39  loetzsch
- the menu for the documentation is not loaded from an xml file any mor
  but created created different for each documentation type.
- instead of one big "index.html", which contains a complete table of contents,
  a few seperate index pages are created

Revision 1.7  2002/12/06 13:14:40  loetzsch
- complete decision trees
- allmost all id constraints
- decision tree pseudo code in documentation

Revision 1.6  2002/12/04 19:06:46  loetzsch
some minor beautifications

Revision 1.5  2002/12/04 10:38:15  juengel
XABSL2 logo added, changed table cell structure.

Revision 1.4  2002/12/03 18:17:14  loetzsch
- predefined conditions
- stylesheets are now independend from output directory
- minor changes

Revision 1.3  2002/11/30 19:16:15  juengel
Moved BehaviorControl solution Xabsl2Berlin to Humboldt2003.

Revision 1.2  2002/11/29 13:35:11  loetzsch
- option specification continued

Revision 1.1  2002/11/26 15:02:34  loetzsch
- xabsl2 schema definition continued
  symbols basic-behaviors agents
- xabsl2 documentation startet
- Modularization of Xabsl instance files with XInclude and external entities
- Makefile introduced

-->
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xabsl="http://www.ki.informatik.hu-berlin.de/XABSL2.2">
	<xsl:import href="generate-documentation.parameters.xsl"/>
	<xsl:import href="generate-documentation.menu.xsl"/>
	<xsl:output method="html" indent="yes"/>
	<xsl:template match="xabsl:basic-behaviors">
		<html>
			<head>
				<title>XABSL2 Behavior Documentation: <xsl:value-of select="@title"/>
				</title>
				<link rel="stylesheet" type="text/css" href="styles.css">
					<xsl:text> </xsl:text>
				</link>
			</head>
			<body>
				<table border="0" cellpadding="0" cellspacing="0">
					<tr>
						<td class="menu-cell">
							<table border="0" cellspacing="0" cellpadding="1">
								<xsl:call-template name="menu-xabsl2-logo"/>
								<xsl:call-template name="menu-entry-index-linked"/>
								<xsl:call-template name="menu-entry-agents-linked"/>
								<xsl:call-template name="menu-entry-symbols-linked"/>
								<xsl:call-template name="menu-entry-basic-behaviors-linked"/>
								<xsl:call-template name="menu-basic-behavior"/>
								<xsl:call-template name="menu-entry-options-linked"/>
							</table>
						</td>
						<td class="main-area">
							<h1>
								<xsl:value-of select="@title"/>
							</h1>
							<p>
								<xsl:value-of select="@description"/>
							</p>
							<xsl:for-each select="xabsl:basic-behavior">
								<h2 id="{@name}">Basic Behavior &quot;<xsl:value-of select="@name"/>&quot;</h2>
								<p>
									<xsl:value-of select="@description"/>
								</p>
								<xsl:call-template name="parameters"/>
							</xsl:for-each>
						</td>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
