<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
Change Log:
$Log: generate-documentation.basic-behavior-index.xsl,v $
Revision 1.1  2004/06/15 12:41:22  loetzsch
changed XABSL version from 2.1 to 2.2 on the occasion of a new XABSL release

Revision 1.1.1.1  2004/05/22 17:37:41  cvsadm
created new repository GT2004_WM

Revision 1.1  2003/10/07 10:13:25  cvsadm
Created GT2004 (M.J.)

Revision 1.1.1.1  2003/07/02 09:40:29  cvsadm
created new repository for the competitions in Padova from the 
tamara CVS (Tuesday 2:00 pm)

removed unused solutions

Revision 1.1  2003/06/25 01:19:51  loetzsch
created xabsl 2.1
Differences to xabsl2.0: No predefined conditions, documentation uses new dot

Revision 1.3  2003/05/03 01:00:36  loetzsch
some beautifications

Revision 1.2  2003/04/21 20:53:34  loetzsch
made validation and code generation faster
- the element xabsl:agent doesn't contain any options anymore
- options are now included to agents.xml instead into several agents
- removed unused options

Revision 1.1  2003/01/18 18:43:39  loetzsch
- the menu for the documentation is not loaded from an xml file any mor
  but created created different for each documentation type.
- instead of one big "index.html", which contains a complete table of contents,
  a few seperate index pages are created

-->
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xabsl="http://www.ki.informatik.hu-berlin.de/XABSL2.2" xmlns:dotml="http://www.martin-loetzsch.de/DOTML">
	<xsl:import href="generate-documentation.menu.xsl"/>
	<xsl:output method="html" indent="yes"/>
	<xsl:key name="basic-behaviors" match="xabsl:agent-collection/xabsl:options/xabsl:option/xabsl:basic-behaviors" use="@id"/>
	<xsl:template match="xabsl:agent-collection">
		<html>
			<head>
				<title>XABSL2 Behavior Documentation: Basic Behaviors</title>
				<link rel="stylesheet" type="text/css" href="styles.css">
					<xsl:text> </xsl:text>
				</link>
			</head>
			<body>
				<table border="0" cellpadding="0" cellspacing="0">
					<tr>
						<td class="menu-cell">
							<table border="0" cellspacing="0" cellpadding="1">
								<xsl:call-template name="menu-xabsl2-logo"/>
								<xsl:call-template name="menu-entry-index-linked"/>
								<xsl:call-template name="menu-entry-agents-linked"/>
								<xsl:call-template name="menu-entry-symbols-linked"/>
								<xsl:call-template name="menu-entry-basic-behaviors"/>
								<xsl:call-template name="menu-basic-behaviors"/>
								<xsl:call-template name="menu-entry-options-linked"/>
							</table>
						</td>
						<td class="main-area">
							<h1>Basic Behaviors</h1>
							<table border="0" cellpadding="4" cellspacing="0">
								<xsl:for-each select="xabsl:options/xabsl:option/xabsl:basic-behaviors[count(key('basic-behaviors',@id)[1] | .)=1]">
									<tr>
										<td colspan="2">
											<p>&#160;</p>
											<a href="basic-behaviors.{@id}.html" title="{@description}">
												<h3>
													<xsl:value-of select="@title"/>
												</h3>
											</a>
											<p>
												<xsl:value-of select="@description"/>
											</p>
											<p/>
										</td>
									</tr>
									<xsl:for-each select="xabsl:basic-behavior">
										<tr>
											<td>
												<a href="basic-behaviors.{../@id}.html#{@name}" title="{@description}">
													<xsl:value-of select="@name"/>
												</a>
											</td>
											<td>
												<xsl:value-of select="@description"/>
											</td>
										</tr>
									</xsl:for-each>
								</xsl:for-each>
							</table>
						</td>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
