/** 
* @file Xabsl2Agent.cpp
* 
* Implementation of class Xabsl2Agent
* 
* @author Martin Ltzsch
*/

#include "Xabsl2Agent.h"

Xabsl2Agent::Xabsl2Agent(const char* name, Xabsl2Option* rootOption,
                         Xabsl2ErrorHandler& errorHandler)
: Xabsl2NamedItem(name), rootOption(rootOption), errorHandler(errorHandler)
{
  XABSL2_DEBUG_INIT(errorHandler.message("created agent \"%s\" with root option \"%s\"", n, rootOption->n));
}

Xabsl2Option* Xabsl2Agent::getRootOption() const
{
  return rootOption;
}

/*
* Change Log:
*
* $Log: Xabsl2Agent.cpp,v $
* Revision 1.1.1.1  2004/05/22 17:37:52  cvsadm
* created new repository GT2004_WM
*
* Revision 1.1  2003/10/07 10:13:25  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:29  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.2  2003/01/11 14:41:42  loetzsch
* continued creation of the option tree
*
* Revision 1.1  2003/01/09 17:28:33  loetzsch
* introduced Xabsl2Agent, continued Xabsl2Option
*
*/
