/**
 * @file SlidingAverageValue.h
 *
 * Declaration of class SlidingAverageValue
 *
 * @author Jochen Kerdels
 */

#ifndef __SlidingAverageValue_h_
#define __SlidingAverageValue_h_

static const int maxSlidingRange = 25;

/**
 * @class SlidingAverageValue
 *
 * class for cyclic buffering of the last "size" values of Type int
 * output via = operator is the average of the last "size" values
 * input a new value also via = operator
 * ATTENTION: the "current-index" is driven by the trigger, so
 * the given average is an average over the last "size" trigger-events !
 */
class SlidingAverageValue
{
  public:
    /** Constructor */
    SlidingAverageValue();

    /**
     * resets the SlidingAverageValue 
     * \param aSize size of the sliding range
     */
    void reset(int aSize);
    
    /**
     * triggers to the next index
     */
    void trigger ();

    /**
     * adds an entry to the buffer
     * \param value value to be added
     */
    void add (int value);

    int getAverage();

    int getLastValue();

    SlidingAverageValue& operator=(int aInt);

    SlidingAverageValue& operator-=(int aInt);

    SlidingAverageValue& operator+=(int aInt);

    operator int() { return getAverage(); };

  private:
    int minIdx;
    int maxIdx;
    int numOfEntries;
    int size;
    int buffer[maxSlidingRange];
    int timeOfLastAdd;
    int sum;
    int trig;
};


#endif // __SlidingAverageValue_h_

/*
 * Change log :
 * 
 * $Log: SlidingAverageValue.h,v $
 * Revision 1.1.1.1  2004/05/22 17:35:55  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2004/04/08 16:04:06  wachter
 * GT04 checkin of Microsoft-Hellounds
 *
 * Revision 1.1  2004/03/21 04:36:07  pg_joke
 * added slidingAverage to OptionRatings,
 * added ratingBoost (Hysteresis) to OptionRatings
 *
 *
 */
