/**
* @file Process.cpp
*
* Implementation of class Process.
*/

#define USE_GETMESSAGEIDNAME
#include "Tools/Process.h"
#include "Tools/Player.h"
#include "Tools/RobotConfiguration.h"
#include "Tools/Debugging/Debugging.h"

Process::Process(MessageQueue& debugIn, MessageQueue& debugOut) 
: debugIn(debugIn), debugOut(debugOut)
{
  // read the player.cfg
  getPlayer().load();
  getRobotConfiguration().load();
  
  // cannot initialize debugIn/debugOut here, because they have not yet been constructed
  // But there addresses can already be stored
  initDebugging(&debugOut.out,&debugKeyTable);
  initialized = false;
}

int Process::processMain()
{
  if(!initialized)
  {
    debugIn.setPlayerForNewMessages(getPlayer()); // This is not needed except in the Win32 version of OVirtualRobotComm
    init();
    initialized = true;
  }
  // team color can change, so set it always
  debugOut.setPlayerForNewMessages(getPlayer());
  
#ifndef NDEBUG
  debugIn.handleAllMessages(*this);
  debugIn.clear();
  debugKeyTable.activate();
#endif

  return this->main();
}

bool Process::handleMessage(InMessage& message)
{
  switch (message.getMessageID())
  {
  case idDebugKeyTable:
    message.bin >> debugKeyTable; 
    return true;
  case idSolutionRequest: 
    {
      SolutionRequest request;
      message.bin >> request;
      moduleHandler.selectSolutions(request);
    }
    return true;
  default:
    if (moduleHandler.handleMessage(message))
    {
//      OUTPUT(idText,text,"Process::handleDebugMessage : Handled "<< getMessageIDName(message.getMessageID()));
      return true;
    }
    else
    {
      OUTPUT(idText,text,"Process::handleDebugMessage : Unhandled debug message ("<< getMessageIDName(message.getMessageID()) << ")");
      return false;
    }
  }
}

/*
* Change log :
* 
* $Log: Process.cpp,v $
* Revision 1.1.1.1  2004/05/22 17:35:54  cvsadm
* created new repository GT2004_WM
*
* Revision 1.3  2004/04/11 18:49:46  roefer
* Team color is sent again from Cognition to Motion.
* Otherwise, messages sent by Motion may contain the wrong team color.
*
* Revision 1.2  2003/12/06 23:23:55  loetzsch
* messages in a MessageQueue now contain
* - the team color of the robot which sent the message
* - the player number of the robot which sent the message
* - if the message was sent from a physical robot or not
*
* Revision 1.1  2003/10/07 10:13:21  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:28  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.10  2003/05/03 16:20:01  roefer
* robot.cfg added
*
* Revision 1.9  2003/03/06 18:19:34  dueffert
* reduced amount of warnings drastically by ifdefing global functions
*
* Revision 1.8  2003/01/17 12:48:19  jhoffman
* added GenericDebugData
* changes to the TestDataGenerator towards using sliders, min/max, and other cool stuff
*
* Revision 1.7  2003/01/16 09:54:49  jhoffman
* Added "Generic Debug Data" data type. This can be used
* for quick and dirty optimization and debugging, e.g. to send
* parameters to a module through WLAN to adjust it's settings.
* The DebugMessageGenerator is used to for parsing and
* sendig the data
*
* Revision 1.6  2002/10/01 11:14:34  loetzsch
* Redesigned DebugKey and DebugKeyTable
*
* Revision 1.5  2002/09/29 18:02:51  loetzsch
* removed the INIT_DEBUG_KEY_TABLE macro from debugging.h
*
* Revision 1.4  2002/09/29 12:32:37  juengel
* Changed semantics of "debug key is active".
* If a debug key is active changes only before the execution of a process.
*
* Revision 1.3  2002/09/17 23:55:23  loetzsch
* - unraveled several datatypes
* - changed the WATCH macro
* - completed the process restructuring
*
* Revision 1.2  2002/09/10 21:07:30  loetzsch
* continued change of module/solution mechanisms
*
* Revision 1.1  2002/09/10 15:53:58  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
* Revision 1.3  2002/07/23 13:48:40  loetzsch
* - new streaming classes
* - removed many #include statements
* - exchanged StaticQueue by MessageQueue
* - new debug message handling
* - general clean up
*
* Revision 1.2  2002/06/28 10:26:22  roefer
* OUTPUT is possible in constructors
*
* Revision 1.1.1.1  2002/05/10 12:40:32  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.15  2002/04/09 11:18:18  loetzsch
* now handles idPlayerConfig
*
* Revision 1.14  2002/02/05 20:02:16  risler
* handleDebugMessage now returns bool, added debug message handling to ImageProcessor
*
* Revision 1.13  2002/02/05 03:43:51  loetzsch
* now loads the player configuration from player.cfg at startup
*
* Revision 1.12  2002/01/30 17:29:13  loetzsch
* handleDebugMessage um Parameter timestamp erweitert
*
* Revision 1.11  2002/01/25 12:51:52  risler
* added message id names
*
* Revision 1.10  2002/01/22 22:42:25  loetzsch
* Added init() again.
*
* Revision 1.9  2002/01/19 12:43:16  risler
* enabled SolutionRequest, changed HandleDebugMessage calls
*
* Revision 1.8  2002/01/18 23:27:51  loetzsch
* solutionRequest and setSolutionRequest added
*
* Revision 1.7  2002/01/15 16:25:09  roefer
* init() removed
*
* Revision 1.6  2001/12/20 17:12:25  loetzsch
* Virtual function init(), that is called before the first main(),
* added.
*
* Revision 1.5  2001/12/15 20:32:08  roefer
* Senders and receivers are now part of the processes
*
* Revision 1.4  2001/12/12 18:08:56  loetzsch
* Streaming- Operatoren fr Bilder eingebaut, DebugKeyTable nicht- statisch gemacht, Debuggin Mechanismen weitergemacht, Bilder aus Logfiles in RobotControl anzeigen, Logfiles in HU1/Debug auf den Stick schreiben
*
* Revision 1.3  2001/12/10 17:47:10  risler
* change log added
*
*/
