<?xml version="1.0" encoding="iso-8859-1"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text" indent="no" omit-xml-declaration="yes" media-type="text/plain" />
<xsl:strip-space elements="*" />



<!-- Global transformations**************************************************************-->

<xsl:template match="potentialfields-configuration">
<xsl:apply-templates select="object"/>
<xsl:apply-templates select="object-state-symbol"/>
<xsl:apply-templates select="object-instance"/>
<xsl:apply-templates select="instance-group"/>
<xsl:apply-templates select="formation-object"/>
<xsl:apply-templates select="potentialfield-composition"/>
</xsl:template>

<xsl:template match="potentialfield-composition">
composition;<xsl:value-of select="@selection-procedure"/>;<xsl:value-of select="@n"/>;<xsl:apply-templates />
</xsl:template>



<!-- Transformations for objects ********************************************************-->

<xsl:template match="object">
object;<xsl:value-of select="@name"/>;<xsl:value-of select="@type"/>;<xsl:value-of select="@tangential-field"/>;<xsl:apply-templates />
</xsl:template>


<xsl:template match="point-field">
point-field;</xsl:template>

<xsl:template match="shape-field">
shape-field;</xsl:template>

<xsl:template match="sector-field">
sector-field;<xsl:value-of select="@opening-angle"/>;<xsl:value-of select="@cross-function"/>;<xsl:value-of select="@smoothing-at-object"/>;<xsl:value-of select="@smoothing-at-border"/>;<xsl:value-of select="@gradient-at-object"/>;<xsl:value-of select="@gradient-at-border"/>;</xsl:template>


<xsl:template match="polygon">
polygon;<xsl:value-of select="@intersectable"/>;<xsl:for-each select="pt"><xsl:value-of select="@x"/>;<xsl:value-of select="@y"/>;</xsl:for-each>EOL;
</xsl:template>

<xsl:template match="line">
line;<xsl:value-of select="@intersectable"/>;<xsl:for-each select="pt"><xsl:value-of select="@x"/>;<xsl:value-of select="@y"/>;</xsl:for-each>
</xsl:template>

<xsl:template match="circle">
circle;<xsl:value-of select="@radius"/>;<xsl:value-of select="@intersectable"/>;
</xsl:template>

<xsl:template match="no-geometry">
no-geometry;</xsl:template>


<xsl:template match="no-function">
no-function;</xsl:template>

<xsl:template match="linear-function">
linear-function;<xsl:value-of select="@range"/>;<xsl:value-of select="@at-zero"/>;<xsl:value-of select="@smoothing-at-object"/>;<xsl:value-of select="@smoothing-at-border"/>;<xsl:value-of select="@gradient-at-object"/>;<xsl:value-of select="@gradient-at-border"/>;</xsl:template>

<xsl:template match="parabolic-function">
parabolic-function;<xsl:value-of select="@range"/>;<xsl:value-of select="@at-zero"/>;<xsl:value-of select="@smoothing-at-object"/>;<xsl:value-of select="@smoothing-at-border"/>;<xsl:value-of select="@gradient-at-object"/>;<xsl:value-of select="@gradient-at-border"/>;</xsl:template>

<xsl:template match="asymptotic-function">
asymptotic-function;<xsl:value-of select="@range"/>;<xsl:value-of select="@at-zero"/>;<xsl:value-of select="@const-interval"/>;<xsl:value-of select="@smoothing-at-object"/>;<xsl:value-of select="@smoothing-at-border"/>;<xsl:value-of select="@gradient-at-object"/>;<xsl:value-of select="@gradient-at-border"/>;</xsl:template>

<xsl:template match="social-function">
social-function;<xsl:value-of select="@repulsive-constant"/>;<xsl:value-of select="@repulsive-exponent"/>;<xsl:value-of select="@attractive-constant"/>;<xsl:value-of select="@attractive-exponent"/>;<xsl:value-of select="@const-interval"/>;<xsl:value-of select="@k"/>;</xsl:template>



<!-- Transformations for instances and object state symbols*******************************************************-->

<xsl:template match="object-instance">
object-instance;<xsl:value-of select="@type"/>;<xsl:value-of select="@name"/>;<xsl:apply-templates /></xsl:template>

<xsl:template match="instance-group">
instance-group;<xsl:value-of select="@name"/>;<xsl:for-each select="include"><xsl:value-of select="@name"/>;</xsl:for-each>EOL;
</xsl:template>

<xsl:template match="object-state-symbol">
object-state-symbol;<xsl:value-of select="@name"/>;</xsl:template>

<xsl:template match="static-pose">
static-pose;<xsl:value-of select="@x"/>;<xsl:value-of select="@y"/>;<xsl:value-of select="@rotation"/>;</xsl:template>

<xsl:template match="dynamic-pose">
dynamic-pose;<xsl:value-of select="@get-data-from"/>;</xsl:template>



<!-- Transformations for formations *********************************************************************************-->

<xsl:template match="formation-object">
formation-object;<xsl:value-of select="@name"/>;<xsl:apply-templates/>EOL;
</xsl:template>

<xsl:template match="among">
among;<xsl:value-of select="@object-group"/>;<xsl:value-of select="@priority"/>;<xsl:apply-templates/>
</xsl:template>

<xsl:template match="between">
between;<xsl:value-of select="@object-1"/>;<xsl:value-of select="@object-2"/>;<xsl:value-of select="@priority"/>;<xsl:apply-templates/>
</xsl:template>

<xsl:template match="relative-to">
relative-to;<xsl:value-of select="@object"/>;<xsl:value-of select="@angle"/>;<xsl:value-of select="@coordinates"/>;<xsl:value-of select="@priority"/>;<xsl:apply-templates/>
</xsl:template>

<xsl:template match="best-fit">
best-fit;<xsl:value-of select="@select"/>;<xsl:apply-templates/>EOL;
</xsl:template>



<!-- Transformations for motion fields*******************************************************-->

<xsl:template match="motionfield">
motionfield;<xsl:value-of select="@name"/>;<xsl:value-of select="@disable-translation"/>;<xsl:value-of select="@disable-rotation"/>;<xsl:value-of select="@max-acceleration"/>;<xsl:value-of select="@max-gradient-difference"/>;<xsl:value-of select="@keep"/>;<xsl:value-of select="@for-n"/>;<xsl:value-of select="@n"/>;<xsl:value-of select="@block-after-selection-for-m"/>;<xsl:value-of select="@m"/>;<xsl:value-of select="@keep-max-for-o"/>;<xsl:value-of select="@o"/>;<xsl:apply-templates select="return-gradient"/><xsl:apply-templates select="return-const"/><xsl:for-each select="combine-with"><xsl:value-of select="@name"/>;</xsl:for-each>EOL;<xsl:apply-templates select="avoid-local-minima"/><xsl:apply-templates select="include-random-motion-generator"/><xsl:for-each select="include"><xsl:value-of select="@name"/>;</xsl:for-each><xsl:for-each select="include-group">include-group;<xsl:value-of select="@name"/>;</xsl:for-each><xsl:for-each select="include-formation">include-formation;<xsl:value-of select="@name"/>;</xsl:for-each>EOL;
</xsl:template>

<xsl:template match="avoid-local-minima">
avoid-local-minima;<xsl:value-of select="@use"/>;<xsl:value-of select="@max-gradient-for-planning"/>;<xsl:value-of select="@goal"/>;<xsl:value-of select="@distance-to-goal"/>;<xsl:value-of select="@min-expansion-radius"/>;<xsl:value-of select="@max-expansion-radius"/>;<xsl:value-of select="@min-branching-factor"/>;<xsl:value-of select="@max-branching-factor"/>;<xsl:value-of select="@end-of-near"/>;<xsl:value-of select="@end-of-far"/>;<xsl:value-of select="@standard-gradient-length"/>;<xsl:value-of select="@max-number-of-search-nodes"/>;<xsl:value-of select="@min-cache-size"/>;<xsl:apply-templates select="stabilization-element"/>
</xsl:template>

<xsl:template match="stabilization-element">
stabilization-element;<xsl:value-of select="@distance"/>;<xsl:apply-templates/>
</xsl:template>

<xsl:template match="include-random-motion-generator">
include-random-motion-generator;<xsl:value-of select="@min-value"/>;<xsl:value-of select="@max-value"/>;<xsl:value-of select="@value-dx"/>;<xsl:value-of select="@direction-dx"/>;<xsl:value-of select="@change-after-n"/>;<xsl:value-of select="@n"/>;
</xsl:template>



<!-- Transformations for action fields*******************************************************-->

<xsl:template match="actionfield">
actionfield;<xsl:value-of select="@name"/>;<xsl:value-of select="@consider-time"/>;<xsl:value-of select="@keep"/>;<xsl:value-of select="@for-n"/>;<xsl:value-of select="@n"/>;<xsl:value-of select="@block-after-selection-for-m"/>;<xsl:value-of select="@m"/>;<xsl:value-of select="@keep-max-for-o"/>;<xsl:value-of select="@o"/>;<xsl:apply-templates select="return-gradient"/><xsl:apply-templates select="return-gain"/><xsl:apply-templates select="return-absolute"/><xsl:apply-templates select="return-const"/><xsl:apply-templates select="fixed-sequence"/><xsl:apply-templates select="find-best-sequence"/><xsl:apply-templates select="action"/>EOL;<xsl:for-each select="combine-with"><xsl:value-of select="@name"/>;</xsl:for-each>EOL;<xsl:for-each select="include"><xsl:value-of select="@name"/>;</xsl:for-each><xsl:for-each select="include-group">include-group;<xsl:value-of select="@name"/>;</xsl:for-each><xsl:for-each select="include-formation">include-formation;<xsl:value-of select="@name"/>;</xsl:for-each>EOL;
</xsl:template>

<xsl:template match="action">
action;<xsl:value-of select="@name"/>;<xsl:apply-templates select="move-object"/><xsl:apply-templates select="move-self"/><xsl:apply-templates select="measure-object"/><xsl:apply-templates select="measure-self"/><xsl:apply-templates select="impact-area"/><xsl:apply-templates select="translation"/><xsl:apply-templates select="rotation"/><xsl:apply-templates select="rotation-to-gradient"/><xsl:apply-templates select="rotation-to-object"/><xsl:apply-templates select="translation-along-gradient"/><xsl:apply-templates select="translation-to-object"/><xsl:apply-templates select="probability-distribution"/><xsl:apply-templates select="no-transformation"/>
</xsl:template>

<xsl:template match="translation">
translation;<xsl:value-of select="@x"/>;<xsl:value-of select="@y"/>;<xsl:value-of select="@time"/>;</xsl:template>

<xsl:template match="translation-to-object">
translation-to-object;<xsl:value-of select="@object"/>;<xsl:value-of select="@speed"/>;</xsl:template>

<xsl:template match="translation-along-gradient">
translation-along-gradient;<xsl:value-of select="@step-length"/>;<xsl:value-of select="@max-gradient-deviation"/>;<xsl:value-of select="@max-length"/>;<xsl:value-of select="@speed"/>;</xsl:template>

<xsl:template match="rotation">
rotation;<xsl:value-of select="@angle"/>;<xsl:value-of select="@time"/>;</xsl:template>

<xsl:template match="rotation-to-gradient">
rotation-to-gradient;<xsl:value-of select="@speed"/>;</xsl:template>

<xsl:template match="rotation-to-object">
rotation-to-object;<xsl:value-of select="@object"/>;<xsl:value-of select="@speed"/>;</xsl:template>

<xsl:template match="no-transformation">
no-transformation;<xsl:value-of select="@time"/>;</xsl:template>

<xsl:template match="probability-distribution">
probability-distribution;<xsl:apply-templates/>EOL;</xsl:template>

<xsl:template match="probability">
<xsl:value-of select="@value"/>;<xsl:apply-templates/></xsl:template>

<xsl:template match="fixed-sequence">
fixed-sequence;<xsl:apply-templates select="action"/>
</xsl:template>

<xsl:template match="find-best-sequence">
find-best-sequence;<xsl:value-of select="@depth"/>;<xsl:value-of select="@decreasing-values-only"/>;<xsl:apply-templates select="action"/>
</xsl:template>

<xsl:template match="return-gain">
gain;</xsl:template>

<xsl:template match="return-absolute">
absolute;</xsl:template>

<xsl:template match="return-gradient">
gradient;</xsl:template>

<xsl:template match="return-const">
const;<xsl:value-of select="@value"/>;</xsl:template>


<xsl:template match="move-object">
move-object;<xsl:value-of select="@join-action"/>;<xsl:value-of select="@name"/>;</xsl:template>

<xsl:template match="move-self">
move-self;</xsl:template>

<xsl:template match="measure-self">
measure-self;</xsl:template>

<xsl:template match="measure-object">
measure-object;<xsl:value-of select="@name"/>;</xsl:template>

<xsl:template match="impact-area">
<xsl:apply-templates />EOL;</xsl:template>



</xsl:stylesheet>
