/**
* @file Player.cpp
*
* Implementation of class Player.
* 
* @author Martin Ltzsch
*/

#ifdef SIMROBOT
#include "Platform/Win32/RoboCupCtrl2.h"
#else

#ifdef _WIN32
#include "Platform/Win32/RoboCupCtrl.h"
#endif

#endif

#include "Player.h"
#include "Tools/Process.h"
#include "Tools/Debugging/Debugging.h"

/** one player config per robot */
#ifdef _WIN32
#ifndef ROBOTREMOTE
  #define _WIN32_AND_NOT_ROBOTREMOTE
#endif
#endif

#ifdef _WIN32_AND_NOT_ROBOTREMOTE
Player thePlayer[ROBOT_MAX];

Player& getPlayer()
{
  return thePlayer[PlatformProcess::getRobotIndex()];
}
#else
Player* thePlayer = 0;

Player& getPlayer()
{
  if(!thePlayer)
    thePlayer = new Player;
  return *thePlayer;
}
#endif

Player::Player()
{
  theTeamColor = undefinedTeamColor;
  thePlayerNumber = undefinedPlayerNumber;
}

void Player::load()
{
#ifdef _WIN32_AND_NOT_ROBOTREMOTE
#ifndef SIMROBOT
  SIM3DOBJECT obj = RoboCupCtrl::getController()->getSimRobotObject();
  int index = obj ? obj->ElementName[4] - '1' : 0;
#else
  int index = RoboCupCtrl::getController()->getRobotName()[4] - '1';
#endif
  if(index < 4)
    theTeamColor = red;
  else
    theTeamColor = blue;
  playerNumber number[4] = 
  {
    one, two, three, four
  };
  thePlayerNumber = number[index & 3];
  strcpy(theTeamName,"sim");
  strcat(theTeamName,this->getTeamColorName(theTeamColor));

#else
  InConfigFile file("player.cfg");

  ASSERT(file.exists());
  
  char buf[50];
  file >> buf >> buf;
  theTeamColor = getTeamColorFromString(buf);

  file >> buf >> buf;
  thePlayerNumber = getPlayerNumberFromString(buf);
 
  if (!file.eof())
  {
     file >> buf >> theTeamName; 
  }
  else
  {
    strcpy(theTeamName,"Undef-");
    strcat(theTeamName,getTeamColorName(theTeamColor));
  }
    
#endif
}

In& operator>>(In& stream,Player& player)
{
  stream.read(&player,sizeof(Player));
  return stream;
}
 
Out& operator<<(Out& stream, const Player& player)
{
  stream.write(&player,sizeof(Player));
  return stream;
}


/*
* Change Log:
*
* $Log: Player.cpp,v $
* Revision 1.1.1.1  2004/05/22 17:35:53  cvsadm
* created new repository GT2004_WM
*
* Revision 1.8  2004/04/26 15:59:01  thomas
* added new project RobotRemote based on ATHAiboControl
*
* Revision 1.7  2004/01/09 15:44:58  wachter
* Added TeamName for Dog-Discovery-Protokol
*
* Revision 1.6  2003/12/06 19:01:05  loetzsch
* replaced undefinedColor by undefinedTeamColor
*
* Revision 1.5  2003/12/06 17:45:33  loetzsch
* replaced Player::playerRole (goalie, defender, striker1, striker2)
* by Player::playerNumber (one, two, three, four)
*
* Revision 1.4  2003/11/17 17:16:31  dueffert
* inclusion bug fixed
*
* Revision 1.3  2003/10/26 08:57:15  roefer
* Symbol SIMROBXP removed
*
* Revision 1.2  2003/10/14 07:34:16  roefer
* Support files for SimRobXP added, not finished yet
*
* Revision 1.1  2003/10/07 10:13:21  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:28  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.5  2003/05/03 16:20:01  roefer
* robot.cfg added
*
* Revision 1.4  2003/04/16 07:00:17  roefer
* Bremen GO checkin
*
* Revision 1.4  2003/04/09 14:47:31  roefer
* bodyTiltOffset is read from player.cfg
*
* Revision 1.3  2003/03/23 17:08:18  roefer
* New player selection in simulation
*
* Revision 1.2  2002/09/11 00:14:43  loetzsch
* continued new module/solution mechanisms
*
* Revision 1.3  2002/09/10 21:58:04  roefer
* Player loading fixed
*
* Revision 1.2  2002/07/23 13:48:40  loetzsch
* - new streaming classes
* - removed many #include statements
* - exchanged StaticQueue by MessageQueue
* - new debug message handling
* - general clean up
*
* Revision 1.1.1.1  2002/05/10 12:40:32  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.3  2002/02/07 19:57:06  risler
* DefaultLEDControl uses getPlayer now, removed team and role from LEDRequest
*
* Revision 1.2  2002/02/05 18:09:35  roefer
* getPlayer() now works for multiple robots
*
* Revision 1.1  2002/02/05 03:42:46  loetzsch
* added to the cvs
*
*/

