/** 
* @file Module.h
*
* Definition of class Module.
*
* @author <a href="mailto:juengel@informatik.hu-berlin.de">Matthias Jngel</a>
* @author <a href="mailto:martin@martin-loetzsch.de">Martin Ltzsch</a>
*/

#ifndef __Module_h_
#define __Module_h_

#include "Tools/MessageQueue/InMessage.h"

/**
* @class Module
*
* Base class for all modules.
*
* @author <a href="mailto:juengel@informatik.hu-berlin.de">Matthias Jngel</a>
* @author <a href="mailto:martin@martin-loetzsch.de">Martin Ltzsch</a>
*/
class Module : public MessageHandler
{
public:
  /** executes the module */
  virtual void execute() = 0;

  /** 
  * Called from a MessageQueue to distribute messages.
  * Use message.getMessageID to decide if the message is relavant for 
  * the MesssageHandler derivate.
  * Use message.bin, message.text or message.config as In streams to get the data from.
  * @param message The message that can be read.
  * @return true if the message was read (handled).
  */
  virtual bool handleMessage(InMessage& message) {return false;}

  virtual ~Module() {};
};

#endif //__Module_h_

/*
* Change Log:
* $Log: Module.h,v $
* Revision 1.1.1.1  2004/05/22 17:37:19  cvsadm
* created new repository GT2004_WM
*
* Revision 1.1  2003/10/07 10:13:24  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:28  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.5  2002/09/19 14:26:52  juengel
* Destructor added.
*
*/
