/**
* @file OutMessage.cpp
*
* Implementation of class OutMessage, OutBinaryMessage, OutTextMessage,
* OutConfigMessage and OutMessageQueue.
*
* @author Martin Ltzsch
*/

#include "OutMessage.h"
#include "Platform/SystemCall.h"

OutMessageQueue::OutMessageQueue()
: queue(0) 
{
}

void OutMessageQueue::open(MessageQueueBase* q)
{
  if (queue == 0) queue = q;
}

void OutMessageQueue::writeToStream(const void* p,int size)
{
  if (queue != 0) queue->write(p,size);
}

OutBinaryMessage::OutBinaryMessage(MessageQueueBase* q)
{
  open(q);
}

OutTextMessage::OutTextMessage(MessageQueueBase* q)
{
  open(q);
}

OutTextRawMessage::OutTextRawMessage(MessageQueueBase* q)
{
  open(q);
}

OutMessage::OutMessage(MessageQueueBase& queue)
: queue(queue), bin(&queue), text(&queue), textRaw(&queue),
teamColorForNewMessages(Player::undefinedTeamColor),
playerNumberForNewMessages(Player::undefinedPlayerNumber)
{
}

void OutMessage::finishMessage(MessageID id)
{
  queue.finishMessage(id,SystemCall::getCurrentSystemTime(),
    teamColorForNewMessages,playerNumberForNewMessages);
}

void OutMessage::finishMessage(MessageID id, unsigned long timeStamp,
                               Player::teamColor teamColor,
                               Player::playerNumber playerNumber,
                               bool messageWasSentFromAPhysicalRobot)
{
  queue.finishMessage(id, timeStamp,teamColor,
    playerNumber,messageWasSentFromAPhysicalRobot);
}

/*
* Change Log:
*
* $Log: OutMessage.cpp,v $
* Revision 1.1.1.1  2004/05/22 17:37:18  cvsadm
* created new repository GT2004_WM
*
* Revision 1.4  2004/01/28 21:04:33  loetzsch
* bug fix
*
* Revision 1.3  2004/01/28 20:52:32  loetzsch
* Added the OutTextRaw stream writer.
*
* Revision 1.2  2003/12/06 23:23:55  loetzsch
* messages in a MessageQueue now contain
* - the team color of the robot which sent the message
* - the player number of the robot which sent the message
* - if the message was sent from a physical robot or not
*
* Revision 1.1  2003/10/07 10:13:24  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:28  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.1  2002/09/10 15:53:59  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
* Revision 1.1  2002/07/23 13:47:14  loetzsch
* - new streaming classes
* - new debug message handling
* - exchanged StaticQueue by MessageQueue
*
*/
