/**
* @file Tools/Math/Permutation.h
* Declares class Permutation
*
* @author <A href=mailto:sebastian.schmidt@udo.edu>Sebastian Schmidt</A>
*/

#ifndef __Permutation_h__
#define __Permutation_h__

/**
* The class Permutation defines a method to calculate permutations
*
*/
class Permutation
{
public:

  /**
  * Calculates the next permutation to a given one. To get all permutations the data-array in the first call
  * should be sorted ascending.
  * @param data The given permutation as input and the next permutation after return. When returned false the array-data is invalid.
  * @param length The number of elements
  * @return A bool wether a next permutation could be calculated.
  */
  static bool perm(int data[], const int& length);

private:

  /**
  * Sort the part of the array between the positions start and end (inclusive) via a quicksort algorithm.
  * @param data The array
  * @param start The first position of the arraypart to sort.
  * @param end The last position of the arraypart to sort.
  */
  static void sort(int data[], const int& start, const int& end);

};

#endif //__Permutation_h____

/*
* Change log :
*
* $Log: Permutation.h,v $
* Revision 1.1.1.1  2004/05/22 17:37:13  cvsadm
* created new repository GT2004_WM
*
* Revision 1.1  2003/10/07 10:13:24  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:28  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.1  2003/02/27 10:07:00  schmidt
* Added three variants of a SensorFusionPlayersLocator.
*
*
*/
