/**
* @file Location.h
* 
* Definiton of class Location.
*
* @author Max Risler
*/
#ifndef __Location_h__
#define __Location_h__

#include "Platform/SystemCall.h"

class Location;

/**
* Returns a reference to the location configuration
*/
Location& getLocation();

/**
 * Class for location dependent configuration
 */
class Location
{
public:
  /** constructor */
  Location();

  /** returns the filename and relative path to a given configuration file
  * without the robotdesign-prefix in the path (root of the location)
  */
  const char* getFilename(const char *file);

  /** returns the filename and relative path to a given configuration file
  * for the current robotdesign-prefix
  */
  const char* getModelFilename(const char *file);

  /** returns the filename and relative path to a given configuration file
  * and given robotdesign
  */
  const char* getModelFilename(const char *file, RobotDesign::Design design);

  /** returns the name of the location */
  const char* getName() const
  {
    return name;
  }

private:
  /** the name of the location */
  char name[100];

  char filename[100];
};

#endif // __Location_h_

/*
 * Change log :
 * 
 * $Log: Location.h,v $
 * Revision 1.3  2004/05/27 12:28:33  thomas
 * added function to get specific config-files for a given robotdesign
 *
 * Revision 1.2  2004/05/27 10:08:09  thomas
 * added model-specific locations
 *
 * Revision 1.1.1.1  2004/05/22 17:35:53  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2003/10/07 10:13:21  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:28  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.1  2003/05/11 17:03:00  risler
 * added location.cfg
 *
 */
