/**
* @file Location.cpp
*
* Implementation of class Location.
* 
* @author Max Risler
*/

#include <string>
#include "Location.h"
#include "Platform/SystemCall.h"
#include "Tools/Streams/InStreams.h"

static Location theLocation;

Location& getLocation()
{
  return theLocation;
}

Location::Location()
{
  name[0] = 0;
  InConfigFile file("location.cfg");
  if(file.exists() && !file.eof())
  {
    file >> name;
  }
}

const char* Location::getFilename(const char *file)
{
  if (name[0] == 0)
    return file;

  sprintf(filename, "Location/%s/%s", name, file);
  return filename;
}

const char* Location::getModelFilename(const char *file)
{
  return getModelFilename(file, SystemCall::getRobotDesign());
}

const char* Location::getModelFilename(const char *file, RobotDesign::Design design)
{
  if (name[0] == 0)
    return file;

  sprintf(filename, "Location/%s/%s/%s", name, RobotDesign::getRobotDesignName(design), file);
  return filename;
}

/*
 * Change log :
 * 
 * $Log: Location.cpp,v $
 * Revision 1.3  2004/05/27 12:28:33  thomas
 * added function to get specific config-files for a given robotdesign
 *
 * Revision 1.2  2004/05/27 10:08:09  thomas
 * added model-specific locations
 *
 * Revision 1.1.1.1  2004/05/22 17:35:53  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2003/10/07 10:13:21  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:28  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2003/05/30 16:26:06  risler
 * bugfix: name initialization
 *
 * Revision 1.1  2003/05/11 17:03:00  risler
 * added location.cfg
 *
 */
