/**
* @file Individual.h
* 
* Declaration of class Individual
*
* @author <a href=mailto:dueffert@informatik.hu-berlin.de>Uwe Dffert</a>
* @author <a href="mailto:a.cesarz@gmx.de">Arthur Cesarz</a>
* @author <a href="mailto:matthias.hebbel@uni-dortmund.de">Matthias Hebbel</a>
*/ 

#ifndef __Individual_h_
#define __Individual_h_

/**
* @class Individual
*
* This is a base class for all parameters sets we want to use in evolution.
*/ 
class Individual
{
public:

	/** Constructor. */
  Individual();

  typedef enum ValueType {valueInt, valueDouble, value2PiDouble} ValueType;
  
  virtual void getDimension(int& dim1, int& dim2)=0;
  virtual void getValue(int index1, int index2, double& min, double& max, double& value, ValueType& type)=0;
  virtual void setValue(int index1, int index2, double value)=0;
  
  /** let this Individual be the mutation of another one: maximum rate of the genes are mutated by maximum amount of (max-min)
  * @param father Take this as original to copy from before mutation
  * @param rate Do mutate with this maximum rate, 0.0...1.0 is useful, 0.5 would mutate up to every second gene
  * @param amount Do mutate single genes at maximum amount*(maxValue-minValue)
  * @param uniformNoise Do mutate with uniform distributed noise if true, with normal distributed otherwise
  */
  void mutationOf(Individual* father, double rate, double amount, bool uniformNoise=false/*, other EvoParams*/);

  /** let this Individual be the crossing over of father and mother
  * even genes are taken from father, uneven from mother
  * @param father Take this as original father to copy one half of the genes from
  * @param mother Take this as original mother to copy one half of the genes from
  */
  void crossingOverOf(Individual* father, Individual* mother/*, other EvoParams*/);
  
  double fitness;
};

#endif //__Individual_h_

/*
* Change log :
* 
* $Log: Individual.h,v $
* Revision 1.1.1.1  2004/05/22 17:36:14  cvsadm
* created new repository GT2004_WM
*
* Revision 1.2  2004/03/24 13:44:49  dueffert
* support for uniform noise mutation readded
*
* Revision 1.1  2003/10/07 10:13:22  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1  2003/09/26 11:40:40  juengel
* - sorted tools
* - clean-up in DataTypes
*
* Revision 1.4  2003/09/01 15:57:42  dueffert
* Genom and Individual merged
*
* Revision 1.3  2003/08/08 14:27:07  dueffert
* implementation added
*
* Revision 1.2  2003/07/30 14:48:11  dueffert
* comments corrected
*
* Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.1  2003/02/10 15:26:58  dueffert
* self made GA stuff
*
*
*/
