/**
 * @file QueueFillRequest.h
 * Declaration of class QueueFillRequest.
 *
 * @author <a href=mailto:dueffert@informatik.hu-berlin.de>Uwe Dffert</a>
 */

#ifndef __QUEUEFILLREQUEST_H__
#define __QUEUEFILLREQUEST_H__

#include "Tools/Streams/InOut.h"

/**
 * @class QueueFillRequest
 * Request to fill DebugQueues with a certain QueueFillMode
 */
class QueueFillRequest
{
public:
	/** different modes for filling debug queues */
	typedef enum QueueFillMode{immediateReadWrite, collectNSeconds, toStickNSeconds, overwriteOlder, rejectAll, toStickImmediately} QueueFillMode;
	
  /** Constructor */
  QueueFillRequest():mode(immediateReadWrite),seconds(0) {}

  /** Constructor
		* @param qfm The requested QueueFillMode.
    * @param sec Number of seconds to wait for in NSeconds modes.
    */
  QueueFillRequest(QueueFillMode qfm, long sec=1):mode(qfm),seconds(sec) {}

  /** requested mode for filling a DebugQueue */
  QueueFillMode mode;

  /** how many seconds shall we wait in collectNSeconds mode */
  long seconds;
};

/**
 * Streaming operator that reads a QueueFillRequest from a stream.
 * @param stream The stream from which is read.
 * @param queueFillRequest The QueueFillRequest object.
 * @return The stream.
 */ 
In& operator>>(In& stream,QueueFillRequest& queueFillRequest);
 
/**
 * Streaming operator that writes a QueueFillRequest to a stream.
 * @param stream The stream to write on.
 * @param queueFillRequest The QueueFillRequest object.
 * @return The stream.
 */ 
Out& operator<<(Out& stream, const QueueFillRequest& queueFillRequest);

#endif // __QUEUEFILLREQUEST_H__

/*
 * Changelog:
 * 
 * $Log: QueueFillRequest.h,v $
 * Revision 1.2  2004/06/16 20:59:35  goehring
 * enum QueueFillRequest::toStickImmediately added
 *
 * Revision 1.1.1.1  2004/05/22 17:36:06  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2003/10/07 10:13:22  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.3  2003/09/28 09:28:48  juengel
 * Comments corrected.
 *
 * Revision 1.2  2003/09/26 15:28:10  juengel
 * Renamed DataTypes to representations.
 *
 * Revision 1.1  2003/09/26 11:40:40  juengel
 * - sorted tools
 * - clean-up in DataTypes
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.5  2003/03/11 09:05:25  dueffert
 * QueueFillRequest rejectAll added
 *
 * Revision 1.4  2002/11/27 13:50:48  dueffert
 * QueueFillMode beautified, doxygen docu added
 *
 * Revision 1.3  2002/11/20 13:37:30  dueffert
 * missing or wrong doxygen file corrected
 *
 * Revision 1.2  2002/11/19 15:43:02  dueffert
 * doxygen comments corrected
 *
 * Revision 1.1  2002/11/19 14:00:46  dueffert
 * no message
 *
 *
 */
