/**
* @file GenericDebugData.cpp
*
* Implementation of class GenericDebugData.
*/

#include "GenericDebugData.h"
#
GenericDebugData::GenericDebugData()
{ }
GenericDebugData::~GenericDebugData()
{ }

In& operator>>(In& stream, GenericDebugData& d)
{
  int id; // = (int )d.id; 
  stream >> id;
  d.id = (GenericDebugData::GenericDebugDataID ) id;

  for(int i = 0; i < 10; i++)
  {
    stream >> d.data[i];
  }

  return stream;
}

Out& operator<<(Out& stream, GenericDebugData& d)
{
  int id = (int )d.id; 
  stream << id;

  for(int i = 0; i < 10; i++)
  {
    stream << d.data[i];
  }

  return stream;
}


/*
 * Change log :
 * 
 * $Log: GenericDebugData.cpp,v $
 * Revision 1.1.1.1  2004/05/22 17:36:05  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2003/10/07 10:13:22  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1  2003/09/26 11:40:40  juengel
 * - sorted tools
 * - clean-up in DataTypes
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2003/01/17 12:48:18  jhoffman
 * added GenericDebugData
 * changes to the TestDataGenerator towards using sliders, min/max, and other cool stuff
 *
 * Revision 1.1  2003/01/16 09:54:49  jhoffman
 * Added "Generic Debug Data" data type. This can be used
 * for quick and dirty optimization and debugging, e.g. to send
 * parameters to a module through WLAN to adjust it's settings.
 * The DebugMessageGenerator is used to for parsing and
 * sendig the data
 *
 * Revision 1.11  2002/12/13 09:54:42  jhoffman
 * walking engine now performes walk-like motions, but still not fully functional
 *
 * Revision 1.10  2002/12/10 16:07:05  dueffert
 * Fourier working now
 *
 * Revision 1.9  2002/12/10 10:47:04  jhoffman
 * debugged and pretty much working
 *
 * Revision 1.8  2002/12/09 15:24:06  dueffert
 * some optimisation
 *
 * Revision 1.7  2002/12/09 14:15:40  jhoffman
 * no message
 *
 * Revision 1.6  2002/12/04 12:21:18  jhoffman
 * no message
 *
 * Revision 1.5  2002/11/22 13:42:08  dueffert
 * cleanup
 *
 * Revision 1.4  2002/11/22 13:41:21  loetzsch
 * - removed the GenericDebugData::loadLegs and ::saveLegs functions
 *   (streaming operators are now used)
 * - .fcb files have text format now
 * . moved the .fcb files from /Config to /Config/Fourier
 *
 * Revision 1.3  2002/11/19 17:14:14  risler
 * coding conventions: renamed JointData::joint to JointID, GetName to getName
 *
 * Revision 1.2  2002/09/22 18:40:54  risler
 * added new math functions, removed GTMath library
 *
 * Revision 1.1  2002/09/10 15:26:40  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed Challenge Code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.2  2002/07/23 13:32:57  loetzsch
 * new streaming classes
 *
 * removed many #include statements
 *
 * Revision 1.1.1.1  2002/05/10 12:40:13  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.10  2002/05/02 12:12:33  kallnik
 * GTMath
 *
 * Revision 1.9  2002/04/25 14:50:37  kallnik
 * changed double/float to double
 * added several #include GTMath
 *
 * PLEASE use double
 *
 * Revision 1.8  2002/04/23 15:00:06  jhoffman
 * changes and additions
 *
 * Revision 1.7  2002/04/03 16:44:31  jhoffman
 * added "stabilizeRobot" to motionControl (which is turned off as a default)
 *
 * Revision 1.4  2002/03/19 13:23:50  jhoffman
 * no message
 *
 * Revision 1.3  2002/03/19 12:11:14  jhoffman
 * extended functionality (synth, load, save, ...)
 *
 * Revision 1.2  2002/03/12 14:10:48  jhoffman
 * added fourier synthesis functionality which calculates the FT from the coefficients
 *
 * Revision 1.1  2002/01/26 20:22:52  juengel
 * no message
 *
 *
 */

