/**
* @file Tools/Debugging/Debugging.cpp
*
* Functions for Debugging
* 
* @author Martin Ltzsch
*/ 

#include "Tools/Process.h"

/** references to outgoing OutMessages */
OutMessage* debugOut[PROCESS_MAX];

/** references to DebugKeyTables */
DebugKeyTable* debugKeyTable[PROCESS_MAX];


void initDebugging(OutMessage* queue, DebugKeyTable* table)
{
  int index = PlatformProcess::getIndex();
  debugOut[index]=queue;
  debugKeyTable[index]=table;
}

OutMessage& getDebugOut()
{
  return *debugOut[PlatformProcess::getIndex()];
}

DebugKeyTable& getDebugKeyTable()
{
  return *debugKeyTable[PlatformProcess::getIndex()];
}

/*
 * Change log :
 * 
 * $Log: Debugging.cpp,v $
 * Revision 1.1.1.1  2004/05/22 17:36:03  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2003/10/07 10:13:22  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:28  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.1  2002/09/10 15:53:58  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.2  2002/07/23 13:48:28  loetzsch
 * - new streaming classes
 * - removed many #include statements
 * - exchanged StaticQueue by MessageQueue
 * - new debug message handling
 * - general clean up
 *
 * Revision 1.1.1.1  2002/05/10 12:40:32  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.4  2002/01/15 16:24:32  roefer
 * Debugging now uses PlatformProcess::getIndex() to distiguish between different processes
 *
 * Revision 1.3  2002/01/14 22:34:42  loetzsch
 * Doxygen comment error fixed
 *
 * Revision 1.2  2001/12/10 17:47:10  risler
 * change log added
 *
 */
