/**
* @file WalkAccelerationRestrictor.h
*
* Definition of class WalkAccelerationRestrictor
*
* @author Martin Ltzsch
*/

#ifndef __WalkAccelerationRestrictor_h_
#define __WalkAccelerationRestrictor_h_

#include "Representations/Motion/MotionRequest.h"

/**
* @class WalkAccelerationRestrictor
*
* Provides functionality for restriction changes in walk speed to maximum values.
*
* @author Martin Ltzsch
*/
class WalkAccelerationRestrictor
{
public:
/**
* Constructor
* @param motionRequest A reference to the motion request that shall be smoothed
  */
  WalkAccelerationRestrictor(MotionRequest& motionRequest);
  
  /** 
  * Smoothes a walk motion. Changes in speed are clipped to a maximum acceleration.
  * Execute that function at the end of the execution of a basic behavior. 
  * @param maxTranslationXAcceleration maximum x translation acceleration (in mm/s^2)
  * @param maxTranslationYAcceleration maximum y translation acceleration (in mm/s^2)
  * @param maxRotationAcceleration maximum rotation acceleration (in Deg/s^2)
  */
  void restrictAccelerations(double maxTranslationXAcceleration, 
    double maxTranslationYAcceleration, 
    double maxRotationAcceleration);
  
    /** 
    * Saves the walk parameters of the last motion request. Should be used at the start
    * of the execution of a skill. 
  */
  void saveLastWalkParameters();
  
protected:
  /** The time when the skill was executed last, used by smoothWalk */
  unsigned long timeOfLastExecution;
  
  /** x translation of the last motion request, used by smoothWalk */
  double lastTranslationX;
  
  /** y translation of the last motion request, used by smoothWalk */
  double lastTranslationY;
  
  /** rotation of the last motion request, used by smoothWalk */
  double lastRotation;
  
  /** A reference to the motion request */
  MotionRequest& mr;
};


#endif //__WalkAccelerationRestrictor_h_

/*
* Change Log:
* 
* $Log: WalkAccelerationRestrictor.h,v $
* Revision 1.1.1.1  2004/05/22 17:36:01  cvsadm
* created new repository GT2004_WM
*
* Revision 1.1  2003/10/07 10:13:21  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.2  2003/09/26 15:28:10  juengel
* Renamed DataTypes to representations.
*
* Revision 1.1  2003/09/26 11:40:40  juengel
* - sorted tools
* - clean-up in DataTypes
*
* Revision 1.1.1.1  2003/07/02 09:40:28  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.1  2003/06/04 00:43:45  loetzsch
* put the GT2003WalkAccelerationRestrictor into two extra files in /Src/Tools
*
*/

