/**
 * @file View.h
 * 
 * Definition of class View
 *
 * @author <A href="mailto:timlaue@informatik.uni-bremen.de">Tim Laue</A>
 */ 

#ifndef SIMROBOTVIEW_H_
#define SIMROBOTVIEW_H_

#include "Sensor.h"
#include "Sensorport.h"

/**
 * @class View
 * 
 * A class for visualizing extra information
 * (Not implemented yet)
 */ 
class View : public Sensor
{
public:
  /** Updates the current view*/
  virtual void update() = 0;

  /** Adds the object to some internal lists
  * @param sensorportList A list of all sensor ports in the scene
  * @param actuatorportList A list of all actuator ports in the scene
  * @param actuatorList A list of all actuators in the scene
  */
  void addToLists(std::vector<Sensorport*>& sensorportList,
                  std::vector<Actuatorport*>&,
                  std::vector<Actuator*>&) 
  {
    sensorportList.push_back(new Sensorport("", 0, viewSensor, this, 0, 0));
  }

  /** Adds descriptions of the object and its children to a list
  * @param objectDescriptionTree The list of descriptions
  * @param The depth of the object in the object tree
  */
  void addToDescriptions(std::vector<ObjectDescription>& objectDescriptionTree,
                         int depth) 
  {
    //Add Sensorport:
    ObjectDescription sensorportDesc;
    int p = name.find_last_of('.');
    sensorportDesc.name = p == -1 ? name : name.substr(p + 1);
    sensorportDesc.fullName = fullName;
    sensorportDesc.depth = depth;
    sensorportDesc.type = OBJECT_TYPE_SENSORPORT;
    objectDescriptionTree.push_back(sensorportDesc);
  }

  /** Returns a string describing the kind of object
  * @return The kind
  */
  virtual std::string getKind() const {return "view";}
};

#endif //SIMROBOTVIEW_H_

/*
 * $Log: View.h,v $
 * Revision 1.1.1.1  2004/05/22 17:35:49  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.3  2004/04/09 18:55:16  roefer
 * Better structure for views
 * cp command added
 * Timing view added
 *
 * Revision 1.2  2003/12/09 13:40:54  roefer
 * href attribute corrected
 *
 * Revision 1.6  2003/12/09 12:38:29  roefer
 * href attribute corrected
 *
 * Revision 1.5  2003/10/18 20:07:32  roefer
 * DirectView added
 *
 * Revision 1.4  2003/09/18 01:50:07  tim
 * - added some comments
 *
 * Revision 1.3  2003/09/08 22:32:08  tim
 * - removed files
 * - added some doxygen documentation
 * - added some const qualifiers
 * - partial code clean-up
 * - minor code changes
 * - remove __ from guards (__ should only be used by compiler)
 *
 * Revision 1.2  2003/09/04 13:34:22  tim
 * - better parsing of numbers
 * - fixed macro bug
 * - better integration of macros in the object tree
 * - added getObjectReference() to Simulation
 * - faster object look-up in Simulation
 * - added changed log
 *
 */