/**
 * @file Surface.h
 * 
 * Definition of class Surface
 *
 * @author <A href="mailto:timlaue@informatik.uni-bremen.de">Tim Laue</A>
 */ 

#ifndef SURFACE_H_
#define SURFACE_H_

#include "SimMath.h"
#include <string>


/** A type describing the style of the surface*/
enum SurfaceType 
{
  SURFACE_COLOR = 0, 
  SURFACE_TEXTURE, 
  SURFACE_DUAL
};

/**
* @class Surface
* A class describing the surface of a drawable object
*/
class Surface
{
public:
  /** The name of the surface*/
  std::string name;
  /** The type of the surface*/
  SurfaceType surfaceType;
  
  /** Constructor */
  Surface() {surfaceType = SURFACE_COLOR;}

  /** Returns the color of the surface
  * @param inverted Flag: Invert colors, if true
  * @return The color as an RGB triple
  */
  Vector3d getColor(bool inverted) const
  {
    if(inverted)
    {
      Vector3d invColor;
      invColor.v[0] = 1.0 - color.v[0];
      invColor.v[1] = 1.0 - color.v[1];
      invColor.v[2] = 1.0 - color.v[2];
      return invColor;
    }
    else
    {
      return color;
    }
  }

  /** Sets the color of the surface
  * @param color The color
  */
  void setColor(const Vector3d& color)
  { this->color = color;}

private:
  /** The color  (usage depends on surfaceType)*/
  Vector3d color;
};

#endif //SURFACE_H_


/*
 * $Log: Surface.h,v $
 * Revision 1.1.1.1  2004/05/22 17:35:49  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.2  2003/12/09 13:40:54  roefer
 * href attribute corrected
 *
 * Revision 1.5  2003/12/09 12:38:28  roefer
 * href attribute corrected
 *
 * Revision 1.4  2003/10/05 15:24:30  tim
 * - changed drag & drop visualization
 *
 * Revision 1.3  2003/09/08 22:32:08  tim
 * - removed files
 * - added some doxygen documentation
 * - added some const qualifiers
 * - partial code clean-up
 * - minor code changes
 * - remove __ from guards (__ should only be used by compiler)
 *
 * Revision 1.2  2003/09/04 13:34:22  tim
 * - better parsing of numbers
 * - fixed macro bug
 * - better integration of macros in the object tree
 * - added getObjectReference() to Simulation
 * - faster object look-up in Simulation
 * - added changed log
 *
 */