/**
 * @file SimMacro.h
 * 
 * Definition of class SimMacro
 *
 * @author <A href="mailto:timlaue@informatik.uni-bremen.de">Tim Laue</A>
 */

#ifndef SIMMACRO_H_
#define SIMMACRO_H_

#include "SimObject.h"

/**
* @class SimMacro
*
* A class representing a macro for an object.
* Macros are used for easier scene descriptions.
* Objects can be instantiated from macros.
*/
class SimMacro : public SimObject
{
public:
  /** Returns the name of the macro
  * @return The name
  */
  std::string getType() const {return name;}

  /** Returns a string describing the kind of object
  * @return The kind
  */
  virtual std::string getKind() const {return "macro";}

  /** Instantiates an object from the macro
  * @return A pointer to a new object
  */
  SimObject* toSimObject() const;
};

#endif //SIMMACRO_H_

/*
 * $Log: SimMacro.h,v $
 * Revision 1.1.1.1  2004/05/22 17:35:44  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.2  2003/12/09 13:40:52  roefer
 * href attribute corrected
 *
 * Revision 1.4  2003/12/09 12:38:27  roefer
 * href attribute corrected
 *
 * Revision 1.3  2003/09/08 22:32:08  tim
 * - removed files
 * - added some doxygen documentation
 * - added some const qualifiers
 * - partial code clean-up
 * - minor code changes
 * - remove __ from guards (__ should only be used by compiler)
 *
 * Revision 1.2  2003/09/04 13:34:22  tim
 * - better parsing of numbers
 * - fixed macro bug
 * - better integration of macros in the object tree
 * - added getObjectReference() to Simulation
 * - faster object look-up in Simulation
 * - added changed log
 *
 */