/**
 * @file SimMacro.cpp
 * 
 * Implementation of class SimMacro
 *
 * @author <A href="mailto:timlaue@informatik.uni-bremen.de">Tim Laue</A>
 */

#include "SimMacro.h"


SimObject* SimMacro::toSimObject() const
{
  SimObject* newObject = new SimObject();
  newObject->setName(name); 
  std::list<SimObject*>::const_iterator pos;
  for(pos = childNodes.begin(); pos != childNodes.end(); ++pos)
  {
    SimObject* childNode = (*pos)->clone();
    newObject->addChildNode(childNode, false);
  }
  return newObject;
}

/*
 * $Log: SimMacro.cpp,v $
 * Revision 1.1.1.1  2004/05/22 17:35:44  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.3  2004/03/22 19:50:09  tim
 * checked line and removed comment
 *
 * Revision 1.2  2003/12/09 13:40:52  roefer
 * href attribute corrected
 *
 * Revision 1.4  2003/12/09 12:38:27  roefer
 * href attribute corrected
 *
 * Revision 1.3  2003/09/08 22:32:08  tim
 * - removed files
 * - added some doxygen documentation
 * - added some const qualifiers
 * - partial code clean-up
 * - minor code changes
 * - remove __ from guards (__ should only be used by compiler)
 *
 * Revision 1.2  2003/09/04 13:34:22  tim
 * - better parsing of numbers
 * - fixed macro bug
 * - better integration of macros in the object tree
 * - added getObjectReference() to Simulation
 * - faster object look-up in Simulation
 * - added changed log
 *
 */