/**
 * @file InteractiveButton.cpp
 * 
 * Implementation of class InteractiveButton
 *
 * @author <A href="mailto:timlaue@informatik.uni-bremen.de">Tim Laue</A>
 */ 

#include "InteractiveButton.h"
#include "Sensorport.h"


InteractiveButton::InteractiveButton()
{
  value = false;
  snapIn = false;
}

void InteractiveButton::addToLists(std::vector<Sensorport*>& sensorportList,
                            std::vector<Actuatorport*>& actuatorportList,
                            std::vector<Actuator*>& actuatorList) 
{
  Sensorport* buttonPort = new Sensorport("click", 0,  boolSensor, this, 
                                          0.0, 1.0);
  sensorportList.push_back(buttonPort);
}

void InteractiveButton::addToDescriptions(std::vector<ObjectDescription>& objectDescriptionTree,
                               int depth) 
{
  Sensor::addToDescriptions(objectDescriptionTree, depth);  
  ObjectDescription sensorportDesc;
  sensorportDesc.name = "click";
  sensorportDesc.fullName = fullName + ".click";
  sensorportDesc.depth = depth + 1;
  sensorportDesc.type = OBJECT_TYPE_SENSORPORT;
  objectDescriptionTree.push_back(sensorportDesc);
}

void InteractiveButton::computeValue(bool& value, int portId)
{
  value = this->value;
}

void InteractiveButton::hasBeenClicked()
{
  if(snapIn)
  {
    value = !value;
  }
  else
  {
    value = true;
  }
}

void InteractiveButton::hasBeenReleased()
{
  if(!snapIn)
  {
    value = false;
  }
}

SimObject* InteractiveButton::clone() const 
{
  InteractiveButton* newInteractiveButton = new InteractiveButton();
  newInteractiveButton->setName(name);
  newInteractiveButton->setFullName(fullName);
  newInteractiveButton->setPosition(position);
  newInteractiveButton->snapIn = snapIn;
  newInteractiveButton->rotation = rotation;
  newInteractiveButton->parentNode = parentNode;
  newInteractiveButton->deactivatedChildNode = deactivatedChildNode;
  newInteractiveButton->deactivatedChildNodeSuccessor = deactivatedChildNodeSuccessor;
  newInteractiveButton->intersectionSphereRadius = intersectionSphereRadius;
  std::list<SimObject*>::const_iterator pos;
  for(pos = childNodes.begin(); pos != childNodes.end(); ++pos)
  {
    SimObject* childNode = (*pos)->clone();
    newInteractiveButton->addChildNode(childNode, false);
  }
  SimObject* newObject = newInteractiveButton;
  return newObject;
}

bool InteractiveButton::isMovableOrClickable(std::string& nameOfObject,
                                             bool testClickable) const
{
  if(testClickable)
  {
    nameOfObject = fullName;
    return true;
  }
  else
  {
    return SimObject::isMovableOrClickable(nameOfObject,testClickable);
  }
}

/*
 * $Log: InteractiveButton.cpp,v $
 * Revision 1.1.1.1  2004/05/22 17:35:38  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.2  2003/12/09 13:40:50  roefer
 * href attribute corrected
 *
 * Revision 1.5  2003/12/09 12:38:26  roefer
 * href attribute corrected
 *
 * Revision 1.4  2003/10/18 20:04:00  roefer
 * Switch is bool sensor
 *
 * Revision 1.3  2003/10/18 11:25:44  tim
 * - fixed intersection tests
 * - faster intersection test
 * - reimplementation of SimGeometry
 * - added portId for sensor calls
 * - finished sensor interfaces for joint and movableObject
 *
 * Revision 1.2  2003/10/17 22:16:25  roefer
 * New files in GT2004 added
 *
 * Revision 1.1  2003/10/12 13:21:32  tim
 * - added interactive buttons
 *
 */
