/**
 * @file Errors.cpp
 * 
 * Implementation of class ErrorManager
 *
 * @author <A href="mailto:timlaue@informatik.uni-bremen.de">Tim Laue</A>
 */ 

#include "Errors.h"


void ErrorManager::getAllErrors(std::vector<ErrorDescription>& errors)
{
  for(unsigned int i = 0; i < this->errors.size(); i++)
  {
    errors.push_back(this->errors[i]);
  }
}

void ErrorManager::addError(const std::string& title, const std::string& text,
                            int line, int column)
{
  ErrorDescription error;
  error.title = title;
  error.text = text;
  error.position = true;
  error.line = line;
  error.column = column;
  addError(error);
}

void ErrorManager::addError(const std::string& title, const std::string& text)
{
  ErrorDescription error;
  error.title = title;
  error.text = text;
  error.position = false;
  error.line = 0;
  error.column = 0;
  addError(error);
}

/*
 * $Log: Errors.cpp,v $
 * Revision 1.1.1.1  2004/05/22 17:35:38  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.3  2003/12/09 13:40:50  roefer
 * href attribute corrected
 *
 * Revision 1.5  2003/12/09 12:38:26  roefer
 * href attribute corrected
 *
 * Revision 1.4  2003/12/03 18:12:37  roefer
 * Compatibility with VC2003.NET, GUI does still not work completely there
 *
 * Revision 1.3  2003/09/08 22:32:07  tim
 * - removed files
 * - added some doxygen documentation
 * - added some const qualifiers
 * - partial code clean-up
 * - minor code changes
 * - remove __ from guards (__ should only be used by compiler)
 *
 * Revision 1.2  2003/09/04 13:34:21  tim
 * - better parsing of numbers
 * - fixed macro bug
 * - better integration of macros in the object tree
 * - added getObjectReference() to Simulation
 * - faster object look-up in Simulation
 * - added changed log
 *
 */