/**
 * @file DrawableObject.h
 * 
 * Definition of abstract class DrawableObject
 *
 * @author <A href="mailto:timlaue@informatik.uni-bremen.de">Tim Laue</A>
 */ 

#ifndef DRAWABLEOBJECT_H_
#define DRAWABLEOBJECT_H_

#include "SimObject.h"
#include "Surface.h"


/**
* @class DrawableObject
* 
* An abstract class representing a drawable object
*/
class DrawableObject : public SimObject
{
protected:
  /** A pointer to a surface object*/
  const Surface* surface;	
  /** Flag: Invert colors, if true*/
  bool inverted;

public:
  /** Constructor*/
  DrawableObject() {surface=0; inverted=false;}

  /** Returns a string describing the kind of object
  * @return The kind
  */
  virtual std::string getKind() const {return "drawableObject";}
  
  /** Sets the surface of the drawable object
  * @param surface The surface
  */
  void setSurface(const Surface* surface) {this->surface = surface;}

  /** Inverts the colors of the object and all subobjects
  *   Used for displaying selections.
  */
  virtual void invertColors()
  {
    inverted = (!inverted);
    SimObject::invertColors();
  }
};

#endif //DRAWABLEOBJECT_H_

/*
 * $Log: DrawableObject.h,v $
 * Revision 1.1.1.1  2004/05/22 17:35:38  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.2  2003/12/09 13:40:50  roefer
 * href attribute corrected
 *
 * Revision 1.6  2003/12/09 12:38:26  roefer
 * href attribute corrected
 *
 * Revision 1.5  2003/10/12 10:24:51  roefer
 * getSurface added to Simulation
 *
 * Revision 1.4  2003/10/05 15:24:30  tim
 * - changed drag & drop visualization
 *
 * Revision 1.3  2003/09/08 22:32:07  tim
 * - removed files
 * - added some doxygen documentation
 * - added some const qualifiers
 * - partial code clean-up
 * - minor code changes
 * - remove __ from guards (__ should only be used by compiler)
 *
 * Revision 1.2  2003/09/04 13:34:21  tim
 * - better parsing of numbers
 * - fixed macro bug
 * - better integration of macros in the object tree
 * - added getObjectReference() to Simulation
 * - faster object look-up in Simulation
 * - added changed log
 *
 */