/**
 * @file Bumper.h
 * 
 * Definition of class Bumper
 *
 * @author <A href="mailto:timlaue@informatik.uni-bremen.de">Tim Laue</A>
 */ 

#ifndef BUMPER_H_
#define BUMPER_H_

#include "Sensor.h"


/**
* @class Bumper
*
* A class representing a bumper.
*/
class Bumper : public Sensor
{
protected:
  /** The current value of the bumper (true/false)*/
  bool value;
  
public:
  /** Constructor */
  Bumper();

  /** Returns a string describing the kind of object
  * @return The kind
  */
  virtual std::string getKind() const {return "bumper";}
  
  /** Computes the current value of the bumper
  * @param value The computed value
  * @param portId The id of the sensorport
  */
  virtual void computeValue(bool& value, int portId);
  
  /** Adds the object to some internal lists
  * @param sensorportList A list of all sensor ports in the scene
  * @param actuatorportList A list of all actuator ports in the scene
  * @param actuatorList A list of all actuators in the scene
  */
  virtual void addToLists(std::vector<Sensorport*>& sensorportList,
    std::vector<Actuatorport*>& actuatorportList,
    std::vector<Actuator*>& actuatorList);
  
  /** Adds descriptions of the object and its children to a list
  * @param objectDescriptionTree The list of descriptions
  * @param The depth of the object in the object tree
  */
  virtual void addToDescriptions(std::vector<ObjectDescription>& objectDescriptionTree,
    int depth);

  /** Clones the object and its child nodes
  * @return A pointer to a copy of the object
  */
  virtual SimObject* clone() const;
};

#endif //BUMPER_H_

/*
 * $Log: Bumper.h,v $
 * Revision 1.1.1.1  2004/05/22 17:35:37  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.2  2003/12/09 13:40:49  roefer
 * href attribute corrected
 *
 * Revision 1.6  2003/12/09 12:38:25  roefer
 * href attribute corrected
 *
 * Revision 1.5  2003/10/18 11:25:44  tim
 * - fixed intersection tests
 * - faster intersection test
 * - reimplementation of SimGeometry
 * - added portId for sensor calls
 * - finished sensor interfaces for joint and movableObject
 *
 * Revision 1.4  2003/09/08 22:32:07  tim
 * - removed files
 * - added some doxygen documentation
 * - added some const qualifiers
 * - partial code clean-up
 * - minor code changes
 * - remove __ from guards (__ should only be used by compiler)
 *
 * Revision 1.3  2003/09/08 11:46:54  tim
 * - added Simulation::getSensorportMinValue
 * - added Simulation::getSensorportMaxValue
 *
 * Revision 1.2  2003/09/04 13:34:21  tim
 * - better parsing of numbers
 * - fixed macro bug
 * - better integration of macros in the object tree
 * - added getObjectReference() to Simulation
 * - faster object look-up in Simulation
 * - added changed log
 *
 */