#ifndef __OFFSCREEN_RENDERER_H_
#define __OFFSCREEN_RENDERER_H_

#include "OpenGL.h"
#include "wglext.h"

class OffscreenRenderer
{
  private:
    static HBITMAP hBitmap,
                   hOldBitmap;
    static void* bitmapBits;
  	static HDC	hDC,
                hMemoryDC;
    static HGLRC hGLContext,
                 hGLContext2;
    static PFNWGLRELEASEPBUFFERDCARBPROC wglReleasePbufferDCARB;
    static PFNWGLDESTROYPBUFFERARBPROC wglDestroyPbufferARB;
    static HPBUFFERARB hPBuffer;
    static int width2,
               height2;
    static bool useOffset;
    bool createFastDC(void* image, int width, int height);
    void determineImagePositionInBuffer(char* image, int width, int height);
    void createSlowDC(int width, int height);

  public:
    static void freeDC();
    void prepareRendering(void* image, int width, int height);
    void finishRendering(void* image, int width, int height);
};

#endif // __OFFSCREEN_RENDERER_H_
