#include "Platform/Globals.h"
#include <afxwin.h>
#include "OffscreenRenderer.h"

HBITMAP OffscreenRenderer::hBitmap = 0,
        OffscreenRenderer::hOldBitmap = 0;
void* OffscreenRenderer::bitmapBits = 0;
HDC OffscreenRenderer::hDC = 0,
    OffscreenRenderer::hMemoryDC = 0;
HGLRC OffscreenRenderer::hGLContext = 0,
      OffscreenRenderer::hGLContext2 = 0;
PFNWGLRELEASEPBUFFERDCARBPROC OffscreenRenderer::wglReleasePbufferDCARB = 0;
PFNWGLDESTROYPBUFFERARBPROC OffscreenRenderer::wglDestroyPbufferARB = 0;
HPBUFFERARB OffscreenRenderer::hPBuffer = 0;
int OffscreenRenderer::width2 = 0,
    OffscreenRenderer::height2 = 0;
bool OffscreenRenderer::useOffset = false;

class FreeOffscreenDC
{
  public:
    ~FreeOffscreenDC() {OffscreenRenderer::freeDC();}
};

static FreeOffscreenDC freeOffscreenDC;

void OffscreenRenderer::freeDC()
{
  if(hBitmap)
  {
    wglDeleteContext(hGLContext);
    SelectObject(hMemoryDC, hOldBitmap);
    DeleteDC(hMemoryDC);
    DeleteObject(hBitmap);
    hBitmap = 0;
  }
  else if(hMemoryDC)
  {
    if(bitmapBits)
      delete [] bitmapBits;
    wglMakeCurrent(hDC, hGLContext2);
    wglDeleteContext(hGLContext);
    wglReleasePbufferDCARB(hPBuffer, hMemoryDC);
    wglDestroyPbufferARB(hPBuffer);
    wglMakeCurrent(NULL, NULL);
    wglDeleteContext(hGLContext2);
    ReleaseDC(AfxGetApp()->m_pMainWnd->GetSafeHwnd(), hDC);
    hMemoryDC = 0;
  }
}

bool OffscreenRenderer::createFastDC(void* image, int width, int height)
{
  PIXELFORMATDESCRIPTOR pfd;
  memset(&pfd, 0, sizeof(PIXELFORMATDESCRIPTOR));
  pfd.nSize = sizeof(PIXELFORMATDESCRIPTOR);
  pfd.nVersion = 1;
  pfd.dwFlags = PFD_DRAW_TO_WINDOW |PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER;
  pfd.iPixelType = PFD_TYPE_RGBA;
  pfd.cColorBits = 16;
  pfd.cDepthBits = 16;
	
  hDC = GetDC(AfxGetApp()->m_pMainWnd->GetSafeHwnd());
  SetPixelFormat(hDC, ChoosePixelFormat(hDC, &pfd), &pfd);
  hGLContext2 = wglCreateContext(hDC);
  wglMakeCurrent(hDC, hGLContext2);
  PFNWGLGETEXTENSIONSSTRINGARBPROC wglGetExtensionsStringARB = (PFNWGLGETEXTENSIONSSTRINGARBPROC) wglGetProcAddress("wglGetExtensionsStringARB");
  if(!wglGetExtensionsStringARB)
    return false;

  const char* ext = (const char*) wglGetExtensionsStringARB(wglGetCurrentDC());

  if(strstr(ext, "WGL_ARB_pbuffer") == NULL || strstr(ext, "WGL_ARB_pixel_format") == NULL)
    return false;

  PFNWGLCREATEPBUFFERARBPROC wglCreatePbufferARB = (PFNWGLCREATEPBUFFERARBPROC) wglGetProcAddress("wglCreatePbufferARB");
  PFNWGLGETPBUFFERDCARBPROC wglGetPbufferDCARB = (PFNWGLGETPBUFFERDCARBPROC) wglGetProcAddress("wglGetPbufferDCARB");
  wglReleasePbufferDCARB = (PFNWGLRELEASEPBUFFERDCARBPROC) wglGetProcAddress("wglReleasePbufferDCARB");
  wglDestroyPbufferARB = (PFNWGLDESTROYPBUFFERARBPROC) wglGetProcAddress("wglDestroyPbufferARB");
  PFNWGLQUERYPBUFFERARBPROC wglQueryPbufferARB = (PFNWGLQUERYPBUFFERARBPROC) wglGetProcAddress("wglQueryPbufferARB");
  PFNWGLGETPIXELFORMATATTRIBIVARBPROC wglGetPixelFormatAttribivARB = (PFNWGLGETPIXELFORMATATTRIBIVARBPROC) wglGetProcAddress("wglGetPixelFormatAttribivARB");
  PFNWGLGETPIXELFORMATATTRIBFVARBPROC wglGetPixelFormatAttribfvARB = (PFNWGLGETPIXELFORMATATTRIBFVARBPROC) wglGetProcAddress("wglGetPixelFormatAttribfvARB");
  PFNWGLCHOOSEPIXELFORMATARBPROC wglChoosePixelFormatARB = (PFNWGLCHOOSEPIXELFORMATARBPROC) wglGetProcAddress("wglChoosePixelFormatARB");
  assert(wglCreatePbufferARB);
  assert(wglGetPbufferDCARB);
  assert(wglReleasePbufferDCARB);
  assert(wglDestroyPbufferARB);
  assert(wglQueryPbufferARB);
  assert(wglGetExtensionsStringARB);
  assert(wglCreatePbufferARB);
  assert(wglGetPbufferDCARB);

  int pf_attr[] =
  {
    WGL_SUPPORT_OPENGL_ARB, TRUE,       // P-buffer will be used with OpenGL
    WGL_DRAW_TO_PBUFFER_ARB, TRUE,      // Enable render to p-buffer
    WGL_BIND_TO_TEXTURE_RGBA_ARB, TRUE, // P-buffer will be used as a texture
    WGL_RED_BITS_ARB, 8,                // At least 8 bits for RED channel
    WGL_GREEN_BITS_ARB, 8,              // At least 8 bits for GREEN channel
    WGL_BLUE_BITS_ARB, 8,               // At least 8 bits for BLUE channel
    WGL_ALPHA_BITS_ARB, 8,              // At least 8 bits for ALPHA channel
    WGL_DEPTH_BITS_ARB, 16,             // At least 16 bits for depth buffer
    WGL_DOUBLE_BUFFER_ARB, FALSE,       // We don't require double buffering
    0                                   // Zero terminates the list
  };

  unsigned int count = 0;
  int pixelFormat;

  wglChoosePixelFormatARB(hDC, (const int*) pf_attr, NULL, 1, &pixelFormat, &count);
  if(!count)
    return false;

  int pb_attr[] =
  {
    WGL_TEXTURE_FORMAT_ARB, WGL_TEXTURE_RGBA_ARB, // Our p-buffer will have a texture format of RGBA
    WGL_TEXTURE_TARGET_ARB, WGL_TEXTURE_2D_ARB,   // Of texture target will be GL_TEXTURE_2D
    0                                             // Zero terminates the list
  };

  width2 = 1,
  height2 = 1;

  while(width2 < width)
    width2 <<= 1;

  while(height2 < height)
    height2 <<= 1;

  hPBuffer = wglCreatePbufferARB(hDC, pixelFormat, width2, height2, pb_attr);
  if(!hPBuffer)
    return false;

  hMemoryDC = wglGetPbufferDCARB(hPBuffer);
  hGLContext = wglCreateContext(hMemoryDC);

  determineImagePositionInBuffer((char*) image, width, height);

  return true;
}

void OffscreenRenderer::determineImagePositionInBuffer(char* image, int width, int height)
{
  if(height > 1)
  {
    // clear whole surface
    verify(wglMakeCurrent(hMemoryDC,hGLContext));
    glViewport(0, 0, width2, height2);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluPerspective(20, double(width2) / height2, 0.01, 2);
  
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    glTranslatef(0.0,0.0,0.0);
    glClearColor(0,0,0,0);
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);			
  
    glShadeModel(GL_FLAT);
    gluLookAt(0, 0, 0, 
              0, 0, 1,
              1, 0, 0);
    glColor3f(0, 0, 0);
    glBegin(GL_POLYGON);
    glVertex3d (200, -200, 1);
    glVertex3d (200, 200, 1);
    glVertex3d (-200, 200, 1);
    glVertex3d (-200, -200, 1);
    glEnd();
    glFlush();
    wglMakeCurrent(NULL,NULL);

    // repaint image part
    verify(wglMakeCurrent(hMemoryDC,hGLContext));
    glViewport(0, 0, width, height);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluPerspective(20, double(width) / height, 0.01, 2);
  
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    glTranslatef(0.0,0.0,0.0);
    glClearColor(0,0,0,0);
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);			
  
    glShadeModel(GL_FLAT);
    gluLookAt(0, 0, 0, 
              0, 0, 1,
              1, 0, 0);

    glColor3f(1,1,1);
    glBegin(GL_POLYGON);
    glVertex3d (100, -100, 1);
    glVertex3d (0, -100, 1);
    glVertex3d (0, 0, 1);
    glVertex3d (100, 0, 1);
    glEnd();
    glBegin(GL_POLYGON);
    glVertex3d (-100, 100, 1);
    glVertex3d (0, 100, 1);
    glVertex3d (0, 0, 1);
    glVertex3d (-100, 0, 1);
    glEnd();

    glFlush();

    glPixelStorei(GL_PACK_ALIGNMENT,1);
    glReadPixels(0, 0, width, height, GL_BGR_EXT, GL_UNSIGNED_BYTE, image);
    wglMakeCurrent(NULL,NULL);

    if(image[0] && image[width * height * 3 - 1])
      bitmapBits = 0;
    else if(image[width * 3 - 1] && image[width * (height - 1) * 3])
      bitmapBits = new char[width2 * height2 * 3];
    else 
    {
      useOffset = true;
      if(image[(height2 - height) * width * 3])
        bitmapBits = 0;
      else
        bitmapBits = new char[width2 * height2 * 3];
    }
  }
  else
    bitmapBits = 0;
}

void OffscreenRenderer::createSlowDC(int width, int height)
{
  width2 = width;
  height2 = height;
  BITMAPINFO bmi;
  memset(&bmi, 0, sizeof(BITMAPINFO));
  bmi.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
  bmi.bmiHeader.biWidth = width;
  bmi.bmiHeader.biHeight = height;
  bmi.bmiHeader.biPlanes = 1;
  bmi.bmiHeader.biBitCount = 24;
  bmi.bmiHeader.biCompression	= BI_RGB;

  hMemoryDC = CreateCompatibleDC(NULL);
  assert(hMemoryDC);

  hBitmap = CreateDIBSection(hMemoryDC, &bmi, DIB_RGB_COLORS, &bitmapBits, NULL, 0);
  hOldBitmap = (HBITMAP) SelectObject(hMemoryDC, hBitmap);

  PIXELFORMATDESCRIPTOR pixelDesc;

  pixelDesc.nSize = sizeof(PIXELFORMATDESCRIPTOR);
  pixelDesc.nVersion = 1;
  
  pixelDesc.dwFlags = PFD_DRAW_TO_BITMAP | PFD_SUPPORT_OPENGL | PFD_SUPPORT_GDI;
  pixelDesc.iPixelType = PFD_TYPE_RGBA;
  pixelDesc.cColorBits = 24;
  pixelDesc.cRedBits = 8;
  pixelDesc.cRedShift = 16;
  pixelDesc.cGreenBits = 8;
  pixelDesc.cGreenShift = 8;
  pixelDesc.cBlueBits = 8;
  pixelDesc.cBlueShift = 0;
  pixelDesc.cAlphaBits = 0;
  pixelDesc.cAlphaShift = 0;
  pixelDesc.cAccumBits = 64;
  pixelDesc.cAccumRedBits = 16;
  pixelDesc.cAccumGreenBits = 16;
  pixelDesc.cAccumBlueBits = 16;
  pixelDesc.cAccumAlphaBits = 0;
  pixelDesc.cDepthBits = 32;
  pixelDesc.cStencilBits = 8;
  pixelDesc.cAuxBuffers = 0;
  pixelDesc.iLayerType = PFD_MAIN_PLANE;
  pixelDesc.bReserved = 0;
  pixelDesc.dwLayerMask = 0;
  pixelDesc.dwVisibleMask = 0;
  pixelDesc.dwDamageMask = 0;

  int glPixelIndex = ChoosePixelFormat(hMemoryDC,&pixelDesc);
  if(glPixelIndex==0)
  {
    glPixelIndex = 1;
    verify(DescribePixelFormat(hMemoryDC,glPixelIndex,sizeof(PIXELFORMATDESCRIPTOR),&pixelDesc));
  }

  verify(SetPixelFormat(hMemoryDC,glPixelIndex,&pixelDesc));
  verify(hGLContext = wglCreateContext(hMemoryDC));
}

void OffscreenRenderer::prepareRendering(void* image, int width, int height)
{
  if(width > width2 || height > height2)
  {
    freeDC();
    if(width < width2)
      width = width2;
    if(height < height2)
      height = height2;
    if(!createFastDC(image, width, height))
      createSlowDC(width, height);
  }
  verify(wglMakeCurrent(hMemoryDC,hGLContext));
}

void OffscreenRenderer::finishRendering(void* image, int width, int height)
{
  glFinish();
  if(hBitmap) // slow buffer
  {
    wglMakeCurrent(NULL,NULL);
    char* pSrc = (char*) bitmapBits,
        * pDest = (char*) image + height * width * 3;
    for(int y = 0; y < height; ++y)
    {
      pDest -= width * 3;
      memcpy(pDest, pSrc, width * 3);
      pSrc += (width2 * 3 + 3) & 0xfffffffc; // row length is multiple of 4
    }
  }
  else 
  {
    int heightOffset = useOffset ? height2 - height : 0;
    if(bitmapBits) // fast buffer, upside down
    {
      glPixelStorei(GL_PACK_ALIGNMENT,1);
      glReadPixels(0, heightOffset, width, height, GL_BGR_EXT, GL_UNSIGNED_BYTE, bitmapBits);
      wglMakeCurrent(NULL,NULL);
      char* pSrc = (char*) bitmapBits + width * height * 3,
          * pDest = (char*) image;
      for(int y = 0; y < height; ++y)
      {
        pSrc -= width * 3;
        memcpy(pDest, pSrc, width * 3);
        pDest += width * 3;
      }
    }
    else // fast buffer
    {
      glPixelStorei(GL_PACK_ALIGNMENT,1);
      glReadPixels(0, heightOffset, width, height, GL_BGR_EXT, GL_UNSIGNED_BYTE, image);
      wglMakeCurrent(NULL,NULL);
    }
  }
}
