// srSensor.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CSensor view

class CSensor : public CView
{
private:
  CMenu m_menuPopup;
  CString m_sSensor;
  int m_sp;
  int m_nView,
      m_nBright,
      m_nDim,
      m_nDimSize[3],
      m_xSize,
      m_ySize,
      m_yAdd,
      m_nBufSize;
  double m_minValue,
         m_maxValue;
  bool m_bGrid,
       m_bRepaint;
  unsigned char m_data,
              * m_pData;
  CRect m_rect;
  CBitmap* m_pBitmap;
  BITMAPINFOHEADER* m_pBuffer;
  void Repaint();
  void DrawBitmap(CDC& dc,CRect& rect);
  void DrawMono();
  void DrawColor();
  void Constrains(unsigned char* pDepth,int* pConstrain,
                  bool* pVisible,double xDepthStep);
  void DrawStereo();
  void DrawMemDC(CDC& dc,CRect& rect);
  POINT Project2D(int x,int y,double z);
  void Grid3D(CDC& dc);
  void DrawLine(CDC& dc);
  void DrawColumn(CDC& dc);
  void DrawDirect(CDC& dc);
  void SetClipboardText();
  void SetClipboardGraphics();
  bool RestoreLayout();

  unsigned char ToChar(double value) const
  {
    value = (value - m_minValue) / (m_maxValue - m_minValue) * 255;
    return value < 0 ? 0 : value > 255 ? 255 : (unsigned char) value;
  }

public:
  void WriteLayout();
protected:
  CSensor();           // protected constructor used by dynamic creation
  DECLARE_DYNCREATE(CSensor)

// Attributes
public:
  CDoc* GetDocument();

// Operations
public:

// Overrides
  // ClassWizard generated virtual function overrides
  //{{AFX_VIRTUAL(CSensor)
  public:
  virtual void OnInitialUpdate();
  protected:
  virtual void OnDraw(CDC* pDC);      // overridden to draw this view
  virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
  //}}AFX_VIRTUAL

// Implementation
protected:
  virtual ~CSensor();
#ifdef _DEBUG
  virtual void AssertValid() const;
  virtual void Dump(CDumpContext& dc) const;
#endif

  // Generated message map functions
protected:
  //{{AFX_MSG(CSensor)
  afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
  afx_msg void OnViewLine();
  afx_msg void OnUpdateViewLine(CCmdUI* pCmdUI);
  afx_msg void OnViewColumn();
  afx_msg void OnUpdateViewColumn(CCmdUI* pCmdUI);
  afx_msg void OnViewMono();
  afx_msg void OnUpdateViewMono(CCmdUI* pCmdUI);
  afx_msg void OnViewColor();
  afx_msg void OnUpdateViewColor(CCmdUI* pCmdUI);
  afx_msg void OnViewStereo();
  afx_msg void OnUpdateViewStereo(CCmdUI* pCmdUI);
  afx_msg void OnViewGrid();
  afx_msg void OnUpdateViewGrid(CCmdUI* pCmdUI);
  afx_msg void OnBright();
  afx_msg void OnUpdateBright(CCmdUI* pCmdUI);
  afx_msg BOOL OnEraseBkgnd(CDC* pDC);
  afx_msg void OnEditCopy();
  afx_msg void OnUpdateEditCopy(CCmdUI* pCmdUI);
  //}}AFX_MSG
  DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

#ifndef _DEBUG  // debug version in srSensor.cpp
inline CDoc* CSensor::GetDocument()
   { return (CDoc*)m_pDocument; }
#endif
