// srObject.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CObjectView view

class CObjectView : public CView
{
private:
  CMenu m_menuPopup;
  CString m_sObject;
  HDC m_hDC;
  HGLRC m_hGLContext;
  int m_nDL;
  bool m_bValid,
       m_bDrag;
  InteractiveSelectionType interactiveSelection;
  SimObject* selectedObject;
  bool showSensors;
  double zoomDistance;
  DragAndDropPlane m_plane;
  VisualizationParameterSet visualizationParameters;
  int verticalOpeningAngleIdx;
  void DoDraw(const CRect& rect);
  bool RestoreLayout();
  void computeZoom(ZoomFitType zoomFitType);

public:
  void WriteLayout();

protected:
  DECLARE_DYNCREATE(CObjectView)

// Attributes
public:
  CDoc* GetDocument();

// Operations
public:

// Overrides
  // ClassWizard generated virtual function overrides
  //{{AFX_VIRTUAL(CObjectView)
	public:
  virtual void OnInitialUpdate();
	protected:
  virtual void OnDraw(CDC* pDC);      // overridden to draw this view
  virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
  virtual void OnActivateView(BOOL bActivate, CView* pActivateView, CView* pDeactiveView);
	//}}AFX_VIRTUAL

// Implementation
protected:
#ifdef _DEBUG
  virtual void AssertValid() const;
  virtual void Dump(CDumpContext& dc) const;
#endif

  // Generated message map functions
protected:
  //{{AFX_MSG(CObjectView)
  afx_msg void OnUpdateDist(CCmdUI* pCmdUI);
  afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
  afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
  afx_msg void OnDist();
  afx_msg void OnZoom();
  afx_msg void OnSelectSurfaceStyle();
  afx_msg void OnUpdateSurfaceStyle(CCmdUI* pCmdUI);
  afx_msg void OnShowSensors();
  afx_msg void OnUpdateShowSensors(CCmdUI* pCmdUI);
  afx_msg void OnEditCopy();
  afx_msg void OnUpdateEditCopy(CCmdUI* pCmdUI);
  afx_msg BOOL OnEraseBkgnd(CDC* pDC);
  afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
  afx_msg void OnMouseMove(UINT nFlags, CPoint point);
  afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
  afx_msg void OnDestroy();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnPlaneXY();
	afx_msg void OnUpdatePlaneXY(CCmdUI* pCmdUI);
	afx_msg void OnPlaneXZ();
	afx_msg void OnUpdatePlaneXZ(CCmdUI* pCmdUI);
	afx_msg void OnPlaneYZ();
	afx_msg void OnUpdatePlaneYZ(CCmdUI* pCmdUI);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	//}}AFX_MSG
  DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

#ifndef _DEBUG  // debug version in srObject.cpp
inline CDoc* CObjectView::GetDocument()
   { return (CDoc*)m_pDocument; }
#endif
