// srDoc.h : interface of the CDoc class
//
/////////////////////////////////////////////////////////////////////////////

#include "SimRobotCore\Simulation.h"

class Controller;

#define UPDATE_INIT 0
#define UPDATE_ERROR 1
#define UPDATE_SUCCESS 2
#define UPDATE_ACTORS 3
#define UPDATE_SENSORS 4
#define UPDATE_OBJECTS 5

inline UINT AFXAPI HashKey(const CString& key)
{
  return ((UINT)(void*)(DWORD)&key) >> 4;
}

class CDoc : public CDocument
{
private:
  bool m_bRunning,
       m_bStep;
  Controller* m_pController;
  Simulation* m_pSim;
  CString m_sStatusMessage;
  CString m_sSection;
  CMapStringToPtr m_map;
  std::vector<ObjectDescription> m_objectDescriptionTree;
  ErrorDescription m_errorDescription;

  void Compile();
  virtual void OnIdle();
  virtual void UpdateFrameCounts();
  bool InitLayoutFile();
  int GetNumberFromWindow(CWnd* pWnd);
  CView* GetViewFromNumber(int n);
  void WriteLayout();
  void RestoreLayout();
public:
  static CDoc* theDocument;
  CString m_sLayoutFile;
  Simulation* GetSimulation() {return m_pSim;}
  CString GetSelectedObject();
  const std::vector<ObjectDescription>& GetObjectDescriptionTree() const 
    {return m_objectDescriptionTree;}
  ObjectType GetType(CString fullName) const;
  bool IsRestoringLayout() {return !(m_sLayoutFile == "");}
  const char* GetLayoutFile() {return m_sLayoutFile;}
  void NewSection(const CString& sSection);
  void WriteString(const CString& sName,const CString& sValue);
  void WriteInt(const CString& sName,int nValue);
  void WriteDouble(const CString& sName,double value);
  CString ReadString(const CString& sName);
  int ReadInt(const CString& sName);
  double ReadDouble(const CString& sName);
  void OnSelected(SimObject*);
  void OnConsoleCommand(const char* command);
  void OnConsoleCompletion(char* command, bool forard);
protected: // create from serialization only
  CDoc();
  DECLARE_DYNCREATE(CDoc)

// Attributes
public:

// Operations
public:

// Overrides
  // ClassWizard generated virtual function overrides
  //{{AFX_VIRTUAL(CDoc)
  public:
  virtual BOOL OnNewDocument();
  virtual void Serialize(CArchive& ar);
  virtual void OnCloseDocument();
  virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
  virtual BOOL CanCloseFrame(CFrameWnd* pFrame);
  //}}AFX_VIRTUAL

// Implementation
public:
  virtual ~CDoc();
#ifdef _DEBUG
  virtual void AssertValid() const;
  virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
  //{{AFX_MSG(CDoc)
  afx_msg void OnSimReset();
  afx_msg void OnUpdateSimReset(CCmdUI* pCmdUI);
  afx_msg void OnSimStart();
  afx_msg void OnUpdateSimStart(CCmdUI* pCmdUI);
  afx_msg void OnSimStep();
  afx_msg void OnUpdateSimStep(CCmdUI* pCmdUI);
  afx_msg void OnViewTree();
  afx_msg void OnUpdateSteps(CCmdUI* pCmdUI);
  afx_msg void OnKey0();
  afx_msg void OnKey1();
  afx_msg void OnKey2();
  afx_msg void OnKey3();
  afx_msg void OnKey4();
  afx_msg void OnKey5();
  afx_msg void OnKey6();
  afx_msg void OnKey7();
  afx_msg void OnKey8();
  afx_msg void OnKey9();
  afx_msg void OnKeyDec();
  //}}AFX_MSG
  DECLARE_MESSAGE_MAP()

  // Generated OLE dispatch map functions
  //{{AFX_DISPATCH(CDoc)
    // NOTE - the ClassWizard will add and remove member functions here.
    //    DO NOT EDIT what you see in these blocks of generated code !
  //}}AFX_DISPATCH
  DECLARE_DISPATCH_MAP()
  DECLARE_INTERFACE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
