// srDoc.cpp : implementation of the CDoc class
//

#include "stdafx.h"
#include "../Controller/Controller.h"
#include "srDoc.h"
#include "srObject.h"
#include "srBar.h"
#include "srConsole.h"
#include "srFrame.h"
#include "srEditor.h"
#include "srTree.h"
#include "srSensor.h"
#include "srActuator.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//////////////////////////////////////////////////////////////////////////
// class Connection

Connection* Connection::start = 0;

Connection::Connection(char* sceneName)
: sceneName(sceneName)
{
  next = start;
  start = this;
}

void WinExit(const char* pMessage)
{
  AfxMessageBox(pMessage,MB_OK | MB_ICONSTOP);
  exit(1);
}

/////////////////////////////////////////////////////////////////////////////
// CDoc

IMPLEMENT_DYNCREATE(CDoc, CDocument)

BEGIN_MESSAGE_MAP(CDoc, CDocument)
  //{{AFX_MSG_MAP(CDoc)
  ON_COMMAND(ID_SIM_RESET, OnSimReset)
  ON_UPDATE_COMMAND_UI(ID_SIM_RESET, OnUpdateSimReset)
  ON_COMMAND(ID_SIM_START, OnSimStart)
  ON_UPDATE_COMMAND_UI(ID_SIM_START, OnUpdateSimStart)
  ON_COMMAND(ID_SIM_STEP, OnSimStep)
  ON_UPDATE_COMMAND_UI(ID_SIM_STEP, OnUpdateSimStep)
  ON_COMMAND(ID_VIEW_TREE, OnViewTree)
  ON_UPDATE_COMMAND_UI(ID_STEPS, OnUpdateSteps)
  ON_COMMAND(ID_KEY0, OnKey0)
  ON_COMMAND(ID_KEY1, OnKey1)
  ON_COMMAND(ID_KEY2, OnKey2)
  ON_COMMAND(ID_KEY3, OnKey3)
  ON_COMMAND(ID_KEY4, OnKey4)
  ON_COMMAND(ID_KEY5, OnKey5)
  ON_COMMAND(ID_KEY6, OnKey6)
  ON_COMMAND(ID_KEY7, OnKey7)
  ON_COMMAND(ID_KEY8, OnKey8)
  ON_COMMAND(ID_KEY9, OnKey9)
  ON_COMMAND(ID_KEYDEC, OnKeyDec)
  //}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CDoc, CDocument)
  //{{AFX_DISPATCH_MAP(CDoc)
    // NOTE - the ClassWizard will add and remove mapping macros here.
    //      DO NOT EDIT what you see in these blocks of generated code!
  //}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()

// Note: we add support for IID_ISimRob to support typesafe binding
//  from VBA.  This IID must match the GUID that is attached to the 
//  dispinterface in the .ODL file.

// {374572E1-9952-11CF-8437-444553540000}
static const IID IID_ISimRob =
{ 0x374572e1, 0x9952, 0x11cf, { 0x84, 0x37, 0x44, 0x45, 0x53, 0x54, 0x0, 0x0 } };

BEGIN_INTERFACE_MAP(CDoc, CDocument)
  INTERFACE_PART(CDoc, IID_ISimRob, Dispatch)
END_INTERFACE_MAP()

CDoc* CDoc::theDocument = 0;

/////////////////////////////////////////////////////////////////////////////
// CDoc construction/destruction

CDoc::CDoc()
{
  m_pSim = 0;
  m_pController = 0;
  m_bRunning = false;
  m_bStep = 0;
  EnableAutomation();
  AfxOleLockApp();
  m_sStatusMessage = "";
  theDocument = this;
}

CDoc::~CDoc()
{
  theDocument = 0;
  AfxOleUnlockApp();
  if (m_pController)
  {
    m_pController->destroy();
    delete m_pController;
    m_pController = 0;
  }
  if (m_pSim)
  {
    delete m_pSim;
    m_pSim = 0;
  }
}

BOOL CDoc::OnNewDocument()
{
  if (!CDocument::OnNewDocument())
    return false;
  return true;
}

void CDoc::OnCloseDocument() 
{
  WriteLayout();
  CDocument::OnCloseDocument();
}

/////////////////////////////////////////////////////////////////////////////
// CDoc serialization

void CDoc::Serialize(CArchive& ar)
{
  // CEditView contains an edit control which handles all serialization
  ((CEditView*)m_viewList.GetHead())->SerializeRaw(ar);
}

/////////////////////////////////////////////////////////////////////////////
// CDoc diagnostics

#ifdef _DEBUG
void CDoc::AssertValid() const
{
  CDocument::AssertValid();
}

void CDoc::Dump(CDumpContext& dc) const
{
  CDocument::Dump(dc);
}
#endif //_DEBUG

void CDoc::Compile()
{
// check if document has a name
  if(IsModified() || GetPathName() == "")
  {
    AfxGetMainWnd()->SendMessage(WM_COMMAND,ID_FILE_SAVE);
    if(IsModified() || GetPathName() == "")
      return;
  }
  ((CFrame*) AfxGetMainWnd())->m_wndConsoleBar.Clear();
// set directory for relative paths in texture load commands
  CString sPathName = GetPathName().Left(GetPathName().ReverseFind('\\'));
  SetCurrentDirectory(sPathName);
  sPathName = AfxGetApp()->m_pszHelpFilePath;
  sPathName = sPathName.Left(sPathName.ReverseFind('\\')) + "\\simrobot.dtd";

// compile
  m_pSim = new Simulation();
// check for an error
  if(!m_pSim->loadFile((const char*) GetPathName(), (const char*) sPathName))
  {
    m_pSim->getFirstError(m_errorDescription);
    m_sStatusMessage = m_errorDescription.text.c_str();
    delete m_pSim;
    m_pSim = 0;
    MessageBeep(MB_ICONHAND);
  }
  else
  {
// search for controller
    m_pSim->getObjectDescriptionTree(m_objectDescriptionTree);
    CString sScene = m_objectDescriptionTree.front().name.c_str();
    Connection* pThis = Connection::start;
    while (pThis && !(sScene == pThis->sceneName))
	    pThis = pThis->next;
    if(pThis)
    {
      m_pController = pThis->createController();
      if(m_pSim->hasSceneGraphChanged())
      {
        m_pSim->getObjectDescriptionTree(m_objectDescriptionTree);
        m_pSim->resetSceneGraphChanged();
      }
      m_sStatusMessage.LoadString(IDS_SUCCESS);
    }
    else
      m_sStatusMessage.LoadString(IDS_NOCONTROLLER);
  }
}

CString CDoc::GetSelectedObject()
{
  POSITION pos = GetFirstViewPosition();
  ASSERT(pos);
  CView* pView;
  do
  {
    pView = GetNextView(pos);
  }
  while(pos && !pView->IsKindOf(RUNTIME_CLASS(CTree)));
  ASSERT(pView->IsKindOf(RUNTIME_CLASS(CTree)));
  return ((CTree*) pView)->GetSelectedObject();
}

ObjectType CDoc::GetType(CString fullName) const
{
  if(m_pSim)
    for(std::vector<ObjectDescription>::const_iterator iter = m_objectDescriptionTree.begin();
      iter != m_objectDescriptionTree.end(); ++iter)
      if(iter->fullName == (const char*) fullName)
        return iter->type;
  return OBJECT_TYPE_NONE;
}

bool CDoc::InitLayoutFile()
{
  m_map.RemoveAll();
  m_sLayoutFile = GetPathName();
  if(m_sLayoutFile == "")
    return false;
  m_sLayoutFile = m_sLayoutFile.Left(m_sLayoutFile.ReverseFind('.'));
  CString appName;
  appName.LoadString(AFX_IDS_APP_TITLE);
  m_sLayoutFile = appName + "\\Layouts\\" + m_sLayoutFile.Mid(m_sLayoutFile.ReverseFind('\\')+1);
  return true;
}

void CDoc::NewSection(const CString& sSection)
{
  int nCount;
  if(!m_map.Lookup(sSection,(void*&) nCount))
    nCount = 1;
  else
    nCount++;
  m_map.SetAt(sSection,(void*) nCount);
  char buf[10];
  sprintf(buf,"%d",nCount);
  m_sSection = sSection + buf;
}

void CDoc::WriteString(const CString& sName,const CString& sValue)
{
  AfxGetApp()->WriteProfileString(m_sSection,sName,sValue);
}

void CDoc::WriteInt(const CString& sName,int nValue)
{
  char buf[30];
  sprintf(buf,"%d",nValue);
  WriteString(sName,buf);
}

void CDoc::WriteDouble(const CString& sName, double value)
{
  char buf[50];
  sprintf(buf,"%f",value);
  WriteString(sName,buf);
}

CString CDoc::ReadString(const CString& sName)
{
  CString buf = AfxGetApp()->GetProfileString(m_sSection,sName);
  return (const char*) buf;
}

int CDoc::ReadInt(const CString& sName)
{
  int n;
  if(sscanf(ReadString(sName)," %d",&n) > 0)
    return n;
  else
    return 0;
}

double CDoc::ReadDouble(const CString& sName)
{
  float f(0.0);
  if((sscanf(ReadString(sName)," %f",&f) > 0) && (f>0.0000001))
    return f;
  else
    return 0.0;
}

int CDoc::GetNumberFromWindow(CWnd* pWnd)
{
  int n = 1;
  for(POSITION pos = GetFirstViewPosition(); pos;)
  {
    if(GetNextView(pos)->GetParent() == pWnd)
      return n;
    n++;
  }
  return 0;
}

CView* CDoc::GetViewFromNumber(int n)
{
  POSITION pos = GetFirstViewPosition();
  CView* pView = GetNextView(pos);
  for(int i = 1; i < n; i++)
    pView = GetNextView(pos);
  return pView;
}

void CDoc::WriteLayout()
{
  if(!InitLayoutFile())
    return;
  const char* pTemp = AfxGetApp()->m_pszProfileName;
  AfxGetApp()->m_pszProfileName = m_sLayoutFile;
  NewSection("SimRobot");
  WriteInt("version",1);
  NewSection("doc");
  WriteInt("compile",m_pSim ? 1 : 0);
  WriteInt("run",m_bRunning);
  POSITION pos = GetFirstViewPosition();
  CString sViews;
  while(pos)
  {
    CView* pView = GetNextView(pos);
    char* pKind = "";
    if(pView->IsKindOf(RUNTIME_CLASS(CEditor)))
      pKind = "e";
    else if(pView->IsKindOf(RUNTIME_CLASS(CTree)))
      pKind = "t";
    else if(pView->IsKindOf(RUNTIME_CLASS(CObjectView)))
      pKind = "o";
    else if(pView->IsKindOf(RUNTIME_CLASS(CSensor)))
      pKind = "s";
    else if(pView->IsKindOf(RUNTIME_CLASS(CActuator)))
      pKind = "a";
    sViews = sViews + pKind;
  }
  WriteString("views",sViews);
  CFrame* pFrame = (CFrame*) AfxGetMainWnd();
  CWnd* pWnd = pFrame->MDIGetActive();
  int n = 1;
  while(pWnd)
  {
    int nWindow = GetNumberFromWindow(pWnd);
    if(nWindow)
    {
      char buf[10];
      sprintf(buf,"order%d",n++);
      WriteInt(buf,nWindow);
    }
    pWnd = pWnd->GetWindow(GW_HWNDNEXT);
  }
  pFrame->WriteLayout();
  pos = GetFirstViewPosition();
  while(pos)
  {
    CView* pView = GetNextView(pos);
    if(pView->IsKindOf(RUNTIME_CLASS(CEditor)))
      ((CEditor*) pView)->WriteLayout();
    else if(pView->IsKindOf(RUNTIME_CLASS(CTree)))
      ((CTree*) pView)->WriteLayout();
    else if(pView->IsKindOf(RUNTIME_CLASS(CObjectView)))
      ((CObjectView*) pView)->WriteLayout();
    else if(pView->IsKindOf(RUNTIME_CLASS(CSensor)))
      ((CSensor*) pView)->WriteLayout();
    else if(pView->IsKindOf(RUNTIME_CLASS(CActuator)))
      ((CActuator*) pView)->WriteLayout();
  }
  AfxGetApp()->m_pszProfileName = pTemp;
}

void CDoc::RestoreLayout()
{
  CApp* pApp = (CApp*) AfxGetApp();
  if(!InitLayoutFile())
    return;
  const char* pTemp = pApp->m_pszProfileName;
  pApp->m_pszProfileName = m_sLayoutFile;
  NewSection("SimRobot");
  if(!ReadInt("version"))
  {
    pApp->m_pszProfileName = pTemp;
    m_sLayoutFile = "";
    return;
  }
  ((CFrame*) AfxGetMainWnd())->RestoreLayout();
  POSITION pos = GetFirstViewPosition();
  ((CEditor*) GetNextView(pos))->RestoreLayout();
  NewSection("doc");
  m_bRunning = ReadInt("run") != 0;
  if(ReadInt("compile"))
  {
    Compile();
    if(!m_pSim)
      m_bRunning = false;
  }
  CString sViews = ReadString("views");
  int nViews = sViews.GetLength();
  int* pOrder = new int[nViews];
  for(int i = 0; i < nViews; i++)
  {
    char buf[10];
    sprintf(buf,"order%d",i+1);
    pOrder[i] = ReadInt(buf);
  }
  while(!(sViews == ""))
  {
    CString sKind = sViews.Left(1);
    sViews = sViews.Mid(1);
    if(sKind == "t")
      pApp->CreateTree(this);
    else if(sKind == "o")
      pApp->CreateObject(this);
    else if(sKind == "s")
      pApp->CreateSensor(this);
    else if(sKind == "a")
      pApp->CreateActuator(this);
  }
  CWnd** pWnd = new CWnd*[nViews];
  for(i = 0; i < nViews; i++)
    pWnd[i] = GetViewFromNumber(pOrder[i])->GetParent();
  pApp->SetOrder(pWnd,nViews);
  delete [] pOrder;
  pApp->m_pszProfileName = pTemp;
  m_sLayoutFile = "";
}

void CDoc::OnSelected(SimObject* obj)
{
  if(m_pController)
    m_pController->onSelected(obj);
}

void CDoc::OnConsoleCommand(const char* command)
{
  if(m_pController)
    m_pController->onConsoleCommand(command);
}

void CDoc::OnConsoleCompletion(char* command, bool forward)
{
  if(m_pController)
  {
    std::string s(command);
    m_pController->onConsoleCompletion(s, forward);
    strncpy(command, s.c_str(), 200);
  }
}

/////////////////////////////////////////////////////////////////////////////
// CDoc commands

void CDoc::OnSimReset() 
{
  bool bWasRunning = m_bRunning;
  m_bRunning = false;
  if(m_pController)
  {
    m_pController->destroy();
    delete m_pController;
    m_pController = 0;
  }
  if(m_pSim)
  {
    delete m_pSim;
    m_pSim = 0;
  }
  Compile();
  if(m_pSim)
  {
    POSITION pos = GetFirstViewPosition();
    GetNextView(pos);
    if(!pos)
      AfxGetMainWnd()->SendMessage(WM_COMMAND,ID_VIEW_TREE);
    UpdateAllViews(0,UPDATE_SUCCESS,0);
    m_bRunning = bWasRunning;
  }
  else
    UpdateAllViews(0,UPDATE_ERROR,
                   (CObject*) &CPoint(m_errorDescription.column,m_errorDescription.line));
}

void CDoc::OnUpdateSimReset(CCmdUI* pCmdUI) 
{
  pCmdUI->Enable(true);
}

void CDoc::OnSimStart() 
{
  if(m_bRunning)
    m_bRunning = false;
  else
  {
    if(IsModified() || !m_pSim)
      OnSimReset();
    if(m_pSim)
      m_bRunning = true;
  }
}

void CDoc::OnUpdateSimStart(CCmdUI* pCmdUI) 
{
  pCmdUI->Enable();
  pCmdUI->SetCheck(m_bRunning);
}

void CDoc::OnSimStep() 
{
  if(m_bRunning)
    return;
  if(IsModified() || !m_pSim)
    OnSimReset();
  if(m_pSim)
    m_bStep = true;
}

void CDoc::OnUpdateSimStep(CCmdUI* pCmdUI) 
{
  pCmdUI->Enable(!m_bRunning);
}

void CDoc::OnIdle()
{
  if(m_bStep || m_bRunning)
  {
    m_bStep = false;
    CString sMessage;
    if(m_pController)
    {
      m_pController->execute();
      if(m_pSim->hasSceneGraphChanged())
        m_pSim->getObjectDescriptionTree(m_objectDescriptionTree);
    }
    UpdateAllViews(0,UPDATE_ACTORS,0);
    m_pSim->doSimulationStep();
    UpdateAllViews(0,UPDATE_SENSORS,0);
    m_sStatusMessage = (const char *) sMessage;
    if(m_bRunning)
      AfxGetMainWnd()->PostMessage(WM_USER);
  }
  ((CFrame*) AfxGetMainWnd())->SetMessageText(m_sStatusMessage);
}

void CDoc::UpdateFrameCounts()
{
}

void CDoc::OnViewTree() 
{
  POSITION pos = GetFirstViewPosition();
  CView* pView;
  do
  {
    pView = GetNextView(pos);
  }
  while(pos && !pView->IsKindOf(RUNTIME_CLASS(CTree)));
  if(pView->IsKindOf(RUNTIME_CLASS(CTree)))
  {
    if(pView->GetParent()->IsIconic())
      pView->GetParent()->ShowWindow(SW_RESTORE);
    ((CMDIChildWnd*) pView->GetParent())->MDIActivate();
  }
  else
    ((CApp*) AfxGetApp())->CreateTree(this);
}

void CDoc::OnUpdateSteps(CCmdUI* pCmdUI) 
{
  if(GetSimulation())
  {
    pCmdUI->Enable();
    char buf[20];
    sprintf(buf,"%06d",GetSimulation()->getSimulationStep());
    pCmdUI->SetText(buf);
  }
  else
  {
    pCmdUI->Enable(false);
    pCmdUI->SetText("000000");
  }
}

BOOL CDoc::OnOpenDocument(LPCTSTR lpszPathName) 
{
  if (!CDocument::OnOpenDocument(lpszPathName))
    return false;
  SetPathName(lpszPathName,false);
  RestoreLayout();
  return true;
}

BOOL CDoc::CanCloseFrame(CFrameWnd* pFrame) 
{
  POSITION pos = GetFirstViewPosition();
  if(GetNextView(pos)->GetParentFrame() == pFrame)
    return SaveModified();
  else
    return true;
}

void CDoc::OnKey0()
{
  if(m_pController)
    m_pController->onKeyPressed(0);
}

void CDoc::OnKey1()
{
  if(m_pController)
    m_pController->onKeyPressed(1);
}

void CDoc::OnKey2()
{
  if(m_pController)
    m_pController->onKeyPressed(2);
}

void CDoc::OnKey3()
{
  if(m_pController)
    m_pController->onKeyPressed(3);
}

void CDoc::OnKey4()
{
  if(m_pController)
    m_pController->onKeyPressed(4);
}

void CDoc::OnKey5()
{
  if(m_pController)
    m_pController->onKeyPressed(5);
}

void CDoc::OnKey6()
{
  if(m_pController)
    m_pController->onKeyPressed(6);
}

void CDoc::OnKey7()
{
  if(m_pController)
    m_pController->onKeyPressed(7);
}

void CDoc::OnKey8()
{
  if(m_pController)
    m_pController->onKeyPressed(8);
}

void CDoc::OnKey9()
{
  if(m_pController)
    m_pController->onKeyPressed(9);
}

void CDoc::OnKeyDec()
{
  if(m_pController)
    m_pController->onKeyPressed(10);
}
