// SimRobXP.h : main header file for the SIMROB95 application
//

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#ifdef GetObject
#undef GetObject
#endif
#include "resource.h"       // main symbols

#include "..\GuiLib\GuiLib.h"
#include "..\GuiLib\WinAppEx.h"

/////////////////////////////////////////////////////////////////////////////
// CApp:
// See SimRobXP.cpp for the implementation of this class
//

class CChild : public CMDIChildWnd
{
private:
  DECLARE_DYNCREATE(CChild)
  static BOOL m_bTranslateChars;
public:
  CChild() {m_bTranslateChars = TRUE;}
  virtual BOOL PreTranslateMessage(MSG* pMsg)
  {
    if(m_bTranslateChars || pMsg->message != WM_KEYDOWN)
      return CMDIChildWnd::PreTranslateMessage(pMsg);
    return FALSE;
  }
  static void TranslateChars(BOOL b) {m_bTranslateChars = b;}
};

class CApp : public CWinAppEx
{
private:
  CMultiDocTemplate* m_pDocTemplate,
                   * m_pTreeTemplate,
                   * m_pObjectTemplate,
                   * m_pSensorTemplate,
                   * m_pActuatorTemplate;
  CWnd** m_pWnd;
  int m_nWindows;
public:
  void SetOrder(CWnd** pWnd,int nWindows) {m_pWnd = pWnd; m_nWindows = nWindows;}
  void CreateTree(CDocument* pDoc);
  void CreateObject(CDocument* pDoc);
  void CreateSensor(CDocument* pDoc);
  void CreateActuator(CDocument* pDoc);
  void HelpOnKeyword(const char* pKeyword);
public:
  CApp();

// Overrides
  // ClassWizard generated virtual function overrides
  //{{AFX_VIRTUAL(CApp)
  public:
  virtual BOOL InitInstance();
  virtual CDocument* OpenDocumentFile(LPCTSTR lpszFileName);
  virtual int ExitInstance();
  //}}AFX_VIRTUAL

// Implementation
  COleTemplateServer m_server;
    // Server object for document creation

  //{{AFX_MSG(CApp)
  afx_msg void OnAppAbout();
  afx_msg void OnFileNew();
  //}}AFX_MSG
  DECLARE_MESSAGE_MAP()
};


/////////////////////////////////////////////////////////////////////////////
