/**
 * @file Router/Router.h
 *
 * Declaration of class Router.
 *
 * @author <a href="mailto:roefer@tzi.de">Thomas Rfer</a>
 */

#ifndef __ROUTER_H__
#define __ROUTER_H__

#include "Tools/Debugging/QueueFillRequest.h"
#include "Tools/Process.h"
#include "Platform/Win32Linux/TcpConnection.h"
#include "CMUData.h"

class MessageQueue1 : public MessageQueue {};
class MessageQueue2 : public MessageQueue {};
class MessageQueue3 : public MessageQueue {};
class MessageQueue4 : public MessageQueue {};
class MessageQueue5 : public MessageQueue {};
class MessageQueue6 : public MessageQueue {};
class MessageQueue7 : public MessageQueue {};
class MessageQueue8 : public MessageQueue {};
class CMUData1 : public CMUData {};
class CMUData2 : public CMUData {};
class CMUData3 : public CMUData {};
class CMUData4 : public CMUData {};

#define QUEUE_SENDER(type) \
  MultiDebugSender<MessageQueue> the##type##Sender

/**
 * @class Router
 * Implements a router for MessageQueue packages between a robot and
 * RobotControl.
 */
class Router : public PlatformProcess, public MessageHandler
{
  private:
    RECEIVER(MessageQueue1);
    QUEUE_SENDER(MessageQueue1);
    RECEIVER(MessageQueue2);
    QUEUE_SENDER(MessageQueue2);
    RECEIVER(MessageQueue3);
    QUEUE_SENDER(MessageQueue3);
    RECEIVER(MessageQueue4);
    QUEUE_SENDER(MessageQueue4);
    RECEIVER(MessageQueue5);
    QUEUE_SENDER(MessageQueue5);
    RECEIVER(MessageQueue6);
    QUEUE_SENDER(MessageQueue6);
    RECEIVER(MessageQueue7);
    QUEUE_SENDER(MessageQueue7);
    RECEIVER(MessageQueue8);
    QUEUE_SENDER(MessageQueue8);

    RECEIVER(CMUData1);
    SENDER(CMUData1);
    RECEIVER(CMUData2);
    SENDER(CMUData2);
    RECEIVER(CMUData3);
    SENDER(CMUData3);
    RECEIVER(CMUData4);
    SENDER(CMUData4);

    List<CMUData> cmuData1,
                  cmuData2,
                  cmuData3,
                  cmuData4;

    int numOfRobots; /**< The number of robots the router is connected to. */
    TcpConnection* tcp[8]; /**< The tcp connections. */
    MessageQueue* receiver[8], /**< Pointers to the receivers. */
                * sender[8]; /**< Pointers to the senders. */
    QueueFillRequest queueFillRequest; /**< The request decides whether to drop double packages or not. */

    bool handleMessage(InMessage& queue);

    void handleCMUMessages();

 public:
    /**
     * Constructor.
     */
    Router();

    /**
     * Destructor.
     */
    ~Router();

    /** 
     * The main function is called from the process framework once in each frame. 
     * @return If 0 is returned, the function main will not be called on a timed basis
     *         again. A positive number specifies the minimum number of microseconds to
     *         wait before the next frame starts. A negative number specifies a cycle 
     *         time, i.e. the time between two activations of the main() function.
     */
    int processMain();
};

#endif

/*
 * Change log :
 * 
 * $Log: Router.h,v $
 * Revision 1.1.1.1  2004/05/22 17:33:50  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2003/10/07 10:11:08  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.3  2003/09/26 11:41:17  juengel
 * - sorted tools
 * - clean-up in DataTypes
 *
 * Revision 1.2  2003/08/17 18:35:37  roefer
 * Communication with router standardized and synchronized
 *
 * Revision 1.1.1.1  2003/07/02 09:40:27  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2003/05/29 19:36:39  roefer
 * Support for CMU added
 *
 * Revision 1.1  2002/09/10 15:52:17  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.6  2002/08/01 12:52:27  roefer
 * RouterCtrl and TcpConnection added
 *
 * Revision 1.5  2002/07/23 13:46:06  loetzsch
 * - new streaming classes
 *
 * Revision 1.4  2002/06/09 10:26:15  Thomas Rfer
 * Multi router
 *
 * Revision 1.3  2002/05/28 16:16:36  roefer
 * Sender for GameControlData removed
 *
 * Revision 1.2  2002/05/25 22:52:18  roefer
 * WLan, first working approach
 *
 * Revision 1.1.1.1  2002/05/10 12:40:27  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.2  2002/05/02 18:11:11  roefer
 * New router
 *
 *
 */
