/**
 * @file CMUData/CMUData.h
 *
 * Declaration of class CMUData.
 *
 * @author <a href="mailto:roefer@tzi.de">Thomas Rfer</a>
 */

#ifndef __CMUDATA_H__
#define __CMUDATA_H__

#include "Tools/Streams/InOut.h"

class CMUData;

Out& operator<<(Out& stream, const CMUData& data);
In& operator>>(In& stream, CMUData& data);

class CMUData
{
  private:
    char* data; /**< All data but the first two bytes. */
    unsigned short size; /**< The size of the original package. */

  public:
    /** Constructor. */
    CMUData() {size = 0;}

    /** Copy constructor. */
    CMUData(const CMUData& other) {size = 0; *this = other;}

    /** Destructor. */
    ~CMUData() {if(size) delete [] data;}

    CMUData& operator=(const CMUData& other)
    {
      if(size) 
        delete [] data;
      size = other.size;
      data = new char[size - 2];
      memcpy(data, other.data, size - 2);
    }

    bool isEmpty() const {return size == 0;}

  friend Out& operator<<(Out& stream, const CMUData& data);
  friend In& operator>>(In& stream, CMUData& data);
};

inline Out& operator<<(Out& stream, const CMUData& data)
{
  stream << data.size;
  stream.write(data.data, data.size - 2);
  return stream;
}

inline In& operator>>(In& stream, CMUData& data)
{
  if(data.size)
    delete [] data.data;
  stream >> data.size;
  data.data = new char[data.size - 2];
  stream.read(data.data, data.size - 2);
  return stream;
}

#endif

/*
 * Change log :
 * 
 * $Log: CMUData.h,v $
 * Revision 1.1.1.1  2004/05/22 17:33:50  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2003/10/07 10:11:08  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:27  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.1  2003/05/29 19:36:39  roefer
 * Support for CMU added
 *
 */
