/** 
* @file DebugDrawingManagerUI.cpp
* Implementation of class DebugDrawingManagerUI.
*
* @author <a href="mailto:juengel@informatik.hu-berlin.de">Matthias Jngel</a>
*/

#include "StdAfx.h"

#include "DebugDrawingManagerUI.h"
#include "DebugDrawingManager.h"

#include "RobotControl.h"

void DebugDrawingManagerUI::showContextMenu
(
 DrawingPapers::FieldDrawingPaper drawingPaper,
 CPoint point,
 CFrameWnd* pParent
 )
{
  CMenu menu;
  VERIFY( menu.CreatePopupMenu() );
  
  UINT nFlags = 0;
  DebugDrawingManager& debugDrawingManager = getRobotControlApp().pMainFrame->debugDrawingManager;
  
  int i;
  // add possible and shown drawings
  for(i = 0; i < Drawings::numberOfFieldDrawings; i++)
  {
    Drawings::FieldDrawing drawing = (Drawings::FieldDrawing)i;
    if (debugDrawingManager.isDrawingShownOnDrawingPaper(drawingPaper, drawing))
    {
      nFlags = MF_CHECKED;
    }
    else
    {
      nFlags = 0;
    }
    
    if (drawing < Drawings::firstDrawingInRadarViewer)
    {
      VERIFY( menu.AppendMenu( MF_BYCOMMAND | nFlags,
        i + 10, Drawings::getDrawingName(drawing)) );
    }
  }
  
  // Separator
  UINT nBars = menu.GetMenuItemCount();
  VERIFY( menu.InsertMenu( nBars, MF_BYPOSITION | MF_SEPARATOR ) );
  
  VERIFY( menu.AppendMenu( MF_BYCOMMAND,
    1000, "Copy drawings") );
  
  // Separator
  nBars = menu.GetMenuItemCount();
  VERIFY( menu.InsertMenu( nBars, MF_BYPOSITION | MF_SEPARATOR ) );
  
  if (debugDrawingManager.isAutoRotateEnabled(drawingPaper))
  {
    nFlags = MF_CHECKED;
  }
  else
  {
    nFlags = 0;
  }
  VERIFY( menu.AppendMenu( MF_BYCOMMAND | nFlags, 3000, "auto rotate") );
  
  VERIFY( menu.AppendMenu( MF_BYCOMMAND, 4000, "rotate") );
  
  // Track menu
  //    CWinAppEx::GetInstance()->SetMenuIcons( &menu, true );
  UINT nID = menu.TrackPopupMenu( TPM_LEFTALIGN | TPM_RIGHTBUTTON | TPM_RETURNCMD | TPM_NONOTIFY,
    point.x, point.y, pParent );
  
  if(10 <= nID && nID < Drawings::numberOfFieldDrawings + 10)
  {
    debugDrawingManager.showDrawingOnDrawingPaper(
      drawingPaper, 
      (Drawings::FieldDrawing)(nID - 10), 
      !debugDrawingManager.isDrawingShownOnDrawingPaper(drawingPaper, (Drawings::FieldDrawing)(nID - 10))
      );
  }
  if(nID == 1000)
  {
    debugDrawingManager.copyDrawingPaperToClipBoard(drawingPaper);
  }
  
  if(nID == 3000)
  {
    debugDrawingManager.enableAutoRotate(
      drawingPaper,
      !debugDrawingManager.isAutoRotateEnabled(drawingPaper));
  }
  if(nID == 4000)
  {
    debugDrawingManager.rotate(drawingPaper);
  }
}



void DebugDrawingManagerUI::showContextMenu
(
 DrawingPapers::ImageDrawingPaper drawingPaper,
 CPoint point,
 CFrameWnd* pParent
 )
{
  CMenu menu;
  VERIFY( menu.CreatePopupMenu() );
  
  UINT nFlags = 0;
  DebugDrawingManager& debugDrawingManager = getRobotControlApp().pMainFrame->debugDrawingManager;
  
  if (debugDrawingManager.getHighRes(drawingPaper))
    nFlags = MF_CHECKED;
  else
    nFlags = 0;
  VERIFY( menu.AppendMenu( MF_BYCOMMAND | nFlags,
    3000, "High resolution") );

  // Separator
  UINT nBars = menu.GetMenuItemCount();
  VERIFY( menu.InsertMenu( nBars, MF_BYPOSITION | MF_SEPARATOR ) );
  
  int i;
  // add possible and shown drawings
  for(i = 0; i < Drawings::numberOfImageDrawings; i++)
  {
    Drawings::ImageDrawing drawing = (Drawings::ImageDrawing)i;
    if (debugDrawingManager.isDrawingShownOnDrawingPaper(drawingPaper, drawing))
    {
      nFlags = MF_CHECKED;
    }
    else
    {
      nFlags = 0;
    }
    
    VERIFY( menu.AppendMenu( MF_BYCOMMAND | nFlags,
      i + 10, Drawings::getDrawingName(drawing)) );
    
  }
  
  // Separator
  nBars = menu.GetMenuItemCount();
  VERIFY( menu.InsertMenu( nBars, MF_BYPOSITION | MF_SEPARATOR ) );
  
  VERIFY( menu.AppendMenu( MF_BYCOMMAND,
    1000, "Copy drawings") );
  
  // Separator
  nBars = menu.GetMenuItemCount();
  VERIFY( menu.InsertMenu( nBars, MF_BYPOSITION | MF_SEPARATOR ) );
  
  // add possible images and selected image
  for(i = 0; i < numberOfImageIDs; i++)
  {
    ImageID image = (ImageID)i;
    if (debugDrawingManager.getImageID(drawingPaper) == image)
      nFlags = MF_CHECKED;
    else nFlags = 0;
    
    VERIFY( menu.AppendMenu( MF_BYCOMMAND | nFlags,
      i + 100, Images::getImageIDName(image)) );
    
  }
  // Separator
  nBars = menu.GetMenuItemCount();
  VERIFY( menu.InsertMenu( nBars, MF_BYPOSITION | MF_SEPARATOR ) );

    if (debugDrawingManager.getSendDebugImagesFromRobot()) nFlags = MF_CHECKED;
    else nFlags = 0;
  VERIFY( menu.AppendMenu( MF_BYCOMMAND | nFlags,
    900, "debug images from robot") );

  // Separator
  nBars = menu.GetMenuItemCount();
  VERIFY( menu.InsertMenu( nBars, MF_BYPOSITION | MF_SEPARATOR ) );
  
  VERIFY( menu.AppendMenu( MF_BYCOMMAND,
    2000, "Copy image and Drawings") );
  
  
  // Track menu
  //    CWinAppEx::GetInstance()->SetMenuIcons( &menu, true );
  UINT nID = menu.TrackPopupMenu( TPM_LEFTALIGN | TPM_RIGHTBUTTON | TPM_RETURNCMD | TPM_NONOTIFY,
    point.x, point.y, pParent );
  
  if(10 <= nID && nID < Drawings::numberOfImageDrawings + 10)
  {
    debugDrawingManager.showDrawingOnDrawingPaper(
      drawingPaper, 
      (Drawings::ImageDrawing)(nID - 10), 
      !debugDrawingManager.isDrawingShownOnDrawingPaper(drawingPaper, (Drawings::ImageDrawing)(nID - 10))
      );
  }
  
  else if(100 <= nID &&
    nID < numberOfImageIDs + 100)
  {
    ImageID selectedImage = (ImageID)(nID - 100);
    debugDrawingManager.setImageID(
      drawingPaper, 
      selectedImage
      );
  }
  
  else if(nID == 1000)
  {
    debugDrawingManager.copyDrawingPaperToClipBoard(drawingPaper);
  }
  
  else if(nID == 2000)
  {
    debugDrawingManager.copyImageToClipBoard(drawingPaper);
  }

  else if(nID == 900)
  {
    debugDrawingManager.setSendDebugImagesFromRobot(
      !debugDrawingManager.getSendDebugImagesFromRobot());
  }

  else if(nID == 3000)
  {
    debugDrawingManager.setHighRes(drawingPaper,
      !debugDrawingManager.getHighRes(drawingPaper));
  }
}
 
 
 
 
/*
* Change log :
* 
* $Log: DebugDrawingManagerUI.cpp,v $
* Revision 1.1.1.1  2004/05/22 17:30:19  cvsadm
* created new repository GT2004_WM
*
* Revision 1.4  2004/04/07 13:00:46  risler
* ddd checkin after go04 - second part
*
* Revision 1.2  2004/04/06 13:19:37  risler
* cleaned up and improved high resolution image support
*
* Revision 1.1.1.1  2004/03/29 08:28:43  Administrator
* initial transfer from tamara
*
* Revision 1.3  2004/02/07 15:45:48  juengel
* Removed RadarViewer stuff.
*
* Revision 1.2  2003/11/03 20:16:09  juengel
* color class images can be sent from robot now
*
* Revision 1.1  2003/10/07 10:11:08  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:27  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.6  2003/05/11 23:32:41  dueffert
* Depend now works with RobotControl too
*
* Revision 1.5  2003/03/22 22:37:52  loetzsch
* finished GUI and message routing for 8 simulated robots
* almost all functionallity for simulated robots now is encapsulated in class
*   CRobotControlSimulatedRobots
*
* Revision 1.4  2002/11/12 10:49:02  juengel
* New debug drawing macros - second step
* -moved /Tools/Debugging/PaintMethods.h and . cpp
*  to /Visualization/DrawingMethods.h and .cpp
* -moved DebugDrawing.h and .cpp from /Tools/Debugging/
*  to /Visualization
*
* Revision 1.3  2002/10/10 11:41:03  juengel
* First clean up in DebugDrawingManager
*
* Revision 1.2  2002/09/20 23:28:34  juengel
* Moved instance of DebugDrawingManager to RobotControlMainFrame.
*
* Revision 1.1  2002/09/10 15:49:12  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
*
*/
