/**
* @file DebugDrawingManagerMessageHandler.h
*
* Declaration class DebugDrawingManagerMessageHandler.
*
* @author Martin Ltzsch
*/

#ifndef __DebugDrawingManagerMessageHandler_h_
#define __DebugDrawingManagerMessageHandler_h_

#include "Tools/MessageQueue/InMessage.h"
#include "../DrawingMethods.h"

class DebugDrawingManager;

/** 
* @class DebugDrawingManagerMessageHandler.
*
* Handles debug messages for the debug drawing manager.
*
* @author Martin Ltzsch
*/
class DebugDrawingManagerMessageHandler : public MessageHandler
{
public:
  /** Constructor */
  DebugDrawingManagerMessageHandler(DebugDrawingManager& debugDrawingManager);
  
  /** 
  * Called from a MessageQueue to distribute messages 
  * @param message The message that can be read.
  * @return true if the message was read (handled).
  */
  virtual bool handleMessage(InMessage& message);
  
private:
  /** A reference to the debug drawing manager */
  DebugDrawingManager& debugDrawingManager;
  
  /** Field drawings of the last received world state of each robot */
  DebugDrawing worldStateFieldDrawing[8]; 
  
  /** Field drawings of the last received obstacles model of each robot */
  DebugDrawing obstaclesModelFieldDrawing[8]; 
  
  /** Field drawings of the last received percepts model of each robot */
  DebugDrawing perceptsFieldDrawing[8]; 
  
  /** The last received robot pose of each robot */
  RobotPose robotPoses[8];
  
  /** The time when the last world state was received for each robot */
  unsigned long timeWhenLastWorldStateReceived[8]; 
  
  /** The time when the last percepts were received for each robot */
  unsigned long timeWhenLastPerceptsReceived[8]; 
  
  /** The team color of the last message which was received from a selected robot */
  Player::teamColor teamColorOfSelectedRobot;
  
  /** Repaints the field in the field view */
  void repaintField();
};



#endif //__DebugDrawingManagerMessageHandler_h_

/*
* Change Log:
*
* $Log: DebugDrawingManagerMessageHandler.h,v $
* Revision 1.1.1.1  2004/05/22 17:30:19  cvsadm
* created new repository GT2004_WM
*
* Revision 1.2  2003/12/09 18:13:53  loetzsch
* Moved prepainted instances for fieldlines and field polygons from
* DebugDrawingManagerMessageHAndler to DebugDrawingManager
*
* Revision 1.1  2003/12/07 19:04:11  loetzsch
* The message handling for the debug drawing manager is now done in a
* separate class.
*
* In the field view, world states and percepts from up to 8 robots are displayed.
*
*/
