/** 
* @file DebugDrawingManagerEnums.h
* Contains class DrawingPapers.
* @author <a href="mailto:juengel@informatik.hu-berlin.de">Matthias Jngel</a>
*/

#ifndef __DebugDrawingManagerEnums_h_
#define __DebugDrawingManagerEnums_h_

#include "StdAfx.h"

/** A class that declares ids for drawing papers. */
class DrawingPapers
{
public:
  
/** IDs for field drawing papers.
* enter new drawing papers here and add the corresponding string in getDrawingPaperName.
  */
  enum FieldDrawingPaper
  {
    mainWindow, /** the main window of the RobotControl Application */
      numberOfFieldDrawingPapers
  };

  /**
  * Returns a description for an indexed drawing paper.
  * Add descriptions for new drawing papers here.
  */
  static CString getDrawingPaperName(FieldDrawingPaper drawingPaper)
  {
    switch (drawingPaper) 
    {
    case mainWindow: return "main window";
    default: return "paper without name";
    }
  }


  /**
  * IDs for drawing papers with image.
  * enter new drawing papers here and add the corresponding string in getDrawingPaperWithImageName.
  */
  enum ImageDrawingPaper
  {
    largeImageViewer,
      imageViewer1,
      imageViewer2,
      imageViewer3,
      imageViewer4,
      imageViewer5,
      imageViewer6,
      imageViewer7,
      imageViewer8,
      imageProcessorTester,
      numberOfImageDrawingPapers
  };
  
  /**
  * Returns a description for an indexed drawing paper.
  * Add descriptions for new drawing papers here.
  */
  static CString getDrawingPaperName(ImageDrawingPaper drawingPaper)
  {
    switch (drawingPaper) 
    {
    case DrawingPapers::imageViewer1: return "image viewer 1";
    case DrawingPapers::imageViewer2: return "image viewer 2";
    case DrawingPapers::imageViewer3: return "image viewer 3";
    case DrawingPapers::imageViewer4: return "image viewer 4";
    case DrawingPapers::imageViewer5: return "image viewer 5";
    case DrawingPapers::imageViewer6: return "image viewer 6";
    case DrawingPapers::imageViewer7: return "image viewer 7";
    case DrawingPapers::imageViewer8: return "image viewer 8";
    case DrawingPapers::largeImageViewer: return "largeImageViewer";
    case DrawingPapers::imageProcessorTester: return "imageProcessorTester";
    default: return "paper without name";
    }
  }
};

#endif //DebugDrawingManagerEnums_h





/*
* Change log :
* 
* $Log: DebugDrawingManagerEnums.h,v $
* Revision 1.1.1.1  2004/05/22 17:30:19  cvsadm
* created new repository GT2004_WM
*
* Revision 1.2  2004/02/07 15:45:48  juengel
* Removed RadarViewer stuff.
*
* Revision 1.1  2003/10/07 10:11:08  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.2  2003/08/25 17:23:34  juengel
* ImageViewer displays 8 images now.
*
* Revision 1.1.1.1  2003/07/02 09:40:27  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.5  2003/05/11 23:32:41  dueffert
* Depend now works with RobotControl too
*
* Revision 1.4  2002/11/20 13:37:31  dueffert
* missing or wrong doxygen file corrected
*
* Revision 1.3  2002/09/20 23:28:34  juengel
* Moved instance of DebugDrawingManager to RobotControlMainFrame.
*
* Revision 1.2  2002/09/19 23:38:54  juengel
* Changed debug image mechanisms.
*
* Revision 1.1  2002/09/10 15:49:12  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
*
* Revision 1.3  2002/06/21 13:45:18  juengel
* no message
*
* Revision 1.2  2002/05/15 12:20:38  juengel
* DebugDrawing for Pattern Analysis Challenge added.
*
* Revision 1.1.1.1  2002/05/10 12:40:27  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.6  2002/05/07 15:36:44  jhoffman
* added debugImage used in sub pixel gradient...
*
* Revision 1.5  2002/04/02 10:30:34  juengel
* GridImageProcessor enhanced.
*
* Revision 1.4  2002/02/10 12:45:15  loetzsch
* radar viewer and percept visualization continued
*
* Revision 1.3  2002/02/08 13:28:08  loetzsch
* Visualization of PerceptCollection and RadarViewer started
* (not implemented yet)
*
* Revision 1.2  2002/02/04 11:39:48  juengel
* ImageProcessorTester dialog added.
*
* Revision 1.1  2002/01/26 18:07:33  juengel
* no message
*
*
*/
