/**
* @file Controller.h
*
* Declaration of class VIEW, DIRECTVIEW, XCONTROLLER,
* CLICKINFO, CONTROLLER and CONNECTION
*/
#ifndef __CONTROLLER_H__
#define __CONTROLLER_H__

#include "StdAfx.h"

#undef GetObject


#include "SimRob95/SimRobot/sim3DSensors.h"

#include "SimRob95/SimRobot/sim3D.h"
#include "Representations/Perception/SensorData.h"


#define _PIDEFINED

//////////////////////////////////////////////////////////////////////////
// class VIEW

class VIEW : public SIM3DMultiSensor
{
  public:
    VIEW(const STRING& sName,INTEGER xSize = 1,INTEGER ySize = 1,
         INTEGER numClasses = 1);
    virtual ~VIEW() {};
    virtual void CalcView() = 0;
  private:
    STRING GetClass () {return "VIEW";}
    SIM3DElement* Copy() {return 0;}
    void Draw (GRAPHICPORT*, const MOVEMATRIX&, INTEGER, REAL) {};
    void CalcSensor();
};

//////////////////////////////////////////////////////////////////////////
// class DIRECTVIEW

const int S3DDirectView = 101;

class DIRECTVIEW : public VIEW
{
  public:
    DIRECTVIEW(const STRING& sName) 
    : VIEW(sName,1,1,1) {}
    virtual void DrawView(CDC& dc) = 0;
    virtual BOOLEAN IsA(INTEGER typ)
      {return (typ == S3DDirectView) || VIEW::IsA(typ);}
  private:
    virtual void CalcView() {}
};

//////////////////////////////////////////////////////////////////////////
// class XCONTROLLER


class XCONTROLLER
{
  public:
    enum TYPE
    {
      InvalidObject,
      InvalidSensorPort,
      InvalidActorPort
    };
    TYPE m_xType;
    STRING m_sName;
    XCONTROLLER(TYPE xType,const char* sName = 0) : m_sName(sName)
      {m_xType = xType;}
};

//////////////////////////////////////////////////////////////////////////
// class CLICKINFO

class CLICKINFO 
{
  private:
    SIM3DOBJECT m_obj;
    VECTOR m_v;
    MOVEMATRIX m_m,
               m_mY;
    double m_dZoom,
           m_dDist;
    int m_x,
        m_y;
  public:
    CLICKINFO(SIM3DOBJECT obj,const VECTOR& v,int x,int y,int nZoom,double dDist);
    double DistanceTo(SIM3DOBJECT obj) const;
    VECTOR GetClickPos() const {return m_v;}
    VECTOR SceneToScreenY(VECTOR v) const;
    int GetZ() const {return m_x;}
};

//////////////////////////////////////////////////////////////////////////
// class CONTROLLER

class CONTROLLER
{
  public:
    CONTROLLER();
    virtual ~CONTROLLER() {}
    virtual BOOLEAN SetActors(STRING& sMessage) {return TRUE;}
    virtual void OnDestroy() {}
    virtual void OnMouseClick(const CLICKINFO&) {}
    virtual void OnMouseDoubleClick(const CLICKINFO&) {}
    virtual void OnBeginDrag(const CLICKINFO&) {}
    virtual void OnDrag(const CLICKINFO&) {}
    virtual void OnEndDrag(const CLICKINFO&) {}
    virtual void OnKeyPressed(int) {}
    SENSORPORT AddView(VIEW* pView);
    ACTORPORT   GetActorPort     (const STRING& portname);
    SENSORPORT  GetSensorPort    (const STRING& portname);
    INTEGER     GetSensorDim     (SENSORPORT sp);
    INTEGER     GetSensorDimSize (SENSORPORT sp, INTEGER d);
    void        GetSensorValue   (SENSORPORT sp, PSHORTREAL value);
    void        SetActorValue    (ACTORPORT ap, REAL value);
    PSHORTREAL  NewSensorBuffer  (SENSORPORT sp);
    void        DeleteSensorBuffer (SENSORPORT sp, PSHORTREAL buffer);
    INTEGER     SensorPortCount  (SIM3DOBJECT obj);
    INTEGER     ActorPortCount   (SIM3DOBJECT obj);
    STRING      SensorPortName   (SIM3DOBJECT obj, INTEGER n);
    STRING      ActorPortName    (SIM3DOBJECT obj, INTEGER n);
    SIM3DOBJECT GetObject        (const STRING& name);
    STRING      ObjectName       (SIM3DOBJECT obj);
    STRING      ObjectRemark     (SIM3DOBJECT obj);
    STRING      ObjectClass      (SIM3DOBJECT obj);
    INTEGER     SubObjectCount   (SIM3DOBJECT obj);
    SIM3DOBJECT SubObject        (SIM3DOBJECT obj, INTEGER n);
    INTEGER     MacroCount       ();
    SIM3DOBJECT GetMacro         (INTEGER n);
    SIM3DOBJECT GetMacro         (const STRING&);
    SIM3DOBJECT AddMacroAs       (SIM3DOBJECT obj, const STRING& asname);
    void        RemoveObject     (SIM3DOBJECT obj);
    MOVEMATRIX  GetLocation      (SIM3DOBJECT obj);
    void        SetLocation      (SIM3DOBJECT obj, const MOVEMATRIX& m);
 
    /**
     * Activates or diactivates a certain switch on the robot.
     * @param sensor The switch. Allowed values are: headBack, headFront,
     *               mouth, chin, and back.
     * @param activate Decides whether to activate or deactivate the switch.
     */
    virtual void activateSwitch(SensorData::sensors sensor,bool activate = true) = 0;

    /**
     * The function checks whether a certain switch is activated.
     * @param sensor The switch to check.
     * @return Activated or not?
     */
    virtual bool isSwitchActivated(SensorData::sensors sensor) const = 0;

 private:
    SIMULATION* m_pSim;
    void Clean();
    void Check();
    INTEGER Check(INTEGER i);
    STRING Check(const STRING& s);
    SIM3DOBJECT Check(SIM3DOBJECT s);
    PSHORTREAL Check(PSHORTREAL p);
    MOVEMATRIX Check(const MOVEMATRIX& m);
};

//////////////////////////////////////////////////////////////////////////
// class CONNECTION

class CONNECTION
{
  public:
    char* m_pScene;
    CONNECTION* m_pNext;
    CONNECTION(char* pScene);
    virtual CONTROLLER* CreateController() = 0;
};

template <class T> class CONNECTIONTEMPLATE : public CONNECTION
{
  public:
    CONNECTIONTEMPLATE(char* pScene) : CONNECTION(pScene) {}
    CONTROLLER* CreateController() {return new T;}
};

#define CONNECT_CONTROLLER_TO_SCENE(ClassName,pScene) \
  CONNECTIONTEMPLATE<ClassName> dummy##ClassName(pScene);


#endif

/*
 * Change log:
 *
 * $Log: Controller.h,v $
 * Revision 1.1.1.1  2004/05/22 17:29:59  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2003/10/07 10:11:08  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.2  2003/09/26 15:28:24  juengel
 * Renamed DataTypes to representations.
 *
 * Revision 1.1.1.1  2003/07/02 09:40:26  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.5  2003/05/11 23:36:18  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.4  2003/03/28 11:37:31  timrie
 * Added changelog
 *
 */
