/**
* @file RobotControlPhysicalRobots.cpp 
*
* Implementation of class CRobotControlPhysicalRobots.
*
* @author Uwe Dffert
* @author Martin Ltzsch
*/

#include "StdAfx.h"
#include "RobotControlPhysicalRobots.h"
#include "RobotControl.h"
#include "Tools/Debugging/QueueFillRequest.h"

#include <stdlib.h>

CRobotControlPhysicalRobots::CRobotControlPhysicalRobots(): selectedRobot(-1)
{
   for (int i=0; i<8; i++)
   {
      debugConnection[i] = new CRobotControlDebugConnection(queueFromRobot[i],queueToRobot[i],getQueues().toGUI);
   }
}

CRobotControlPhysicalRobots::~CRobotControlPhysicalRobots()
{
	disconnect();
	for (int i=0; i<8 ; i++)
	{
		if (debugConnection[i]!=NULL) 
		{
			delete(debugConnection[i]);
		}
	}
}

void CRobotControlPhysicalRobots::setSelectedRobot(int robot)
{
    selectedRobot=robot;
}

int CRobotControlPhysicalRobots::getSelectedRobot() const
{
  return selectedRobot;
}

bool CRobotControlPhysicalRobots::isConnected(int robot) const
{
   return ( debugConnection[robot]->wLanIsConnected());
}
bool CRobotControlPhysicalRobots::isSomeoneConnected()
{
  int first=-1;
  int selectedRob=(selectedRobot==-1)?0:selectedRobot;
  for (int i=0;i<8;i++)
  {
    if (isConnected((selectedRob+i)%8))
    {
      first=((selectedRob+i)%8);
      break;
    }
  }
  if (selectedRobot!=first)
  {
    selectedRobot=first;
  }
  return (first!=-1);
}

void CRobotControlPhysicalRobots::connect(CRobotControlWLANConfiguration& config)
{

  
  for (int i=0;i<4;i++)
  {
    if (config.useRed[i] && !debugConnection[i]->wLanIsConnected())
	{
	   debugConnection[i]->wLanConnect(config.ipRed[i],0xA1BD);
    }
	if (!config.useRed[i] && debugConnection[i]->wLanIsConnected())
	{
	  debugConnection[i]->wLanDisconnect();
	}
    if (config.useBlue[i] && !debugConnection[i+4]->wLanIsConnected())
    {
      debugConnection[i+4]->wLanConnect(config.ipBlue[i],0xA1BD);
    }
	if (!config.useRed[i] && debugConnection[i]->wLanIsConnected())
	{
	  debugConnection[i+4]->wLanDisconnect();
	}
  }
}

void CRobotControlPhysicalRobots::disconnect()
{
  int i;
  for (i=0; i<8; i++)
  {
     debugConnection[i]->wLanDisconnect();
  }
}

void CRobotControlPhysicalRobots::onIdle()
{
  // SYNC_WITH(getRobotControlApp()); //without that people can modify queues.toAllPhysicalRobots during sending, so different robots get different subsets of messages, but all are deleted afterwards...
 /*
  for (int i=0;i<8;i++)
  {
    getQueues().toPhysical.allRobots.copyAllMessages(getQueues().toPhysical.robot[i]);
	
    CRobotControlWLanThread* wlanThread=i<4?wLanThreadRed[i]:wLanThreadBlue[i-4];
 
    if (wlanThread)
    {
      SYNC_WITH(*wlanThread);
    
      if (wlanThread->isRunning())
      {
        if (wlanThread->wlanIsConnected())
        {
          getQueues().toPhysical.robot[i].moveAllMessages(wlanThread->queueToRobot);
          if (getSelectedRobot() == i)
          {
            getQueues().toPhysical.selectedRobot.moveAllMessages(wlanThread->queueToRobot);
          }
        }
      }
    }
	
  }
 getQueues().toPhysical.allRobots.clear();
 */

  if (debugConnection[0] == NULL) return;

  for (int i=0; i<8; i++)
  {
	  if (debugConnection[i]->wLanIsConnected())
	  {
		  getQueues().toPhysical.allRobots.copyAllMessages(getQueues().toPhysical.robot[i]);
		  getQueues().toPhysical.robot[i].moveAllMessages(queueToRobot[i]);
		  if (getSelectedRobot() == i)
		  {
			  getQueues().toPhysical.selectedRobot.moveAllMessages(queueToRobot[i]);
			  debugConnection[i]->sendMessageQueue();
		  }
	  }
	  queueFromRobot[i].moveAllMessages(getQueues().fromPhysicalRobots);
  }
  getQueues().toPhysical.allRobots.clear();
  
}

CRobotControlPhysicalRobots& getPhysicalRobots()
{
  return getRobotControlApp().physicalRobots;
}

CRobotControlWLANConfiguration::CRobotControlWLANConfiguration()
{
  readFromProfile(99);
}

void CRobotControlWLANConfiguration::readFromProfile(int index)
{
  char entry[256];
  char test[256];
  sprintf(entry,"Name%d",index);
  strcpy(test,AfxGetApp()->GetProfileString("WLAN",entry,"there_is_no_old_config"));
  if (strcmp(test,"there_is_no_old_config")!=0)
  {
    HKEY rc;
    strcpy(name,test);
    RegOpenKey(HKEY_CURRENT_USER,"Software\\GermanTeam\\RobotControl\\WLAN",&rc);
    RegDeleteValue(rc,entry);
    
    sprintf(entry,"IP%d",index);
    strcpy(test,AfxGetApp()->GetProfileString("WLAN",entry,"127.0.0.1").GetBuffer(255));
    ipRedRouter=ntohl(inet_addr(test));
    ipBlueRouter=ipRedRouter;
    RegDeleteValue(rc,entry);
    
    sprintf(entry,"IPRobot%d",index);
    strcpy(test,AfxGetApp()->GetProfileString("WLAN",entry,"192.168.18.1").GetBuffer(255));
    ipRed[0]=ntohl(inet_addr(test));
    ipRed[1]=0;
    ipRed[2]=0;
    ipRed[3]=0;
    ipBlue[0]=0;
    ipBlue[1]=0;
    ipBlue[2]=0;
    ipBlue[3]=0;
    useRed[0]=true;
    useRed[1]=false;
    useRed[2]=false;
    useRed[3]=false;
    useBlue[0]=false;
    useBlue[1]=false;
    useBlue[2]=false;
    useBlue[3]=false;
    RegDeleteValue(rc,entry);
    
    sprintf(entry,"PortTo%d",index);
    portRedRouter = AfxGetApp()->GetProfileInt("WLAN",entry,15043);
    portBlueRouter = portRedRouter;
    RegDeleteValue(rc,entry);
    
    sprintf(entry,"Channel%d",index);
    channelRed = AfxGetApp()->GetProfileInt("WLAN",entry,3);
    channelBlue = channelRed;
    RegDeleteValue(rc,entry);
    
    sprintf(entry,"APMode%d",index);
    apmodeRed = AfxGetApp()->GetProfileInt("WLAN",entry,2);
    apmodeBlue = apmodeRed;
    RegDeleteValue(rc,entry);
    
    sprintf(entry,"WepKey%d",index);
    strcpy(wepkeyRed,AfxGetApp()->GetProfileString("WLAN",entry,""));
    strcpy(wepkeyBlue,wepkeyRed);
    RegDeleteValue(rc,entry);
    
    sprintf(entry,"NetMask%d",index);
    strcpy(test,AfxGetApp()->GetProfileString("WLAN",entry,"255.255.0.0").GetBuffer(255));
    netmaskRed=ntohl(inet_addr(test));
    netmaskBlue = netmaskRed;
    RegDeleteValue(rc,entry);
    
    sprintf(entry,"ESSID%d",index);
    strcpy(essidRed ,AfxGetApp()->GetProfileString("WLAN",entry,"SONY_LEGGED_A"));
    strcpy(essidBlue,essidRed);
    RegDeleteValue(rc,entry);
    
    sprintf(entry,"AutoIP%d",index); RegDeleteValue(rc,entry);
    sprintf(entry,"ChangeStick%d",index); RegDeleteValue(rc,entry);
    sprintf(entry,"UseRouter%d",index); RegDeleteValue(rc,entry);
    sprintf(entry,"PortFrom%d",index); RegDeleteValue(rc,entry);

    writeToProfile(index);
  }
  else
  {
    char path[256];
    sprintf(path,"WLAN\\Configuration%02i",index);
    strcpy(name,AfxGetApp()->GetProfileString(path,"Name","unnamed"));
    ipRedRouter=AfxGetApp()->GetProfileInt(path,"IPRedRouter",0x7f000001);
    ipBlueRouter=AfxGetApp()->GetProfileInt(path,"IPBlueRouter",0x7f000001);
    portRedRouter=AfxGetApp()->GetProfileInt(path,"PortRedRouter",15000);
    portBlueRouter=AfxGetApp()->GetProfileInt(path,"PortBlueRouter",15000);
    autostartRed=(AfxGetApp()->GetProfileInt(path,"AutostartRed",0)==1);
    autostartBlue=(AfxGetApp()->GetProfileInt(path,"AutostartBlue",0)==1);
    ipRed[0]=AfxGetApp()->GetProfileInt(path,"IPRed1",0x0a000064);
    ipRed[1]=AfxGetApp()->GetProfileInt(path,"IPRed2",0x0a000065);
    ipRed[2]=AfxGetApp()->GetProfileInt(path,"IPRed3",0x0a000066);
    ipRed[3]=AfxGetApp()->GetProfileInt(path,"IPRed4",0x0a000067);
    ipBlue[0]=AfxGetApp()->GetProfileInt(path,"IPBlue1",0x0a00006e);
    ipBlue[1]=AfxGetApp()->GetProfileInt(path,"IPBlue2",0x0a00006f);
    ipBlue[2]=AfxGetApp()->GetProfileInt(path,"IPBlue3",0x0a000070);
    ipBlue[3]=AfxGetApp()->GetProfileInt(path,"IPBlue4",0x0a000071);
    useRed[0]=(AfxGetApp()->GetProfileInt(path,"UseRed1",0)==1);
    useRed[1]=(AfxGetApp()->GetProfileInt(path,"UseRed2",0)==1);
    useRed[2]=(AfxGetApp()->GetProfileInt(path,"UseRed3",0)==1);
    useRed[3]=(AfxGetApp()->GetProfileInt(path,"UseRed4",0)==1);
    useBlue[0]=(AfxGetApp()->GetProfileInt(path,"UseBlue1",0)==1);
    useBlue[1]=(AfxGetApp()->GetProfileInt(path,"UseBlue2",0)==1);
    useBlue[2]=(AfxGetApp()->GetProfileInt(path,"UseBlue3",0)==1);
    useBlue[3]=(AfxGetApp()->GetProfileInt(path,"UseBlue4",0)==1);
    strcpy(essidRed,AfxGetApp()->GetProfileString(path,"ESSIDRed","SONY_LEGGED_A"));
    strcpy(essidBlue,AfxGetApp()->GetProfileString(path,"ESSIDBlue","SONY_LEGGED_B"));
    netmaskRed=AfxGetApp()->GetProfileInt(path,"NetMaskRed",0xffffff00);
    netmaskBlue=AfxGetApp()->GetProfileInt(path,"NetMaskBlue",0xffffff00);
    apmodeRed=AfxGetApp()->GetProfileInt(path,"APModeRed",2);
    apmodeBlue=AfxGetApp()->GetProfileInt(path,"APModeBlue",2);
    channelRed=AfxGetApp()->GetProfileInt(path,"ChannelRed",3);
    channelBlue=AfxGetApp()->GetProfileInt(path,"ChannelBlue",3);
    strcpy(wepkeyRed,AfxGetApp()->GetProfileString(path,"WEPKeyRed",""));
    strcpy(wepkeyBlue,AfxGetApp()->GetProfileString(path,"WEPKeyBlue",""));
    strcpy(teamIdentifierRed,AfxGetApp()->GetProfileString(path,"TeamIdentifierRed","undefRed"));
    strcpy(teamIdentifierBlue,AfxGetApp()->GetProfileString(path,"TeamIdentifierBlue","undefBlue"));
  }
}

void CRobotControlWLANConfiguration::writeToProfile(int index)
{
  char path[256];
  sprintf(path,"WLAN\\Configuration%02i",index);
  AfxGetApp()->WriteProfileString(path,"Name",name);
  AfxGetApp()->WriteProfileInt(path,"IPRedRouter",ipRedRouter);
  AfxGetApp()->WriteProfileInt(path,"IPBlueRouter",ipBlueRouter);
  AfxGetApp()->WriteProfileInt(path,"PortRedRouter",portRedRouter);
  AfxGetApp()->WriteProfileInt(path,"PortBlueRouter",portBlueRouter);
  AfxGetApp()->WriteProfileInt(path,"AutostartRed", autostartRed?1:0);
  AfxGetApp()->WriteProfileInt(path,"AutostartBlue", autostartBlue?1:0);
  AfxGetApp()->WriteProfileInt(path,"IPRed1",ipRed[0]);
  AfxGetApp()->WriteProfileInt(path,"IPRed2",ipRed[1]);
  AfxGetApp()->WriteProfileInt(path,"IPRed3",ipRed[2]);
  AfxGetApp()->WriteProfileInt(path,"IPRed4",ipRed[3]);
  AfxGetApp()->WriteProfileInt(path,"IPBlue1",ipBlue[0]);
  AfxGetApp()->WriteProfileInt(path,"IPBlue2",ipBlue[1]);
  AfxGetApp()->WriteProfileInt(path,"IPBlue3",ipBlue[2]);
  AfxGetApp()->WriteProfileInt(path,"IPBlue4",ipBlue[3]);
  AfxGetApp()->WriteProfileInt(path,"UseRed1",useRed[0]?1:0);
  AfxGetApp()->WriteProfileInt(path,"UseRed2",useRed[1]?1:0);
  AfxGetApp()->WriteProfileInt(path,"UseRed3",useRed[2]?1:0);
  AfxGetApp()->WriteProfileInt(path,"UseRed4",useRed[3]?1:0);
  AfxGetApp()->WriteProfileInt(path,"UseBlue1",useBlue[0]?1:0);
  AfxGetApp()->WriteProfileInt(path,"UseBlue2",useBlue[1]?1:0);
  AfxGetApp()->WriteProfileInt(path,"UseBlue3",useBlue[2]?1:0);
  AfxGetApp()->WriteProfileInt(path,"UseBlue4",useBlue[3]?1:0);
  AfxGetApp()->WriteProfileString(path,"ESSIDRed",essidRed);
  AfxGetApp()->WriteProfileString(path,"ESSIDBlue",essidBlue);
  AfxGetApp()->WriteProfileInt(path,"NetMaskRed",netmaskRed);
  AfxGetApp()->WriteProfileInt(path,"NetMaskBlue",netmaskBlue);
  AfxGetApp()->WriteProfileInt(path,"APModeRed",apmodeRed);
  AfxGetApp()->WriteProfileInt(path,"APModeBlue",apmodeBlue);
  AfxGetApp()->WriteProfileInt(path,"ChannelRed",channelRed);
  AfxGetApp()->WriteProfileInt(path,"ChannelBlue",channelBlue);
  AfxGetApp()->WriteProfileString(path,"WEPKeyRed",wepkeyRed);
  AfxGetApp()->WriteProfileString(path,"WEPKeyBlue",wepkeyBlue);
  AfxGetApp()->WriteProfileString(path,"TeamIdentifierRed",teamIdentifierRed);
  AfxGetApp()->WriteProfileString(path,"TeamIdentifierBlue",teamIdentifierBlue);
}

void CRobotControlWLANConfiguration::deleteProfile(int index)
{
  char key[256];
  sprintf(key,"Configuration%02i",index);
  HKEY rc;
  RegOpenKey(HKEY_CURRENT_USER,"Software\\GermanTeam\\RobotControl\\WLAN",&rc);
  RegDeleteKey(rc,key);
  RegCloseKey(rc);
}

/*
* Change Log:
*
* $Log: RobotControlPhysicalRobots.cpp,v $
* Revision 1.2  2004/06/08 11:55:07  wachter
* Robot control now uses asyncrhonous communication with CAsyncSocket instead of wlan-threds now.
*
* Revision 1.1.1.1  2004/05/22 17:26:51  cvsadm
* created new repository GT2004_WM
*
* Revision 1.10  2004/01/27 23:20:23  wachter
* Added  teamIdentifier to WLANConfigurationDialog
*
* Revision 1.9  2004/01/04 19:06:12  wachter
* Moved connect(..) into WLan-thread.
*
* Revision 1.8  2004/01/03 19:16:29  wachter
* - Debug-communication without router working now
* - Router-IP not longer needed
*
* Revision 1.7  2003/12/15 11:34:14  juengel
* Initialized sendData.
*
* Revision 1.6  2003/12/13 11:32:06  loetzsch
* renamed WLANConfiguration to CRobotControlWLANConfiguration
* and moved to RobotControlPhysicalRobots.h
*
* Revision 1.5  2003/12/09 20:27:52  loetzsch
* sending of messages to specific robots improved
*
* Revision 1.4  2003/12/09 19:49:24  loetzsch
* Renamed some of the main queues of RobotControl.
*
* Added possibility to send messages to specific simulated or physical robots.
*
* Revision 1.3  2003/12/07 18:57:34  loetzsch
* all messages but not only from the selected robot are sent to the "queue from physical robot"
*
* Revision 1.2  2003/12/04 00:52:05  loetzsch
* small beautification
*
* Revision 1.1  2003/10/07 10:09:37  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.3  2003/09/26 11:40:12  juengel
* - sorted tools
* - clean-up in DataTypes
*
* Revision 1.2  2003/08/17 18:35:37  roefer
* Communication with router standardized and synchronized
*
* Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.6  2003/05/11 23:51:02  dueffert
* Depend now works with RobotControl too
*
* Revision 1.5  2003/04/14 16:15:37  loetzsch
* ATH after GermanOpen CVS merge
* bug fix
*
* Revision 1.2  2003/04/10 22:53:13  dueffert
* blue4 connection bug fixed
*
* Revision 1.1.1.1  2003/04/09 14:22:42  loetzsch
* started Aibo Team Humboldt's GermanOpen CVS
*
* Revision 1.4  2003/03/28 14:04:19  dueffert
* team wlan support improved
*
* Revision 1.3  2003/03/25 12:48:43  loetzsch
* moved the variable wlanHeartbeatInterval from RobotControl.h
* to RobotControlPhysicalRobots.cpp
*
* Revision 1.2  2003/03/25 11:46:53  dueffert
* team wlan support improved
*
* Revision 1.1  2003/03/24 14:06:51  loetzsch
* added class CRobotControlPhysicalRobot
*
*/
