/**
* @file RobotControlMessageHandler.h
*
* Declaration of the main MessageHandler derivates in the RobotControl application.
*
* @author Martin Ltzsch
*/

#ifndef __RobotControlMessageHandler_h_
#define __RobotControlMessageHandler_h_

#include "Tools/MessageQueue/InMessage.h"

// class prototype to avoid inclusion of "RobotControlMainFrame.h"
class CRobotControlMainFrame;

/** 
* @class CMessageHandlerForQueueFromPhysicalRobots.
*
* Handles debug messages from the physical robots.
*
* @author Martin Ltzsch
*/
class CMessageHandlerForQueueFromPhysicalRobots : public MessageHandler
{
public:
/** 
* Called from a MessageQueue to distribute messages 
* @param message The message that can be read.
* @return true if the message was read (handled).
  */
  virtual bool handleMessage(InMessage& message);
};

/** 
* @class CMessageHandlerForQueueFromSimulatedRobots
*
* Handles debug messages from the simulated robots.
*
* @author Martin Ltzsch
*/
class CMessageHandlerForQueueFromSimulatedRobots : public MessageHandler
{
public:
/** 
* Called from a MessageQueue to distribute messages 
* @param message The message that can be read.
* @return true if the message was read (handled).
  */
  virtual bool handleMessage(InMessage& message);
};


/** 
* @class CMessageHandlerForQueueToGUI.
*
* Handles debug messages for the GUI.
*
* @author Martin Ltzsch
*/
class CMessageHandlerForQueueToGUI : public MessageHandler
{
public:
  /** constructor */
  CMessageHandlerForQueueToGUI(CRobotControlMainFrame& mainFrame)
    : mainFrame(mainFrame)
  {}

  /** 
  * Called from a MessageQueue to distribute messages 
  * @param message The message that can be read.
  * @return true if the message was read (handled).
  */
  virtual bool handleMessage(InMessage& message);
  
private:
  /** A reference to the application */
  CRobotControlMainFrame& mainFrame;
};


#endif //__RobotControlMessageHandler_h_

/*
* Change Log:
*
* $Log: RobotControlMessageHandler.h,v $
* Revision 1.1.1.1  2004/05/22 17:26:40  cvsadm
* created new repository GT2004_WM
*
* Revision 1.5  2004/04/17 21:50:51  roefer
* New color corrector (BB/DDD mix) used in BB2004ImageProcessor and Simulator
* Displaying corrected images as debug image
*
* Revision 1.4  2004/03/09 15:44:56  tim
* changed color correction
*
* Revision 1.3  2004/02/16 12:26:40  nistico
* Added noise reduction functionality for jpeg images in log file player
*
* Revision 1.2  2003/12/09 19:49:24  loetzsch
* Renamed some of the main queues of RobotControl.
*
* Added possibility to send messages to specific simulated or physical robots.
*
* Revision 1.1  2003/12/06 06:31:19  loetzsch
* no message
*
*/
