/**
* @file RobotControlMenu.h
*
* Declaration of the CRobotControlMenu class.
*
* @author Martin Ltzsch
* @author Jan Hoffmann
*/ 

#ifndef __RobotControlMenu_h_
#define __RobotControlMenu_h_

#include "StdAfx.h"

/**
* @class CRobotControlMenu 
*
* Handles messages and updates ui for the menu entries
* of RobotControl's main window. 
*
* @author Martin Ltzsch
* @author Jan Hoffmann
*/
class CRobotControlMenu 
{
public:
  /** Constructor */
  CRobotControlMenu();
  
  /** Deconstructor */
  ~CRobotControlMenu();

  /** Initializes the menu */
  void init();

  /** Returns a pointer to the main menu */
  CMenu* getMenu();
  
  /** 
  * Enables the controls in the menu. 
  * This function is called from the main window for all controls. 
  * @param pCmdUI An interface to the control that allows enabling/disabling, checking etc.
  */
  void updateUI(CCmdUI* pCmdUI);

  /** 
  * Handles control notifications which arrived in the main frame 
  * @param command The id of the control, menu, accelerator etc.
  * @return If the command was handled.
  */
  bool handleCommand(UINT command);

private:

  /** 
  * deletes the list of saved layouts from the menu
  */
  void hideLayoutEntries();

  /** 
  * inserts the list of saved layouts to the "windows layouts" submenu 
  */
  void showLayoutEntries();
};


#endif // __RobotControlMenu_h_

/*
* Change log :
* 
* $Log: RobotControlMenu.h,v $
* Revision 1.1.1.1  2004/05/22 17:26:39  cvsadm
* created new repository GT2004_WM
*
* Revision 1.5  2004/02/29 16:44:32  loetzsch
* renamed getCMenu() to getMenu()
*
* Revision 1.4  2004/02/26 16:31:31  loetzsch
* bug fix
*
* Revision 1.3  2004/02/23 21:35:23  jhoffman
* - message handling bug removed
* - added camera toolbar functionality to menu
*
* Revision 1.2  2004/02/23 13:27:25  jhoffman
* - changes to Main-menu are shown ... this currently results in one additional menu (!) somebody please fix this!
* - added GenericModalBinary-dialog: can be used to create a modal dialog where you can specify the button labels and the descriptive text (like APX...ModalDialog but you can specify what is written on the buttons)
* - CameraToolBar: mode, shutter, gain extracted from dropdown
* - ToolBarEx: added AddString method to write const. strings on a toolbar
*
* Revision 1.1  2004/02/13 13:29:05  loetzsch
* added class CRobotControlMenu
*
*/
