/**
* @file RobotControlMenu.cpp
*
* Implementation of the CRobotControlMenu class.
*
* @author Martin Ltzsch
* @author Jan Hoffmann
*/

#include "StdAfx.h"
#include "RobotControlMenu.h"
#include "RobotControl.h"
#include "MfcTools/IEStyleToolBars/WinAppEx.h"
#include "RobotControlConfigurationManager.h"
#include "Dialogs/GenericModalBinary.h"
#include "Dialogs/SettingNewDialog.h"
#include "MfcTools/IEStyleToolBars/FrameWndEx.h"
#include "Dialogs/GenericModalBinary.h"



CRobotControlMenu::CRobotControlMenu()
{
}

CRobotControlMenu::~CRobotControlMenu()
{
}

void CRobotControlMenu::init()
{
  CWinAppEx* pApp = CWinAppEx::GetInstance();
  CMapUIntToInt mapIDToImage;
  mapIDToImage[ IDD_DIALOG_BAR_MESSAGEVIEWER       ] = 0;
  mapIDToImage[ IDD_DIALOG_BAR_IMAGEVIEWER         ] = 14;
  mapIDToImage[ IDD_DIALOG_BAR_JOINT_VIEWER        ] = 2;
  mapIDToImage[ IDD_DIALOG_BAR_VALUE_HISTORY       ] = 16;
  mapIDToImage[ IDD_DIALOG_BAR_LARGEIMAGEVIEWER    ] = 1;
  mapIDToImage[ IDD_DIALOG_BAR_TIME_DIAGRAM        ] = 3;
  mapIDToImage[ IDD_DIALOG_BAR_HISTOGRAM           ] = 15;
  mapIDToImage[ IDD_DIALOG_BAR_COLOR_SPACE         ] = 4;
  mapIDToImage[ IDD_DIALOG_BAR_RADAR_VIEWER        ] = 5;
  mapIDToImage[ IDD_DIALOG_BAR_RADAR_VIEWER_3D     ] = 13;
  mapIDToImage[ IDD_DIALOG_BAR_COLORTABLE64        ] = 6;
  mapIDToImage[ IDD_DIALOG_BAR_HSICOLORTABLETOOL   ] = 6;
  mapIDToImage[ IDD_DIALOG_BAR_MOTIONTESTER        ] = 6;
  mapIDToImage[ IDD_DIALOG_BAR_HEADMOTIONTESTER    ] = 6;
  mapIDToImage[ IDD_DIALOG_BAR_MOFTESTER           ] = 6;
  mapIDToImage[ IDD_DIALOG_BAR_DEBUGMESSAGEGENERATOR ] = 6;
  mapIDToImage[ IDD_DIALOG_BAR_TEST_DATA_GENERATOR ] = 6;
  mapIDToImage[ IDD_DIALOG_BAR_XABSL2               ] = 6;
  mapIDToImage[ IDD_DIALOG_BAR_SETTINGS            ] = 6;
  mapIDToImage[ IDD_DIALOG_BAR_INVKINPARAMETERS    ] = 6;
  mapIDToImage[ IDD_DIALOG_BAR_TSLCOLORTABLETOOL   ] = 6;
  mapIDToImage[ IDD_DIALOG_BAR_JOYSTICKMOTIONTESTER] = 7;
  mapIDToImage[ IDD_DIALOG_BAR_UDPARAMETERSET      ] = 6;
  mapIDToImage[ IDD_DIALOG_BAR_SIMULATOR_OBJECT_VIEWER ] = 11;
  mapIDToImage[ IDD_DIALOG_BAR_KALMAN_SETTINGS     ] = 6;
  mapIDToImage[ IDD_DIALOG_BAR_KICK_EDITOR         ] = 6;
  mapIDToImage[ IDD_DIALOG_BAR_POTENTIAL_FIELD_VIEWER ] = 10;
  mapIDToImage[ IDC_MESSAGEVIEWER_CLEAR            ] = 8;
  mapIDToImage[ IDC_CLEAR_QUEUE_TO_ROBOT           ] = 8;
  mapIDToImage[ IDC_SAVE_QUEUE_TO_ROBOT            ] = 9;
  mapIDToImage[ IDC_SEND_MOTION_NET                ] =12;

  pApp->AddMenuIcon( mapIDToImage, IDB_MENU_BUTTONS );
  mapIDToImage.RemoveAll();

  showLayoutEntries();
 
  //SetMenu(NULL);
  //::DestroyMenu(m_hMenuDefault);
}

CMenu* CRobotControlMenu::getMenu()
{
  return CMenu::FromHandle(getRobotControlApp().pMainFrame->m_wndMenuBar.GetMenu());
}

void CRobotControlMenu::updateUI(CCmdUI* pCmdUI)
{
  if ((pCmdUI->m_nID >= IDC_MENU_VIEW_SCREENLAYOUT_FIRST) && (pCmdUI->m_nID < IDC_MENU_VIEW_SCREENLAYOUT_LAST))
  {
    int index = pCmdUI->m_nID - IDC_MENU_VIEW_SCREENLAYOUT_FIRST;
    CString name = getConfigurationManager().configurations[pCmdUI->m_nID - IDC_MENU_VIEW_SCREENLAYOUT_FIRST];

    if (getConfigurationManager().currentConfigurationName == getConfigurationManager().configurations[pCmdUI->m_nID - IDC_MENU_VIEW_SCREENLAYOUT_FIRST])
      pCmdUI->SetCheck(true);
    else
      pCmdUI->SetCheck(false);
  }
//  switch (pCmdUI->m_nID)
//  {
//  default:
    pCmdUI->Enable(true);
//    break;
//  }
}

bool CRobotControlMenu::handleCommand(UINT command)
{
  if ((command >= IDC_MENU_VIEW_SCREENLAYOUT_FIRST) 
    && (command <= IDC_MENU_VIEW_SCREENLAYOUT_LAST))
  {    
    getConfigurationManager().currentConfigurationName = getConfigurationManager().configurations[command - IDC_MENU_VIEW_SCREENLAYOUT_FIRST];
    getConfigurationManager().loadConfiguration();
  }
  else
    {
    switch (command)
    {
    case IDC_MENU_SCREENLAYOUT_SAVE:
      {
      getConfigurationManager().saveConfiguration();
      break;
      }
    case IDC_MENU_SCREENLAYOUT_NEW:
      {   
      CSettingNewDialog newDialog;
      newDialog.m_nameEdit = "new layout";
      if (IDCANCEL == newDialog.DoModal())
        return false;
      if (newDialog.m_nameEdit.GetLength()==0) 
        return false;
      
      LPTSTR lpsz = new TCHAR[newDialog.m_nameEdit.GetLength()+1];
      _tcscpy(lpsz, newDialog.m_nameEdit);
      CString configurationsString = AfxGetApp()->GetProfileString("Configurations", "Configurations");
      int start = configurationsString.Find(lpsz);

      if (start >= 0)
      {
        AfxMessageBox("Name already used by another layout. Please use a different name!", MB_OK);
        break;
      }

      hideLayoutEntries();
      getConfigurationManager().configurations.Add(newDialog.m_nameEdit);
      getConfigurationManager().currentConfigurationName = newDialog.m_nameEdit;
      getConfigurationManager().saveConfiguration();
      getConfigurationManager().loadConfiguration();
      showLayoutEntries();
      return true;
      }
    case IDC_MENU_SCREENLAYOUT_DELETE:
      {  
      CString message; 
      message.Format("Please confirm permanent removal of layout: \n\n        \"%s\"\n\nDelete?", getConfigurationManager().currentConfigurationName);
      CGenericModalBinary deleteDialog("Delete", "Cancel", message);
      if (IDCANCEL == deleteDialog.DoModal())
        return false;

      hideLayoutEntries();
      getConfigurationManager().deleteConfiguration();
      showLayoutEntries();
      return true;
      }
    default: 
      return false;
    }
  }
  return false;
}

void CRobotControlMenu::hideLayoutEntries()
{
  if (getMenu()->GetSubMenu(1)->GetSubMenu(0)->GetMenuItemCount() > 4)
  {
    for (int i = 0; i < getConfigurationManager().configurations.GetSize() && 
      i < (IDC_MENU_VIEW_SCREENLAYOUT_LAST - IDC_MENU_VIEW_SCREENLAYOUT_FIRST); i++)
    {
      getMenu()->GetSubMenu(1)->GetSubMenu(0)->DeleteMenu(0,MF_BYPOSITION);
    }
  }
}

void CRobotControlMenu::showLayoutEntries()
{
  for (int i = 0; i < getConfigurationManager().configurations.GetSize() && 
    i < (IDC_MENU_VIEW_SCREENLAYOUT_LAST - IDC_MENU_VIEW_SCREENLAYOUT_FIRST); i++)
  {
    getMenu()->GetSubMenu(1)->GetSubMenu(0)->InsertMenu(0, MF_BYPOSITION, 
    IDC_MENU_VIEW_SCREENLAYOUT_FIRST+i, getConfigurationManager().configurations[i]);
  }
}

/*
* Change log :
*
* $Log: RobotControlMenu.cpp,v $
* Revision 1.3  2004/05/22 21:30:11  loetzsch
* removed grid image processor2 dlg bar
*
* Revision 1.2  2004/05/22 19:21:39  loetzsch
* RobotControl cleanup
*
* Revision 1.1.1.1  2004/05/22 17:26:39  cvsadm
* created new repository GT2004_WM
*
* Revision 1.14  2004/03/22 10:19:32  tim
* added potential field viewer
*
* Revision 1.13  2004/03/17 16:18:50  thomas
* added preversion of motion optimisation with behaviour, selflocator, headcontrol and robotcontrol dialog
*
* Revision 1.12  2004/03/16 14:00:22  juengel
* Integrated Improvments from "Gnne"
* -ATH2004ERS7Behavior
* -ATHHeadControl
* -KickSelectionTable
* -KickEditor
*
* Revision 1.11  2004/03/11 14:27:32  uhrig
* KalmanBallLocator was added
*
* Revision 1.2  2004/03/07 23:39:25  juengel
* Added the KickEditorDlgBar.
*
*
* Revision 1.10  2004/02/29 16:44:32  loetzsch
* renamed getCMenu() to getMenu()
*
* Revision 1.9  2004/02/27 13:38:05  jhoffman
* - screen layout "save" works properly
* - delete now has "confirm" dialog
*
* Revision 1.8  2004/02/26 16:31:30  loetzsch
* bug fix
*
* Revision 1.7  2004/02/26 10:28:18  jhoffman
* configuration toolbar removed
*
* Revision 1.6  2004/02/25 13:41:28  jhoffman
* - removed include of "resource.h" in "stdafx.h" to force compile when "resource.h" is changed
* - layout change should work for everybody now
* - cancel works for "new" layout dialog
*
* Revision 1.5  2004/02/23 21:35:23  jhoffman
* - message handling bug removed
* - added camera toolbar functionality to menu
*
* Revision 1.4  2004/02/23 13:27:25  jhoffman
* - changes to Main-menu are shown ... this currently results in one additional menu (!) somebody please fix this!
* - added GenericModalBinary-dialog: can be used to create a modal dialog where you can specify the button labels and the descriptive text (like APX...ModalDialog but you can specify what is written on the buttons)
* - CameraToolBar: mode, shutter, gain extracted from dropdown
* - ToolBarEx: added AddString method to write const. strings on a toolbar
*
* Revision 1.3  2004/02/18 10:09:15  jhoffman
* removed combo-select bug
*
* Revision 1.2  2004/02/13 15:52:02  loetzsch
* bug fix
*
* Revision 1.1  2004/02/13 13:29:05  loetzsch
* added class CRobotControlMenu
*
*/

